/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.xml.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.pulsar.jcloud.shade.com.google.inject.name.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.xml.XMLParser;

@Singleton
public class JAXBParser
implements XMLParser {
    private Boolean prettyPrint;

    @Inject
    public JAXBParser(@Named(value="jclouds.payloads.pretty-print") String prettyPrint) {
        this.prettyPrint = Boolean.valueOf(prettyPrint);
    }

    @Override
    public String toXML(Object src) throws IOException {
        return this.toXML(src, src.getClass());
    }

    @Override
    public <T> String toXML(Object src, Class<T> type) throws IOException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)this.prettyPrint);
            StringWriter writer = new StringWriter();
            marshaller.marshal(src, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            throw new IOException("Could not marshall object", ex);
        }
    }

    @Override
    public <T> T fromXML(String xml, Class<T> type) throws IOException {
        if (xml.charAt(0) == '\ufeff') {
            xml = xml.substring(1);
        }
        try {
            StringReader reader = new StringReader(xml);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T)unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception ex) {
            throw new IOException("Could not unmarshal document into type: " + type.getSimpleName() + "\n" + xml, ex);
        }
    }
}

