/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.binders;

import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMultimap;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindCDNPurgeEmailAddressesToHeaders
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Iterable, "this binder is only valid for Iterable!");
        Preconditions.checkNotNull(request, "request");
        Iterable emails = (Iterable)input;
        String emailCSV = Joiner.on(", ").join((List)emails);
        ImmutableMultimap<String, String> headers = ImmutableMultimap.of("X-Purge-Email", emailCSV);
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders(headers)).build();
    }
}

