/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.jclouds.http.HttpRequest;
import org.jclouds.oauth.v2.config.AutoValue_OAuthScopes_NoScopes;
import org.jclouds.oauth.v2.config.AutoValue_OAuthScopes_ReadOrWriteScopes;
import org.jclouds.oauth.v2.config.AutoValue_OAuthScopes_SingleScope;

public interface OAuthScopes {
    public List<String> forRequest(HttpRequest var1);

    public static abstract class ReadOrWriteScopes
    implements OAuthScopes {
        abstract List<String> readScopes();

        abstract List<String> writeScopes();

        public static ReadOrWriteScopes create(String readScope, String writeScope) {
            return new AutoValue_OAuthScopes_ReadOrWriteScopes(ImmutableList.of(readScope), ImmutableList.of(writeScope));
        }

        @Override
        public List<String> forRequest(HttpRequest input) {
            if (input.getMethod().equals("GET") || input.getMethod().equals("HEAD")) {
                return this.readScopes();
            }
            return this.writeScopes();
        }

        ReadOrWriteScopes() {
        }
    }

    public static abstract class NoScopes
    implements OAuthScopes {
        public static NoScopes create() {
            return new AutoValue_OAuthScopes_NoScopes();
        }

        @Override
        public List<String> forRequest(HttpRequest input) {
            return ImmutableList.of();
        }

        NoScopes() {
        }
    }

    public static abstract class SingleScope
    implements OAuthScopes {
        abstract List<String> scopes();

        public static SingleScope create(String scope) {
            return new AutoValue_OAuthScopes_SingleScope(ImmutableList.of(scope));
        }

        @Override
        public List<String> forRequest(HttpRequest input) {
            return this.scopes();
        }

        SingleScope() {
        }
    }
}

