/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloud.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Qualifier;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
@Qualifier
public @interface CurrentProject {

    public static final class ClientEmail {
        public static final String DESCRIPTION = "client_email which usually looks like project_id@developer.gserviceaccount.com or project_id-extended_uid@developer.gserviceaccount.com or account@project_id.company_domain.iam.gserviceaccount.com or account@project_id.iam.gserviceaccount.com.";
        private static final Pattern PROJECT_NUMBER_PATTERN = Pattern.compile("^([0-9]+)[@-].*");
        private static final String IAM_ACCOUNT_SUFFIX = ".iam.gserviceaccount.com";

        public static String toProjectNumber(String email) {
            Matcher matcher = PROJECT_NUMBER_PATTERN.matcher(email);
            boolean isIAM = email.endsWith(IAM_ACCOUNT_SUFFIX);
            Preconditions.checkArgument(isIAM || matcher.find(), "Client email %s is malformed. Should be %s", (Object)email, (Object)DESCRIPTION);
            return isIAM ? ClientEmail.projectIdFromIAM(email) : matcher.group(1);
        }

        private static String projectIdFromIAM(String email) {
            String project_id = email.substring(email.indexOf(64) + 1, email.indexOf(IAM_ACCOUNT_SUFFIX));
            int dot = project_id.indexOf(46);
            return dot > 0 ? String.format("%s:%s", project_id.substring(dot + 1), project_id.substring(0, dot)) : project_id;
        }
    }
}

