/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;

public class AWSClientErrorRetryHandler
implements HttpRetryHandler {
    private final AWSUtils utils;
    private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
    private final Set<String> retryableCodes;

    @Inject
    public AWSClientErrorRetryHandler(AWSUtils utils, BackoffLimitedRetryHandler backoffLimitedRetryHandler, @ClientError Set<String> retryableCodes) {
        this.utils = utils;
        this.backoffLimitedRetryHandler = backoffLimitedRetryHandler;
        this.retryableCodes = retryableCodes;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if ((response.getStatusCode() == 400 || response.getStatusCode() == 403 || response.getStatusCode() == 409) && response.getPayload() != null) {
            HttpUtils.closeClientButKeepContentStream(response);
            AWSError error = this.utils.parseAWSErrorFromContent(command.getCurrentRequest(), response);
            if (error != null) {
                return this.shouldRetryRequestOnError(command, response, error);
            }
        }
        return false;
    }

    protected boolean shouldRetryRequestOnError(HttpCommand command, HttpResponse response, AWSError error) {
        if (this.retryableCodes.contains(error.getCode())) {
            return this.backoffLimitedRetryHandler.shouldRetryRequest(command, response);
        }
        return false;
    }
}

