/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import java.io.File;
import java.io.InputStream;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteSource;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.io.payloads.UrlEncodedFormPayload;

public class Payloads {
    private Payloads() {
    }

    public static Payload newPayload(Object data) {
        Preconditions.checkNotNull(data, "data");
        if (data instanceof Payload) {
            return (Payload)data;
        }
        if (data instanceof InputStream) {
            return Payloads.newInputStreamPayload((InputStream)data);
        }
        if (data instanceof byte[]) {
            return Payloads.newByteArrayPayload((byte[])data);
        }
        if (data instanceof ByteSource) {
            return Payloads.newByteSourcePayload((ByteSource)data);
        }
        if (data instanceof String) {
            return Payloads.newStringPayload((String)data);
        }
        if (data instanceof File) {
            return Payloads.newFilePayload((File)data);
        }
        throw new UnsupportedOperationException("unsupported payload type: " + data.getClass());
    }

    public static InputStreamPayload newInputStreamPayload(InputStream data) {
        return new InputStreamPayload(Preconditions.checkNotNull(data, "data"));
    }

    public static ByteArrayPayload newByteArrayPayload(byte[] data) {
        return new ByteArrayPayload(Preconditions.checkNotNull(data, "data"));
    }

    public static ByteSourcePayload newByteSourcePayload(ByteSource data) {
        return new ByteSourcePayload(Preconditions.checkNotNull(data, "data"));
    }

    public static StringPayload newStringPayload(String data) {
        return new StringPayload(Preconditions.checkNotNull(data, "data"));
    }

    public static FilePayload newFilePayload(File data) {
        return new FilePayload(Preconditions.checkNotNull(data, "data"));
    }

    public static UrlEncodedFormPayload newUrlEncodedFormPayload(Multimap<String, String> formParams) {
        return new UrlEncodedFormPayload(formParams);
    }
}

