/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.util.storageurl;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.azure.storage.config.AuthType;
import org.jclouds.azure.storage.util.storageurl.StorageUrlSupplier;
import org.jclouds.azure.storage.util.storageurl.TrailingSlashUtil;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;

@Singleton
public class StorageAccountInVhost
implements StorageUrlSupplier {
    private final Supplier<URI> endpointSupplier;
    private final Supplier<Credentials> credentialsSupplier;
    private final AuthType authType;
    private final String account;

    @Inject
    public StorageAccountInVhost(@Provider Supplier<URI> endpointSupplier, @Provider Supplier<Credentials> credentialsSupplier, AuthType authType, @Named(value="jclouds.azureblob.account") String account) {
        this.endpointSupplier = endpointSupplier;
        this.credentialsSupplier = credentialsSupplier;
        this.authType = authType;
        this.account = account;
    }

    @Override
    public URI get() {
        URI endpoint = this.endpointSupplier.get();
        String uri = endpoint == null ? this.buildUri() : TrailingSlashUtil.ensureTrailingSlash(endpoint);
        return URI.create(uri);
    }

    private String buildUri() {
        String account = this.account;
        if (account == null) {
            account = this.credentialsSupplier.get().identity;
        }
        return "https://" + account + ".blob.core.windows.net/";
    }
}

