/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import java.net.URI;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.location.Zone;

public final class ZoneToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> zoneToEndpoints;

    @Inject
    ZoneToEndpoint(@Zone Supplier<Map<String, Supplier<URI>>> zoneToEndpoints) {
        this.zoneToEndpoints = zoneToEndpoints;
    }

    @Override
    public URI apply(Object from) {
        Map<String, Supplier<URI>> zoneToEndpoint = this.zoneToEndpoints.get();
        Preconditions.checkState(!zoneToEndpoint.isEmpty(), "no zone name to endpoint mappings configured!");
        Preconditions.checkArgument(zoneToEndpoint.containsKey(from), "requested location %s, which is not a configured zone: %s", from, zoneToEndpoint);
        return zoneToEndpoint.get(from).get();
    }
}

