/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public class HeapDumpUtil {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

    private static HotSpotDiagnosticMXBean getHotSpotDiagnosticMXBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void dumpHeap(File file, boolean liveObjects) {
        try {
            HotSpotDiagnosticMXBean hotspotMBean = HeapDumpUtil.getHotSpotDiagnosticMXBean();
            hotspotMBean.dumpHeap(file.getAbsolutePath(), liveObjects);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating heap dump", e);
        }
    }
}

