/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class TestRetrySupport {
    private static final Logger LOG = LoggerFactory.getLogger(TestRetrySupport.class);
    private int currentSetupNumber;
    private int failedSetupNumber = -1;
    private int cleanedUpSetupNumber;

    @BeforeMethod(alwaysRun=true)
    public final void stateCheck(Method method) throws Exception {
        if (this.currentSetupNumber == this.failedSetupNumber && this.cleanedUpSetupNumber != this.failedSetupNumber) {
            LOG.info("Previous test run has failed before {}.{}, failedSetupNumber={}. Running cleanup and setup.", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), this.failedSetupNumber});
            try {
                this.cleanup();
            }
            catch (Exception e) {
                LOG.error("Cleanup failed, ignoring this.", (Throwable)e);
            }
            this.setup();
            LOG.info("State cleanup finished.");
            this.failedSetupNumber = -1;
        }
    }

    @AfterMethod(alwaysRun=true)
    public final void failureCheck(ITestResult testResult, Method method) {
        if (!testResult.isSuccess()) {
            LOG.info("Detected test failure in test {}.{}, currentSetupNumber={}", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), this.currentSetupNumber});
            this.failedSetupNumber = this.currentSetupNumber;
        }
    }

    protected final void incrementSetupNumber() {
        ++this.currentSetupNumber;
        this.failedSetupNumber = -1;
        LOG.debug("currentSetupNumber={}", (Object)this.currentSetupNumber);
    }

    protected final void markCurrentSetupNumberCleaned() {
        this.cleanedUpSetupNumber = this.currentSetupNumber;
        LOG.debug("cleanedUpSetupNumber={}", (Object)this.cleanedUpSetupNumber);
    }

    protected abstract void setup() throws Exception;

    protected abstract void cleanup() throws Exception;
}

