/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.pluto.maven.AbstractPortletMojo;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.assemble.Assembler;
import org.apache.pluto.util.assemble.AssemblerConfig;
import org.apache.pluto.util.assemble.AssemblerFactory;

public class AssembleMojo
extends AbstractPortletMojo {
    private File portletXml;
    private File webXml;
    private File webXmlDestination;
    private String dispatchServletClass;
    private List archives;
    private List warFiles;
    private File assemblyOutputDirectory;
    private File warFilesDestination;

    @Override
    protected void doExecute() throws MojoExecutionException {
        Log log = this.getLog();
        if (log.isInfoEnabled() && (this.archives == null || this.archives.isEmpty())) {
            log.info((CharSequence)("Reading web.xml from :" + this.webXml.getAbsolutePath()));
            log.info((CharSequence)("Reading portlet.xml from: " + this.portletXml.getAbsolutePath()));
            log.info((CharSequence)("Writing web.xml to: " + this.webXmlDestination.getAbsolutePath()));
        }
        try {
            if (this.archives == null || this.archives.isEmpty()) {
                AssemblerConfig config = this.createAssemblerConfig();
                Assembler assembler = AssemblerFactory.getFactory().createAssembler(config);
                assembler.assemble(config);
            } else {
                Iterator i = this.archives.iterator();
                while (i.hasNext()) {
                    File archive = new File(i.next().toString());
                    if (log.isInfoEnabled()) {
                        log.info((CharSequence)("Assembling archive file " + archive.getAbsolutePath() + " to directory " + this.assemblyOutputDirectory.getAbsolutePath()));
                    }
                    AssemblerConfig config = this.createArchiveAssemblerConfig(archive, this.assemblyOutputDirectory);
                    Assembler assembler = AssemblerFactory.getFactory().createAssembler(config);
                    assembler.assemble(config);
                }
            }
        }
        catch (UtilityException e) {
            log.error((CharSequence)("Assembly failed: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    protected void doValidate() throws MojoExecutionException {
        block20: {
            Log log = this.getLog();
            if (this.warFiles != null && !this.warFiles.isEmpty()) {
                log.warn((CharSequence)"'warFiles' parameter is deprecated.  Use 'archives' parameter instead.");
                if (this.archives == null) {
                    this.archives = new ArrayList();
                }
                this.archives.addAll(this.warFiles);
            }
            if (this.warFilesDestination != null) {
                log.warn((CharSequence)"'warFilesDestination' parameter is deprecated.  Use 'assemblyOutputDirectory' instead.");
                this.assemblyOutputDirectory = this.warFilesDestination;
            }
            if (this.archives != null && !this.archives.isEmpty()) {
                if (this.webXml != null) {
                    log.debug((CharSequence)"archives parameter and webXml parameter are mutually exclusive.  Ignoring webXml parameter.");
                }
                if (this.portletXml != null) {
                    log.debug((CharSequence)"archives parameter and portletXml parameter are mutually exclusive.  Ignoring portletXml parameter.");
                }
                if (this.webXmlDestination != null) {
                    log.debug((CharSequence)"archives parameter and webXmlDestination parameter are mutually exclusive.  Ignoring webXmlDestination parameter.");
                }
                Iterator i = this.archives.iterator();
                while (i.hasNext()) {
                    File f = new File(i.next().toString());
                    if (!f.exists()) {
                        log.warn((CharSequence)("File " + f.getAbsolutePath() + " does not exist."));
                        i.remove();
                        continue;
                    }
                    if (f.canRead()) continue;
                    log.warn((CharSequence)("File " + f.getAbsolutePath() + " exists but cannot be read."));
                    i.remove();
                }
                if (this.archives.isEmpty()) {
                    throw new MojoExecutionException("No war files could be installed due errors.");
                }
                if (!this.assemblyOutputDirectory.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Creating destination directory for assembled war files: " + this.assemblyOutputDirectory.getAbsolutePath()));
                    }
                    try {
                        if (!this.assemblyOutputDirectory.mkdirs()) {
                            throw new MojoExecutionException("Unable to create destination directory for assembled war files: " + this.assemblyOutputDirectory.getAbsolutePath());
                        }
                        break block20;
                    }
                    catch (SecurityException e) {
                        throw new MojoExecutionException("Unable to create destination directory for assembled war files: " + e.getMessage(), (Exception)e);
                    }
                }
                if (!this.assemblyOutputDirectory.isDirectory()) {
                    throw new MojoExecutionException("Specified destination for assembled war files " + this.assemblyOutputDirectory.getAbsolutePath() + " is not a directory!");
                }
                if (!this.assemblyOutputDirectory.canRead() || !this.assemblyOutputDirectory.canWrite()) {
                    throw new MojoExecutionException("Unable to read or write to destination directory for assembed war files.  Check permissions on the directory " + this.assemblyOutputDirectory.getAbsolutePath());
                }
            } else {
                if (this.webXml == null || !this.webXml.exists()) {
                    throw new MojoExecutionException("Web application descriptor must be a valid web.xml");
                }
                if (this.portletXml == null || !this.portletXml.exists()) {
                    throw new MojoExecutionException("Portlet descriptor must be a valid portlet.xml");
                }
            }
        }
    }

    private AssemblerConfig createAssemblerConfig() {
        AssemblerConfig config = new AssemblerConfig();
        config.setPortletDescriptor(this.portletXml);
        config.setWebappDescriptor(this.webXml);
        config.setDestination(this.webXmlDestination);
        config.setDispatchServletClass(this.dispatchServletClass);
        return config;
    }

    private AssemblerConfig createArchiveAssemblerConfig(File archiveToAssemble, File destinationDirectory) {
        AssemblerConfig config = new AssemblerConfig();
        config.setDispatchServletClass(this.dispatchServletClass);
        config.setSource(archiveToAssemble);
        config.setDestination(destinationDirectory);
        return config;
    }
}

