/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ClientDataRequest;
import javax.portlet.HeaderRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.pluto.container.ContainerServices;
import org.apache.pluto.container.NamespaceMapper;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResourceRequestContext;
import org.apache.pluto.container.PortletWindowID;
import org.apache.pluto.container.impl.PortletRequestDispatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletPortletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServletPortletRequestWrapper.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final String ENABLE_NESTED_RESOURCE_FORWARDS = "org.apache.pluto.enable.nested.resource.forwards";
    private static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    private static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    private static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    private static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    private static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    private static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    private static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    private static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    private static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    private static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    private final Map<String, String> origin = new HashMap<String, String>();
    private final ArrayList<DispatchElement> dispatches;
    private final PortletRequest preq;
    private boolean isMethSpecialHandling;
    private boolean isAttrSpecialHandling;
    private boolean isClosed;
    private final HttpSession session;
    private final PortletRequestContext reqctx;
    private final NamespaceMapper mapper;
    private final PortletWindowID winId;
    private final String phase;
    private boolean isLogged;

    public HttpServletPortletRequestWrapper(HttpServletRequest hreq, HttpSession session, PortletRequest preq) {
        super(hreq);
        this.origin.put(FORWARD_CONTEXT_PATH, null);
        this.origin.put(FORWARD_PATH_INFO, null);
        this.origin.put(FORWARD_QUERY_STRING, null);
        this.origin.put(FORWARD_REQUEST_URI, null);
        this.origin.put(FORWARD_SERVLET_PATH, null);
        this.dispatches = new ArrayList();
        this.isMethSpecialHandling = false;
        this.isAttrSpecialHandling = false;
        this.isClosed = true;
        this.isLogged = false;
        this.preq = preq;
        this.session = session;
        this.reqctx = (PortletRequestContext)preq.getAttribute(PortletInvokerService.REQUEST_CONTEXT);
        this.mapper = this.reqctx.getContainer().getContainerServices().getNamespaceMapper();
        this.winId = this.reqctx.getPortletWindow().getId();
        this.phase = (String)preq.getAttribute("javax.portlet.lifecycle_phase");
    }

    private HttpServletRequest getHreq() {
        return (HttpServletRequest)this.getRequest();
    }

    private void handleServletPathInfo() {
        String sp = null;
        if (this.dispatches.size() == 1) {
            if (this.dispatches.get((int)0).type == Type.INC || !this.isForwardingPossible()) {
                sp = (String)this.getHreq().getAttribute(INCLUDE_SERVLET_PATH);
            } else if (this.dispatches.get((int)0).type == Type.FWD) {
                sp = this.getHreq().getServletPath();
            }
            String osp = this.origin.get(FORWARD_SERVLET_PATH);
            if (sp != null && !sp.equals(osp)) {
                if (!osp.startsWith(sp)) {
                    if (isTrace) {
                        StringBuilder txt = new StringBuilder(128);
                        txt.append("Servlet path from method not substring of original path.");
                        txt.append(" original: ").append(osp);
                        txt.append(", current: ").append(sp);
                        LOG.trace(txt.toString());
                    }
                } else {
                    String pathinfo = osp.substring(sp.length());
                    pathinfo = pathinfo.length() == 0 ? null : pathinfo;
                    this.origin.put(FORWARD_SERVLET_PATH, sp);
                    this.origin.put(FORWARD_PATH_INFO, pathinfo);
                    if (isDebug) {
                        StringBuilder txt = new StringBuilder(128);
                        txt.append(": servlet path (httpreq): ").append(sp);
                        txt.append(", servlet path (origin): ").append(this.origin.get(FORWARD_SERVLET_PATH));
                        txt.append(", path info: ").append(this.origin.get(FORWARD_PATH_INFO));
                        txt.append(", req URI: ").append(this.origin.get(FORWARD_REQUEST_URI));
                        txt.append(", context path: ").append(this.origin.get(FORWARD_CONTEXT_PATH));
                        txt.append(", query string: ").append(this.origin.get(FORWARD_QUERY_STRING));
                        LOG.debug(txt.toString());
                    }
                }
            }
        }
    }

    private Map<String, List<String>> processPath(String path) {
        HashMap<String, List<String>> qp = new HashMap<String, List<String>>();
        if (path != null) {
            int ii;
            String[] pq = path.split("\\?", 2);
            if (this.dispatches.size() == 0) {
                String ctxpath = this.getHreq().getServletContext().getContextPath();
                this.origin.put(FORWARD_CONTEXT_PATH, ctxpath);
                this.origin.put(FORWARD_REQUEST_URI, ctxpath + pq[0]);
                this.origin.put(FORWARD_SERVLET_PATH, pq[0]);
                if (pq.length > 1) {
                    this.origin.put(FORWARD_QUERY_STRING, pq[1]);
                }
            } else if (this.dispatches.size() == 1) {
                this.handleServletPathInfo();
            }
            if (pq.length == 2 && pq[1].length() > 0) {
                String[] params;
                for (String param : params = pq[1].split("&")) {
                    String[] nv = param.split("=", 2);
                    String name = nv[0];
                    String val = nv.length == 2 ? nv[1] : "";
                    ArrayList<String> vals = (ArrayList<String>)qp.get(name);
                    if (vals == null) {
                        vals = new ArrayList<String>();
                        qp.put(name, vals);
                    }
                    vals.add(val);
                }
            }
            if ((ii = this.dispatches.size() - 1) >= 0) {
                Map<String, List<String>> oqps = this.dispatches.get((int)ii).qparms;
                for (String name : oqps.keySet()) {
                    ArrayList vals = (ArrayList)qp.get(name);
                    if (vals == null) {
                        vals = new ArrayList();
                        qp.put(name, vals);
                    }
                    vals.addAll(oqps.get(name));
                }
            }
        }
        this.isLogged = false;
        return qp;
    }

    private void logSetupValues() {
        if (isTrace) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Wrapper initialized.");
            txt.append(" dispatches.size(): ").append(this.dispatches.size());
            if (this.dispatches.size() > 0) {
                DispatchElement de = this.dispatches.get(this.dispatches.size() - 1);
                txt.append("\nType: ").append((Object)de.type);
                txt.append(", Path: ").append(de.path);
                txt.append(", meth special: ").append(this.isMethSpecialHandling);
                txt.append(", attrib special: ").append(this.isAttrSpecialHandling);
                txt.append(", fwd possible: ").append(this.isForwardingPossible());
                txt.append(", isClosed: ").append(this.isClosed);
                txt.append("\nQuery String names: ");
                String sep = "";
                for (String name : de.qparms.keySet()) {
                    txt.append(sep).append(name);
                    txt.append(", vals: ").append(de.qparms.get(name).toString());
                    sep = ", ";
                }
                ArrayList<String> attrNames = Collections.list(this.getAttributeNames());
                txt.append("\nAttribute names: ").append(attrNames);
                txt.append("\norigin_request_uri:    ").append(this.origin.get(FORWARD_REQUEST_URI));
                txt.append("\norigin_context_path:   ").append(this.origin.get(FORWARD_CONTEXT_PATH));
                txt.append("\norigin_servlet_path:   ").append(this.origin.get(FORWARD_SERVLET_PATH));
                txt.append("\norigin_path_info:      ").append(this.origin.get(FORWARD_PATH_INFO));
                txt.append("\norigin_query_string:   ").append(this.origin.get(FORWARD_QUERY_STRING));
            }
            LOG.debug(txt.toString());
        }
    }

    private void logPathValues() {
        if (isTrace && !this.isLogged) {
            this.isLogged = true;
            StringBuilder txt = new StringBuilder(128);
            txt.append("Path values:");
            txt.append("\nasync_request_uri:    ").append((String)this.getAttribute("javax.servlet.async.request_uri"));
            txt.append("\nasync_context_path:   ").append((String)this.getAttribute("javax.servlet.async.context_path"));
            txt.append("\nasync_servlet_path:   ").append((String)this.getAttribute("javax.servlet.async.servlet_path"));
            txt.append("\nasync_path_info:      ").append((String)this.getAttribute("javax.servlet.async.path_info"));
            txt.append("\nasync_query_string:   ").append((String)this.getAttribute("javax.servlet.async.query_string"));
            txt.append("\nforward_request_uri:  ").append((String)this.getAttribute(FORWARD_REQUEST_URI));
            txt.append("\nforward_context_path: ").append((String)this.getAttribute(FORWARD_CONTEXT_PATH));
            txt.append("\nforward_servlet_path: ").append((String)this.getAttribute(FORWARD_SERVLET_PATH));
            txt.append("\nforward_path_info:    ").append((String)this.getAttribute(FORWARD_PATH_INFO));
            txt.append("\nforward_query_string: ").append((String)this.getAttribute(FORWARD_QUERY_STRING));
            txt.append("\ninclude_request_uri:  ").append((String)this.getAttribute(INCLUDE_REQUEST_URI));
            txt.append("\ninclude_context_path: ").append((String)this.getAttribute(INCLUDE_CONTEXT_PATH));
            txt.append("\ninclude_servlet_path: ").append((String)this.getAttribute(INCLUDE_SERVLET_PATH));
            txt.append("\ninclude_path_info:    ").append((String)this.getAttribute(INCLUDE_PATH_INFO));
            txt.append("\ninclude_query_string: ").append((String)this.getAttribute(INCLUDE_QUERY_STRING));
            txt.append("\nmethod_request_uri:   ").append(this.getRequestURI());
            txt.append("\nmethod_context_path:  ").append(this.getContextPath());
            txt.append("\nmethod_servlet_path:  ").append(this.getServletPath());
            txt.append("\nmethod_path_info:     ").append(this.getPathInfo());
            txt.append("\nmethod_query_string:  ").append(this.getQueryString());
            txt.append("\n\nPath values (from wrapped servlet request):");
            txt.append("\nasync_request_uri:    ").append((String)this.getHreq().getAttribute("javax.servlet.async.request_uri"));
            txt.append("\nasync_context_path:   ").append((String)this.getHreq().getAttribute("javax.servlet.async.context_path"));
            txt.append("\nasync_servlet_path:   ").append((String)this.getHreq().getAttribute("javax.servlet.async.servlet_path"));
            txt.append("\nasync_path_info:      ").append((String)this.getHreq().getAttribute("javax.servlet.async.path_info"));
            txt.append("\nasync_query_string:   ").append((String)this.getHreq().getAttribute("javax.servlet.async.query_string"));
            txt.append("\nforward_request_uri:  ").append((String)this.getHreq().getAttribute(FORWARD_REQUEST_URI));
            txt.append("\nforward_context_path: ").append((String)this.getHreq().getAttribute(FORWARD_CONTEXT_PATH));
            txt.append("\nforward_servlet_path: ").append((String)this.getHreq().getAttribute(FORWARD_SERVLET_PATH));
            txt.append("\nforward_path_info:    ").append((String)this.getHreq().getAttribute(FORWARD_PATH_INFO));
            txt.append("\nforward_query_string: ").append((String)this.getHreq().getAttribute(FORWARD_QUERY_STRING));
            txt.append("\ninclude_request_uri:  ").append((String)this.getHreq().getAttribute(INCLUDE_REQUEST_URI));
            txt.append("\ninclude_context_path: ").append((String)this.getHreq().getAttribute(INCLUDE_CONTEXT_PATH));
            txt.append("\ninclude_servlet_path: ").append((String)this.getHreq().getAttribute(INCLUDE_SERVLET_PATH));
            txt.append("\ninclude_path_info:    ").append((String)this.getHreq().getAttribute(INCLUDE_PATH_INFO));
            txt.append("\ninclude_query_string: ").append((String)this.getHreq().getAttribute(INCLUDE_QUERY_STRING));
            txt.append("\nmethod_request_uri:   ").append(this.getHreq().getRequestURI());
            txt.append("\nmethod_context_path:  ").append(this.getHreq().getContextPath());
            txt.append("\nmethod_servlet_path:  ").append(this.getHreq().getServletPath());
            txt.append("\nmethod_path_info:     ").append(this.getHreq().getPathInfo());
            txt.append("\nmethod_query_string:  ").append(this.getHreq().getQueryString());
            LOG.debug(txt.toString());
        }
    }

    public void startInclude(String path) {
        DispatchElement de = new DispatchElement();
        de.path = path;
        de.type = Type.INC;
        de.qparms = this.processPath(path);
        this.dispatches.add(de);
        this.isMethSpecialHandling = true;
        this.isAttrSpecialHandling = true;
        for (int ii = 1; ii < this.dispatches.size(); ++ii) {
            if (this.dispatches.get((int)ii).type == Type.INC) continue;
            this.isMethSpecialHandling = false;
        }
        this.reqctx.startDispatch((HttpServletRequest)this, de.qparms, this.phase);
        this.isClosed = false;
        this.logSetupValues();
    }

    public void startForward(String path) {
        DispatchElement de = new DispatchElement();
        de.path = path;
        de.type = Type.FWD;
        de.qparms = this.processPath(path);
        this.dispatches.add(de);
        this.isMethSpecialHandling = true;
        PortletContainer portletContainer = this.reqctx.getContainer();
        ContainerServices containerServices = portletContainer.getContainerServices();
        PortalContext portalContext = containerServices.getPortalContext();
        boolean enableNestedResourceForwards = Boolean.valueOf(portalContext.getProperty(ENABLE_NESTED_RESOURCE_FORWARDS));
        if (!enableNestedResourceForwards) {
            PortletConfig portletConfig = this.reqctx.getPortletConfig();
            enableNestedResourceForwards = Boolean.valueOf(portletConfig.getInitParameter(ENABLE_NESTED_RESOURCE_FORWARDS));
        }
        if (enableNestedResourceForwards) {
            this.isMethSpecialHandling = !this.isForwardingPossible();
        }
        this.isAttrSpecialHandling = true;
        this.reqctx.startDispatch((HttpServletRequest)this, de.qparms, this.phase);
        this.isClosed = false;
        this.logSetupValues();
    }

    public void startAsyncDispatch(String path) {
        DispatchElement de = new DispatchElement();
        de.path = path;
        de.type = Type.ASYNC_DISPATCH;
        de.qparms = this.processPath(path);
        this.dispatches.add(de);
        this.isMethSpecialHandling = false;
        this.isAttrSpecialHandling = false;
        this.reqctx.startDispatch((HttpServletRequest)this, de.qparms, this.phase);
        this.isClosed = false;
        this.logSetupValues();
    }

    public void startAsyncProcessing() {
        DispatchElement de = new DispatchElement();
        de.path = null;
        de.type = Type.ASYNC_PROCESSING;
        de.qparms = Collections.emptyMap();
        this.dispatches.add(de);
        this.isMethSpecialHandling = false;
        this.isAttrSpecialHandling = false;
        this.isClosed = false;
        this.reqctx.setAsyncServletRequest((HttpServletRequest)this);
        this.logSetupValues();
    }

    public void endAsyncProcessing() {
        if (isTrace) {
            ArrayList<String> types = new ArrayList<String>();
            for (int ii = this.dispatches.size() - 1; ii >= 0; --ii) {
                types.add(this.dispatches.get((int)ii).type.toString());
            }
            StringBuilder txt = new StringBuilder();
            txt.append("Ending async processing.");
            txt.append(" remaining dispatch stack: ").append(types.toString());
            LOG.debug(txt.toString());
        }
        this.dispatches.clear();
        this.isClosed = true;
        this.reqctx.setAsyncServletRequest(null);
    }

    public void startNamed(String path) {
        DispatchElement de = new DispatchElement();
        de.path = path;
        de.type = Type.NAMED;
        de.qparms = this.processPath(path);
        this.dispatches.add(de);
        this.isMethSpecialHandling = false;
        this.isAttrSpecialHandling = false;
        this.isClosed = false;
        this.logSetupValues();
    }

    public void endDispatch() {
        DispatchElement oldde = null;
        if (this.dispatches.size() > 0) {
            oldde = this.dispatches.remove(this.dispatches.size() - 1);
        }
        this.reqctx.endDispatch();
        if (this.dispatches.size() > 0) {
            DispatchElement de = this.dispatches.get(this.dispatches.size() - 1);
            if (de.type == Type.INC || de.type == Type.FWD) {
                this.reqctx.startDispatch((HttpServletRequest)this, de.qparms, this.phase);
            }
        } else {
            this.isClosed = true;
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Ending dispatch.");
            txt.append(" dispatched type: ").append((Object)oldde.type);
            txt.append(",  # remaining nesting levels: ").append(this.dispatches.size());
            if (!this.dispatches.isEmpty()) {
                txt.append(",  active dispatch type: ");
                txt.append((Object)this.dispatches.get((int)(this.dispatches.size() - 1)).type);
            }
            LOG.debug(txt.toString());
        }
    }

    boolean isForwardingPossible() {
        return this.preq instanceof ResourceRequest;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.isClosed) {
            return Collections.emptyMap();
        }
        Map pm = this.reqctx.getParameterMap();
        return pm;
    }

    public String getParameter(String name) {
        if (this.isClosed) {
            return null;
        }
        Map pm = this.reqctx.getParameterMap();
        String[] vals = (String[])pm.get(name);
        return vals == null ? null : vals[0];
    }

    public Enumeration<String> getParameterNames() {
        if (this.isClosed) {
            return Collections.emptyEnumeration();
        }
        Map pm = this.reqctx.getParameterMap();
        return Collections.enumeration(pm.keySet());
    }

    public String[] getParameterValues(String name) {
        if (this.isClosed) {
            return null;
        }
        Map pm = this.reqctx.getParameterMap();
        return (String[])pm.get(name);
    }

    public String getContextPath() {
        if (this.isClosed) {
            return null;
        }
        this.handleServletPathInfo();
        String val = this.isMethSpecialHandling ? this.origin.get(FORWARD_CONTEXT_PATH) : this.getHreq().getContextPath();
        return val;
    }

    public String getPathInfo() {
        if (this.isClosed) {
            return null;
        }
        this.handleServletPathInfo();
        String val = this.isMethSpecialHandling ? this.origin.get(FORWARD_PATH_INFO) : this.getHreq().getPathInfo();
        return val;
    }

    public String getPathTranslated() {
        if (this.isClosed) {
            return null;
        }
        this.handleServletPathInfo();
        String pinfo = this.getPathInfo();
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Returning real path for: ").append(pinfo);
            LOG.trace(txt.toString());
        }
        if (pinfo != null && this.isMethSpecialHandling && this.origin.get(FORWARD_CONTEXT_PATH).equals(this.preq.getContextPath())) {
            return this.getHreq().getServletContext().getRealPath(pinfo);
        }
        return null;
    }

    public String getQueryString() {
        if (this.isClosed) {
            return null;
        }
        this.handleServletPathInfo();
        String val = this.isMethSpecialHandling ? this.origin.get(FORWARD_QUERY_STRING) : this.getHreq().getQueryString();
        return val;
    }

    public String getRequestURI() {
        if (this.isClosed) {
            return null;
        }
        this.handleServletPathInfo();
        String val = this.isMethSpecialHandling ? this.origin.get(FORWARD_REQUEST_URI) : this.getHreq().getRequestURI();
        return val;
    }

    public String getServletPath() {
        if (this.isClosed) {
            return null;
        }
        this.handleServletPathInfo();
        String val = this.isMethSpecialHandling ? this.origin.get(FORWARD_SERVLET_PATH) : this.getHreq().getServletPath();
        return val;
    }

    public Object getAttribute(String name) {
        if (this.isClosed) {
            return null;
        }
        this.handleServletPathInfo();
        if (!this.isAttrSpecialHandling || !this.origin.containsKey(name)) {
            boolean encoded = true;
            Object val = this.getRequest().getAttribute(this.mapper.encode(this.winId, name));
            if (val == null) {
                val = this.getRequest().getAttribute(name);
                encoded = false;
            }
            if (isTrace) {
                StringBuilder txt = new StringBuilder();
                txt.append("Getting: ");
                txt.append(name).append(", value: ").append(val == null ? "null" : val.toString());
                txt.append(", encoded: ").append(encoded);
                LOG.debug(txt.toString());
            }
            return val;
        }
        String val = this.origin.get(name);
        if (name.equals("javax.portlet.config")) {
            this.logPathValues();
        }
        return val;
    }

    public void setAttribute(String name, Object o) {
        if (this.isClosed) {
            return;
        }
        if (this.origin.containsKey(name)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Attempt to set protected attribute ").append(name);
            txt.append(" will be ignored.");
            LOG.warn(txt.toString());
        } else {
            boolean encoded = false;
            Object val = this.getRequest().getAttribute(this.mapper.encode(this.winId, name));
            if (val != null) {
                this.getRequest().setAttribute(this.mapper.encode(this.winId, name), o);
                encoded = true;
            } else {
                this.getRequest().setAttribute(name, o);
            }
            if (isTrace) {
                StringBuilder txt = new StringBuilder();
                txt.append("Setting: ");
                txt.append(name).append(", value: ").append(o == null ? "null" : o.toString());
                txt.append(", encoded: ").append(encoded);
                LOG.debug(txt.toString());
            }
        }
        this.handleServletPathInfo();
    }

    public void removeAttribute(String name) {
        if (this.isClosed) {
            return;
        }
        this.handleServletPathInfo();
        if (this.origin.containsKey(name)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Attempt to remove protected attribute ").append(name);
            txt.append(" will be ignored.");
            LOG.warn(txt.toString());
        } else {
            boolean encoded = false;
            Object val = this.getRequest().getAttribute(this.mapper.encode(this.winId, name));
            if (val != null) {
                this.getRequest().removeAttribute(this.mapper.encode(this.winId, name));
                encoded = true;
            } else {
                this.getRequest().removeAttribute(name);
            }
            if (isTrace) {
                StringBuilder txt = new StringBuilder();
                txt.append("Removing: ");
                txt.append(name);
                txt.append(", encoded: ").append(encoded);
                LOG.debug(txt.toString());
            }
        }
    }

    public Enumeration<String> getAttributeNames() {
        if (this.isClosed) {
            return Collections.emptyEnumeration();
        }
        this.handleServletPathInfo();
        ArrayList<String> names = new ArrayList<String>();
        if (this.isAttrSpecialHandling) {
            for (String name : this.origin.keySet()) {
                if (this.origin.get(name) == null) continue;
                names.add(name);
            }
        }
        Enumeration rawnames = this.getRequest().getAttributeNames();
        for (String name : Collections.list(rawnames)) {
            String dn = this.mapper.decode(this.winId, name);
            if (dn != null) {
                names.add(dn);
                continue;
            }
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher dispatcher;
        if (this.isClosed) {
            return null;
        }
        if (path != null && (dispatcher = super.getRequestDispatcher(path)) != null) {
            return new PortletRequestDispatcherImpl(dispatcher, path, false);
        }
        return null;
    }

    public long getDateHeader(String name) {
        if (this.isClosed) {
            return -1L;
        }
        String value = this.preq.getProperty(name);
        if (value == null) {
            return -1L;
        }
        return this.getHreq().getDateHeader(name);
    }

    public String getAuthType() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getAuthType();
    }

    public Cookie[] getCookies() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getCookies();
    }

    public String getHeader(String name) {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getProperty(name);
    }

    public Enumeration<String> getHeaderNames() {
        if (this.isClosed) {
            return Collections.emptyEnumeration();
        }
        return this.preq.getPropertyNames();
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.isClosed) {
            return Collections.emptyEnumeration();
        }
        return this.preq.getProperties(name);
    }

    public int getIntHeader(String name) {
        if (this.isClosed) {
            return -1;
        }
        String property = this.preq.getProperty(name);
        if (property == null) {
            return -1;
        }
        return Integer.parseInt(property);
    }

    public String getMethod() {
        if (this.isClosed) {
            return "GET";
        }
        String meth = this.preq instanceof HeaderRequest || this.preq instanceof RenderRequest ? "GET" : this.getHreq().getMethod();
        return meth;
    }

    public HttpSession getSession() {
        if (this.isClosed) {
            return null;
        }
        return this.session != null ? this.session : super.getSession();
    }

    public HttpSession getSession(boolean create) {
        if (this.isClosed) {
            return null;
        }
        return this.session != null ? this.session : super.getSession(create);
    }

    public String getRemoteUser() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getRemoteUser();
    }

    public String getRequestedSessionId() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getRequestedSessionId();
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public Principal getUserPrincipal() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getUserPrincipal();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.isClosed) {
            return false;
        }
        return this.preq.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String role) {
        if (this.isClosed) {
            return false;
        }
        return this.preq.isUserInRole(role);
    }

    public String getCharacterEncoding() {
        if (this.isClosed) {
            return null;
        }
        if (this.preq instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.preq).getCharacterEncoding();
        }
        return null;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.isClosed) {
            return;
        }
        if (this.preq instanceof ClientDataRequest) {
            ((ClientDataRequest)this.preq).setCharacterEncoding(enc);
        }
    }

    public int getContentLength() {
        if (this.isClosed) {
            return 0;
        }
        if (this.preq instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.preq).getContentLength();
        }
        return 0;
    }

    public long getContentLengthLong() {
        if (this.isClosed) {
            return 0L;
        }
        if (this.preq instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.preq).getContentLengthLong();
        }
        return 0L;
    }

    public String getContentType() {
        if (this.isClosed) {
            return null;
        }
        if (this.preq instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.preq).getContentType();
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.isClosed) {
            return null;
        }
        if (this.preq instanceof ClientDataRequest) {
            return (ServletInputStream)((ClientDataRequest)this.preq).getPortletInputStream();
        }
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public Locale getLocale() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getLocales();
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public BufferedReader getReader() throws IOException {
        if (this.preq instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.preq).getReader();
        }
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getScheme() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getScheme();
    }

    public String getServerName() {
        if (this.isClosed) {
            return null;
        }
        return this.preq.getServerName();
    }

    public int getServerPort() {
        if (this.isClosed) {
            return 0;
        }
        return this.preq.getServerPort();
    }

    public boolean isSecure() {
        if (this.isClosed) {
            return false;
        }
        return this.preq.isSecure();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.dispatches.isEmpty() && this.dispatches.get((int)0).type == Type.ASYNC_PROCESSING) {
            return ((PortletResourceRequestContext)this.reqctx).startAsync();
        }
        StringBuilder txt = new StringBuilder(128);
        txt.append("The async context cannot be initialized after a ");
        txt.append("include or forward from a portlet resource request method. ");
        txt.append("The first async context initialization must be performed within the portlet resource method.");
        throw new IllegalStateException(txt.toString());
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) throws IllegalStateException {
        if (!this.dispatches.isEmpty() && this.dispatches.get((int)0).type == Type.ASYNC_PROCESSING) {
            return ((PortletResourceRequestContext)this.reqctx).startAsync(request, response);
        }
        StringBuilder txt = new StringBuilder(128);
        txt.append("The async context cannot be initialized after a ");
        txt.append("include or forward from a portlet resource request method. ");
        txt.append("The first async context initialization must be performed within the portlet resource method.");
        throw new IllegalStateException(txt.toString());
    }

    public boolean isAsyncStarted() {
        if (!this.dispatches.isEmpty() && this.dispatches.get((int)0).type == Type.ASYNC_PROCESSING) {
            return ((PortletResourceRequestContext)this.reqctx).isAsyncStarted();
        }
        return false;
    }

    public boolean isAsyncSupported() {
        if (!this.dispatches.isEmpty() && this.dispatches.get((int)0).type == Type.ASYNC_PROCESSING) {
            return ((PortletResourceRequestContext)this.reqctx).isAsyncSupported();
        }
        return false;
    }

    public AsyncContext getAsyncContext() {
        if (!this.dispatches.isEmpty() && this.dispatches.get((int)0).type == Type.ASYNC_PROCESSING) {
            return ((PortletResourceRequestContext)this.reqctx).getAsyncContext();
        }
        return null;
    }

    public DispatcherType getDispatcherType() {
        return super.getDispatcherType();
    }

    public String changeSessionId() {
        return null;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.preq instanceof ClientDataRequest) {
            try {
                return ((ClientDataRequest)this.preq).getPart(name);
            }
            catch (PortletException e) {
                throw new ServletException(e.getCause());
            }
        }
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.preq instanceof ClientDataRequest) {
            try {
                return ((ClientDataRequest)this.preq).getParts();
            }
            catch (PortletException e) {
                throw new ServletException(e.getCause());
            }
        }
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        throw new ServletException("Not Supported");
    }

    private class DispatchElement {
        public Map<String, List<String>> qparms = new HashMap<String, List<String>>();
        public String path;
        public Type type;

        private DispatchElement() {
        }
    }

    private static enum Type {
        INC,
        FWD,
        ASYNC_DISPATCH,
        ASYNC_PROCESSING,
        NAMED;

    }
}

