/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.mvc.Models;
import javax.mvc.binding.ParamError;
import javax.mvc.engine.ViewEngine;
import javax.mvc.engine.ViewEngineContext;
import javax.mvc.engine.ViewEngineException;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.ws.rs.core.Configuration;
import org.apache.pluto.container.bean.mvc.AfterProcessViewEventImpl;
import org.apache.pluto.container.bean.mvc.BeforeProcessViewEventImpl;
import org.apache.pluto.container.bean.mvc.MutableBindingResult;
import org.apache.pluto.container.bean.mvc.ViewEngineContextImpl;
import org.apache.pluto.container.bean.mvc.ViewEngines;
import org.apache.pluto.container.bean.mvc.ViewRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ViewRendererMvcImpl
implements ViewRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(ViewRendererMvcImpl.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private Configuration configuration;
    @Inject
    private Models models;
    @Inject
    private MutableBindingResult mutableBindingResult;
    @Inject
    @ViewEngines
    private List<ViewEngine> viewEngines;

    @Override
    public void render(PortletRequest portletRequest, MimeResponse mimeResponse, PortletConfig portletConfig) throws PortletException {
        Map modelMap = this.models.asMap();
        for (Map.Entry entry : modelMap.entrySet()) {
            portletRequest.setAttribute((String)entry.getKey(), entry.getValue());
        }
        String viewName = (String)portletRequest.getAttribute("viewName");
        if (viewName != null) {
            if (!viewName.contains(".")) {
                String defaultViewExtension = (String)this.configuration.getProperty("org.apache.pluto.defaultViewExtension");
                viewName = viewName.concat(".").concat(defaultViewExtension);
            }
            ViewEngine supportingViewEngine = null;
            for (ViewEngine viewEngine : this.viewEngines) {
                if (!viewEngine.supports(viewName)) continue;
                supportingViewEngine = viewEngine;
                break;
            }
            if (supportingViewEngine == null) {
                throw new PortletException((Throwable)new ViewEngineException("No ViewEngine found that supports " + viewName));
            }
            try {
                this.beanManager.fireEvent((Object)new BeforeProcessViewEventImpl(viewName, supportingViewEngine.getClass()), new Annotation[0]);
                supportingViewEngine.processView((ViewEngineContext)new ViewEngineContextImpl(this.configuration, portletRequest, mimeResponse, this.models, portletRequest.getLocale()));
                this.beanManager.fireEvent((Object)new AfterProcessViewEventImpl(viewName, supportingViewEngine.getClass()), new Annotation[0]);
            }
            catch (ViewEngineException vee) {
                throw new PortletException((Throwable)vee);
            }
        }
        if (this.mutableBindingResult != null && !this.mutableBindingResult.isConsulted()) {
            Set allErrors = this.mutableBindingResult.getAllErrors();
            for (ParamError paramError : allErrors) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("BindingResult error not processed for " + paramError.getParamName() + ": " + paramError.getMessage());
            }
        }
    }
}

