/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.portlet.Portlet;
import javax.portlet.annotations.PortletApplication;
import javax.portlet.annotations.PortletConfiguration;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.annotations.ServeResourceMethod;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.pluto.container.bean.processor.AnnotatedMethod;
import org.apache.pluto.container.bean.processor.AnnotatedMethodStore;
import org.apache.pluto.container.bean.processor.MethodDescription;
import org.apache.pluto.container.bean.processor.MethodIdentifier;
import org.apache.pluto.container.bean.processor.MethodType;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionReferenceImpl;
import org.apache.pluto.container.om.portlet.impl.PortletDefinitionImpl;
import org.apache.pluto.container.om.portlet.impl.SupportsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ConfigurationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationProcessor.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    protected PortletApplicationDefinition pad;

    public ConfigurationProcessor(PortletApplicationDefinition pad) {
        this.pad = pad;
    }

    public PortletApplicationDefinition getPad() {
        return this.pad;
    }

    public abstract void process(JAXBElement<?> var1) throws IllegalArgumentException;

    public abstract void validate() throws IllegalArgumentException;

    protected Locale deriveLocale(String lang) {
        Locale locale = Locale.ENGLISH;
        if (lang != null) {
            String[] parts;
            locale = lang.contains("_") ? ((parts = lang.split("_")).length == 2 ? new Locale(parts[0], parts[1]) : new Locale(parts[0], parts[1], parts[2])) : Locale.forLanguageTag(lang);
        }
        return locale;
    }

    protected boolean isValidIdentifier(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        char[] chars = id.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (char c : Arrays.copyOfRange(chars, 1, chars.length)) {
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    protected void checkValidClass(String clsName, Class<?> assignable, String msg) {
        StringBuilder txt = new StringBuilder(128);
        txt.append(msg).append(", class name: ");
        txt.append(clsName);
        if (!this.isValidIdentifier(clsName)) {
            txt.append(". Invalid java identifier.");
            LOG.warn(txt.toString());
            throw new IllegalArgumentException(txt.toString());
        }
        Class<?> valClass = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            valClass = cl.loadClass(clsName);
            if (assignable != null && !assignable.isAssignableFrom(valClass)) {
                txt.append(". Specified class is not a ");
                txt.append(assignable.getCanonicalName());
                throw new Exception();
            }
        }
        catch (Exception e) {
            txt.append(" Exception: ").append(e.toString());
            if (isDebug) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                txt.append("\n").append(sw.toString());
            }
            LOG.warn(txt.toString());
            throw new IllegalArgumentException(txt.toString(), e);
        }
    }

    protected void checkValidBundle(String bundleName) {
        StringBuilder txt = new StringBuilder(128);
        txt.append("Bad resource bundle: ");
        txt.append(bundleName);
        if (!this.isValidIdentifier(bundleName)) {
            txt.append(". Invalid java identifier.");
            LOG.warn(txt.toString());
            throw new IllegalArgumentException(txt.toString());
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl);
        }
        catch (Exception e) {
            LOG.warn(txt.toString());
            throw new IllegalArgumentException(txt.toString(), e);
        }
    }

    protected String genUniqueName() {
        String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u00fc\u00dc\u00e4\u00c4\u00f6\u00d6\u00df";
        StringBuilder txt = new StringBuilder(128);
        txt.append("Generated:");
        Random rand = new Random();
        for (int ii = 0; ii < 32; ++ii) {
            txt.append("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u00fc\u00dc\u00e4\u00c4\u00f6\u00d6\u00df".charAt(rand.nextInt("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u00fc\u00dc\u00e4\u00c4\u00f6\u00d6\u00df".length())));
        }
        return txt.toString();
    }

    public void processWebDD(InputStream in) throws Exception {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setValidating(false);
        DocumentBuilder builder = fact.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        Document document = builder.parse(in);
        Element root = document.getDocumentElement();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression GET_LIST = xpath.compile("//locale-encoding-mapping-list/locale-encoding-mapping");
        XPathExpression GET_LOC = xpath.compile("locale/text()");
        XPathExpression GET_ENC = xpath.compile("encoding/text()");
        NodeList nodes = (NodeList)GET_LIST.evaluate(root, XPathConstants.NODESET);
        int mappings = 0;
        for (int jj = 0; jj < nodes.getLength(); ++jj) {
            Node node = nodes.item(jj);
            String locstr = (String)GET_LOC.evaluate(node, XPathConstants.STRING);
            String encstr = (String)GET_ENC.evaluate(node, XPathConstants.STRING);
            Locale locale = this.deriveLocale(locstr);
            this.pad.addLocaleEncodingMapping(locale, encstr);
            ++mappings;
        }
        LOG.debug("done parsing web DD, # mappings: " + mappings);
    }

    public void processPortletAppAnnotation(PortletApplication pa) {
    }

    public void processPortletConfigAnnotation(PortletConfiguration pc, Class<?> cls) {
    }

    public void processPortletFilterAnnotation(Class<?> cls) {
    }

    public void processListenerAnnotation(Class<?> cls) {
    }

    public void processValidatorAnnotation(Class<?> cls) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileBeanConfig(AnnotatedMethodStore ams) {
        StringBuilder txt;
        StringBuilder txt2;
        Set<String> portletNames = ams.getPortletNames();
        portletNames.remove("*");
        if (isDebug) {
            StringBuilder txt3 = new StringBuilder();
            txt3.append("Beginning reconciliation. Annotated portlets: ").append(portletNames.toString());
            LOG.debug(txt3.toString());
        }
        ams.setDefaultNamespace(this.pad.getDefaultNamespace());
        for (String pn : portletNames) {
            EventDefinitionReferenceImpl newedr;
            StringBuilder txt4;
            EventDefinition ed;
            PortletDefinition pd = this.pad.getPortlet(pn);
            if (pd == null) {
                pd = new PortletDefinitionImpl(pn, this.pad);
            }
            if (pd.getSupports().isEmpty()) {
                HashMap<String, Supports> mimeSupps = new HashMap<String, Supports>();
                Set<MethodIdentifier> mis = ams.getMethodIDsForPortlet(pn);
                for (MethodIdentifier mi : mis) {
                    String mode;
                    if (mi.getType() != MethodType.RENDER || !(mode = (String)mi.getId()).equalsIgnoreCase("view") && !mode.equalsIgnoreCase("help") && !mode.equalsIgnoreCase("edit")) continue;
                    List<AnnotatedMethod> meths = ams.getMethods(mi);
                    for (AnnotatedMethod meth : meths) {
                        Supports sup;
                        RenderMethod rm = (RenderMethod)meth.getAnnotation();
                        String mimeType = "*/*";
                        if (rm != null) {
                            mimeType = rm.contentType().replaceAll(" ", "").replaceAll("([^;]+).*", "$1").toLowerCase();
                            String string = mimeType = mimeType.equals("*") ? "*/*" : mimeType;
                        }
                        if ((sup = (Supports)mimeSupps.get(mimeType)) == null) {
                            sup = new SupportsImpl(mimeType);
                            mimeSupps.put(mimeType, sup);
                        }
                        if (sup.getPortletModes().contains(mode)) continue;
                        sup.addPortletMode(mode);
                    }
                }
                for (Supports sup : mimeSupps.values()) {
                    pd.addSupports(sup);
                }
                if (isDebug) {
                    txt2 = new StringBuilder();
                    txt2.append("There are ").append(mimeSupps.size()).append(" unique MIME types configured:");
                    for (String mt : mimeSupps.keySet()) {
                        txt2.append("\n   MIME: ").append(mt);
                        txt2.append(",    portlet modes: ");
                        txt2.append(((Supports)mimeSupps.get(mt)).getPortletModes().toString());
                    }
                    LOG.debug(txt2.toString());
                }
            }
            Set<MethodIdentifier> mis = ams.getMethodIDsForPortlet(pn);
            for (MethodIdentifier mi : mis) {
                if (mi.getType() != MethodType.RESOURCE) continue;
                List<AnnotatedMethod> meths = ams.getMethods(mi);
                for (AnnotatedMethod meth : meths) {
                    ServeResourceMethod srm = (ServeResourceMethod)meth.getAnnotation();
                    if (srm == null || !srm.asyncSupported()) continue;
                    pd.setAsyncSupported(true);
                }
            }
            List edrs = pd.getSupportedProcessingEvents();
            for (QName qn : ams.getProcessingEventRefs(pn)) {
                ed = this.pad.getEventDefinition(qn);
                if (ed == null) {
                    txt4 = new StringBuilder(128);
                    txt4.append("No event definition found for annotated processing event reference.");
                    txt4.append(" Portlet name: ").append(pn);
                    txt4.append(", QName: ").append(qn);
                    LOG.warn(txt4.toString());
                    MethodIdentifier mi = new MethodIdentifier(pd.getPortletName(), qn, MethodType.EVENT);
                    ams.removeMethod(mi);
                    continue;
                }
                newedr = new EventDefinitionReferenceImpl(qn);
                if (edrs.contains(newedr)) continue;
                pd.addSupportedProcessingEvent((EventDefinitionReference)newedr);
            }
            edrs = pd.getSupportedPublishingEvents();
            for (QName qn : ams.getPublishingEventRefs(pn)) {
                ed = this.pad.getEventDefinition(qn);
                if (ed == null) {
                    txt4 = new StringBuilder(128);
                    txt4.append("No event definition found for annotated publishing event reference.");
                    txt4.append(" Portlet name: ").append(pn);
                    txt4.append(", QName: ").append(qn);
                    LOG.warn(txt4.toString());
                    continue;
                }
                newedr = new EventDefinitionReferenceImpl(qn);
                if (edrs.contains(newedr)) continue;
                pd.addSupportedPublishingEvent((EventDefinitionReference)newedr);
            }
            this.pad.addPortlet(pd);
        }
        for (PortletDefinition pd : this.pad.getPortlets()) {
            MethodIdentifier mi;
            Class<?> cls = null;
            String clsName = pd.getPortletClass();
            if (this.isValidIdentifier(clsName)) {
                Class<?> valClass = null;
                txt2 = new StringBuilder(128);
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = this.getClass().getClassLoader();
                    }
                    if (Portlet.class.isAssignableFrom(valClass = cl.loadClass(clsName))) {
                        cls = valClass;
                    } else {
                        txt2.append("Specified portlet class does not implement the Portlet interface.");
                    }
                }
                catch (Exception e) {
                    txt2.append("Specified portlet class could not be loaded.");
                }
                finally {
                    if (cls == null) {
                        txt2.append(" Portlet name: ").append(pd.getPortletName());
                        txt2.append(", Portlet class: ").append(clsName);
                        LOG.warn(txt2.toString());
                    }
                }
            }
            if (cls == null) continue;
            AnnotatedMethod am = this.getMethod(cls, "init", MethodDescription.METH_INI);
            if (am != null && ams.getMethods(mi = new MethodIdentifier(pd.getPortletName(), "", MethodType.INIT)).size() == 0) {
                ams.addMethod(mi, am);
            }
            if ((am = this.getMethod(cls, "destroy", MethodDescription.METH_DES)) != null && ams.getMethods(mi = new MethodIdentifier(pd.getPortletName(), "", MethodType.DESTROY)).size() == 0) {
                ams.addMethod(mi, am);
            }
            if ((am = this.getMethod(cls, "processAction", MethodDescription.METH_ACT)) != null && ams.getMethods(mi = new MethodIdentifier(pd.getPortletName(), "", MethodType.ACTION)).size() == 0) {
                ams.addMethod(mi, am);
            }
            if ((am = this.getMethod(cls, "processEvent", MethodDescription.METH_EVT)) != null && ams.getMethods(mi = new MethodIdentifier(pd.getPortletName(), "", MethodType.EVENT)).size() == 0) {
                ams.addMethod(mi, am);
            }
            if ((am = this.getMethod(cls, "render", MethodDescription.METH_REN)) != null && ams.getMethods(mi = new MethodIdentifier(pd.getPortletName(), "", MethodType.RENDER)).size() == 0) {
                ams.addMethod(mi, am);
            }
            if ((am = this.getMethod(cls, "renderHeaders", MethodDescription.METH_HDR)) != null && ams.getMethods(mi = new MethodIdentifier(pd.getPortletName(), "", MethodType.HEADER)).size() == 0) {
                ams.addMethod(mi, am);
            }
            if ((am = this.getMethod(cls, "serveResource", MethodDescription.METH_RES)) == null || ams.getMethods(mi = new MethodIdentifier(pd.getPortletName(), "", MethodType.RESOURCE)).size() != 0) continue;
            ams.addMethod(mi, am);
        }
        Set<MethodIdentifier> mis = ams.getMethodIDsForPortlet("*");
        if (isDebug) {
            StringBuilder txt5 = new StringBuilder();
            txt5.append("Wild card portlets: ");
            String sep = "";
            for (MethodIdentifier mi : mis) {
                txt5.append(sep).append(mi.toString());
                sep = ";";
            }
            LOG.debug(txt5.toString());
        }
        for (MethodIdentifier mi : mis) {
            List<AnnotatedMethod> meths = ams.getMethods(mi);
            for (PortletDefinition pd : this.pad.getPortlets()) {
                MethodIdentifier newMi = new MethodIdentifier(pd.getPortletName(), mi.getId(), mi.getType());
                for (AnnotatedMethod meth : meths) {
                    ams.addMethod(newMi, meth);
                }
            }
        }
        ArrayList<PortletDefinition> badPortlets = new ArrayList<PortletDefinition>();
        for (PortletDefinition pd : this.pad.getPortlets()) {
            boolean methodsOK = false;
            for (MethodIdentifier mi : ams.getMethodIDsForPortlet(pd.getPortletName())) {
                if (mi.getType() != MethodType.RENDER && mi.getType() != MethodType.RESOURCE && mi.getType() != MethodType.HEADER) continue;
                methodsOK = true;
                break;
            }
            if (methodsOK) continue;
            ams.removeMethodsForPortlet(pd.getPortletName());
            badPortlets.add(pd);
            txt2 = new StringBuilder();
            txt2.append("Portlet does not have a render, resource, or header method, so cannot be taken into service. ");
            txt2.append("Portlet name: ").append(pd.getPortletName());
            LOG.warn(txt2.toString());
        }
        for (PortletDefinition pd : badPortlets) {
            this.pad.removePortlet(pd);
        }
        if (isDebug) {
            txt = new StringBuilder();
            txt.append("Finished reconciling bean config. ");
            Set<String> finalNames = ams.getPortletNames();
            finalNames.remove("*");
            txt.append("Resulting portlet list: ").append(finalNames.toString());
            LOG.debug(txt.toString());
        }
        if (isTrace) {
            txt = new StringBuilder();
            txt.append(ams.getMethodsAsString());
            LOG.trace(txt.toString());
        }
    }

    public void instantiatePortlets(AnnotatedMethodStore ams, BeanManager bm) {
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("Instantiating the portlets.");
            txt.append(" beanMgr: ").append(bm == null ? "null" : "not null");
            txt.append(", portlet names: ").append(Arrays.toString(ams.getPortletNames().toArray()));
            LOG.debug(txt.toString());
        }
        ams.activateMethods(bm);
        for (PortletDefinition pd : this.pad.getPortlets()) {
            HashSet processedClasses = new HashSet();
            String clsName = pd.getPortletClass();
            Object instance = null;
            if (clsName != null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                try {
                    Class<?> cls = cl.loadClass(clsName);
                    processedClasses.add(cls);
                    StringBuilder txt = new StringBuilder(128);
                    if (bm == null) {
                        txt.append("Could not get portlet bean. Bean manager is null.");
                    } else {
                        Set beans = bm.getBeans(cls, new Annotation[0]);
                        if (beans == null || beans.size() == 0) {
                            txt.append("Could not get portlet bean. No beans found.");
                        } else {
                            Bean bean = bm.resolve(beans);
                            if (bean == null) {
                                txt.append("Could not get portlet bean. Could not resolve bean.");
                            } else {
                                instance = bm.getReference(bean, (Type)bean.getBeanClass(), bm.createCreationalContext((Contextual)bean));
                                if (instance == null) {
                                    txt.append("Could not get portlet bean. Could not get bean instance.");
                                }
                            }
                        }
                    }
                    if (instance == null) {
                        LOG.debug("Could not create bean (possibly not in a valid bean archive). Now directly instantiating class: " + cls.getCanonicalName());
                        try {
                            instance = cls.newInstance();
                        }
                        catch (Exception e) {
                            txt.append(" Exception creating instance of class: ").append(e.toString());
                        }
                    }
                    if (instance != null) {
                        ams.setPortletClassInstance(pd.getPortletName(), cls, instance);
                        if (isTrace) {
                            StringBuilder str = new StringBuilder();
                            str.append("Updating class instances.");
                            str.append(" portlet name: ").append(pd.getPortletName());
                            str.append(", class: ").append(cls.getCanonicalName());
                            str.append(", instance: ").append(instance == null ? "null" : "not null");
                            LOG.debug(str.toString());
                        }
                    }
                    if (instance == null) {
                        txt.append(" Portlet name: ").append(pd.getPortletName());
                        txt.append(", portlet class: ").append(cls);
                        LOG.warn(txt.toString());
                    }
                }
                catch (ClassNotFoundException e) {
                    LOG.debug("Could not instantiate portlet class: " + clsName);
                }
            }
            if (bm != null) continue;
            for (MethodIdentifier mi : ams.getMethodIDsForPortlet(pd.getPortletName())) {
                for (AnnotatedMethod am : ams.getMethods(mi)) {
                    Class<?> cls = am.getBeanClass();
                    if (processedClasses.contains(cls)) continue;
                    processedClasses.add(cls);
                    try {
                        instance = cls.newInstance();
                        ams.setPortletClassInstance(pd.getPortletName(), cls, instance);
                    }
                    catch (Exception e) {
                        StringBuilder txt = new StringBuilder(128);
                        txt.append("Exception creating instance of class: ").append(e.toString());
                        txt.append(" Portlet name: ").append(pd.getPortletName());
                        txt.append(", portlet class: ").append(cls);
                        LOG.warn(txt.toString());
                    }
                }
            }
        }
    }

    private AnnotatedMethod getMethod(Class<?> cls, String name, MethodDescription md) {
        AnnotatedMethod am;
        block2: {
            am = null;
            try {
                Method meth = cls.getMethod(name, md.getArgTypes());
                am = new AnnotatedMethod(cls, null, meth, md);
            }
            catch (Exception e) {
                if (!isDebug) break block2;
                StringBuilder txt = new StringBuilder();
                txt.append("Could not retrieve method from portlet class.");
                txt.append(" Method name: ").append(name);
                txt.append(", Class: ").append(cls.getCanonicalName());
                txt.append(", Argument types: ").append(md.getArgTypes());
                LOG.debug(txt.toString());
            }
        }
        return am;
    }
}

