/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.xml.namespace.QName;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletStateAwareResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.PortletResponseImpl;
import org.apache.pluto.container.util.ArgumentUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateAwareResponseImpl
extends PortletResponseImpl
implements StateAwareResponse {
    private PortletStateAwareResponseContext responseContext;

    public StateAwareResponseImpl(PortletStateAwareResponseContext responseContext) {
        super((PortletResponseContext)responseContext);
        this.responseContext = responseContext;
    }

    private boolean isPublicRenderParameter(String name) {
        List publicRenderParameterNames = this.responseContext.getPortletWindow().getPortletDefinition().getSupportedPublicRenderParameters();
        return publicRenderParameterNames.isEmpty() ? false : publicRenderParameterNames.contains(name);
    }

    private static String[] cloneParameterValues(String[] values) {
        int count = 0;
        for (String s : values) {
            if (s == null) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (count < values.length) {
            String[] copy = new String[count];
            count = 0;
            for (String s : values) {
                if (s == null) continue;
                copy[count++] = s;
            }
            return copy;
        }
        return (String[])values.clone();
    }

    protected abstract void checkSetStateChanged();

    protected boolean isWindowStateAllowed(WindowState state) {
        Enumeration supportedStates = this.getPortalContext().getSupportedWindowStates();
        while (supportedStates.hasMoreElements()) {
            if (!((WindowState)supportedStates.nextElement()).equals((Object)state)) continue;
            return true;
        }
        return false;
    }

    public PortletMode getPortletMode() {
        return this.responseContext.getPortletMode();
    }

    public Map<String, String[]> getRenderParameterMap() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>(this.responseContext.getRenderParameters());
        for (Map.Entry entry : parameters.entrySet()) {
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return parameters;
    }

    public WindowState getWindowState() {
        return this.responseContext.getWindowState();
    }

    public void removePublicRenderParameter(String name) {
        ArgumentUtility.validateNotEmpty("name", name);
        this.checkSetStateChanged();
        if (this.isPublicRenderParameter(name)) {
            this.responseContext.getPublicRenderParameters().put(name, null);
            this.responseContext.getRenderParameters().remove(name);
        }
    }

    public void setEvent(QName qname, Serializable value) {
        ArgumentUtility.validateNotNull("qname", qname);
        Event event = this.responseContext.getEventProvider().createEvent(qname, value);
        if (event != null) {
            this.responseContext.getEvents().add(event);
        }
    }

    public void setEvent(String name, Serializable value) {
        PortletWindow window = this.getPortletWindow();
        String defaultNamespace = window.getPortletDefinition().getApplication().getDefaultNamespace();
        QName qname = new QName(defaultNamespace, name);
        this.setEvent(qname, value);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        ArgumentUtility.validateNotNull("portletMode", portletMode);
        if (!this.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        this.checkSetStateChanged();
        this.responseContext.setPortletMode(portletMode);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        ArgumentUtility.validateNotNull("windowState", windowState);
        if (!this.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        this.checkSetStateChanged();
        this.responseContext.setWindowState(windowState);
    }

    public void setRenderParameters(Map<String, String[]> parameters) {
        ArgumentUtility.validateNotNull("parameters", parameters);
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("parameters map contains a null key or value entry");
            }
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("parameters map contains a key which is not of type String");
            }
            if (!(entry.getValue() instanceof String[])) {
                throw new IllegalArgumentException("parameters map contains a value which is not of type String[]");
            }
            boolean emptyValuesArray = true;
            for (String s : entry.getValue()) {
                if (s == null) continue;
                emptyValuesArray = false;
                break;
            }
            if (!emptyValuesArray) continue;
            throw new IllegalStateException("parameters map contains a values array which is empty or contains only null values");
        }
        this.checkSetStateChanged();
        this.responseContext.getRenderParameters().clear();
        Iterator iter = this.responseContext.getPublicRenderParameters().entrySet().iterator();
        while (iter.hasNext()) {
            if (iter.next().getValue() == null) continue;
            iter.remove();
        }
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String[] values = StateAwareResponseImpl.cloneParameterValues(entry.getValue());
            this.responseContext.getRenderParameters().put(entry.getKey(), values);
            if (!this.isPublicRenderParameter(entry.getKey())) continue;
            this.responseContext.getPublicRenderParameters().put(entry.getKey(), values);
        }
    }

    public void setRenderParameter(String key, String value) {
        ArgumentUtility.validateNotEmpty("key", key);
        ArgumentUtility.validateNotNull("value", value);
        this.checkSetStateChanged();
        String[] values = new String[]{value};
        this.responseContext.getRenderParameters().put(key, values);
        if (this.isPublicRenderParameter(key)) {
            this.responseContext.getPublicRenderParameters().put(key, values);
        }
    }

    public void setRenderParameter(String key, String[] values) {
        ArgumentUtility.validateNotEmpty("key", key);
        ArgumentUtility.validateNotNull("values", values);
        values = StateAwareResponseImpl.cloneParameterValues(values);
        if (values == null) {
            throw new IllegalStateException("Illegal Argument: values array is empty or contains only null values");
        }
        this.checkSetStateChanged();
        this.responseContext.getRenderParameters().put(key, values);
        if (this.isPublicRenderParameter(key)) {
            this.responseContext.getPublicRenderParameters().put(key, values);
        }
    }
}

