/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.Enumeration;
import java.util.Map;
import javax.portlet.CacheControl;
import javax.portlet.ResourceRequest;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResourceRequestContext;
import org.apache.pluto.container.PortletResourceResponseContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.impl.ClientDataRequestImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRequestImpl
extends ClientDataRequestImpl
implements ResourceRequest {
    private PortletResourceRequestContext requestContext;
    private CacheControl cacheControl;

    public ResourceRequestImpl(PortletResourceRequestContext requestContext, PortletResourceResponseContext responseContext) {
        super((PortletRequestContext)requestContext, (PortletResponseContext)responseContext, "RESOURCE_PHASE");
        this.requestContext = requestContext;
        this.cacheControl = responseContext.getCacheControl();
    }

    @Override
    public String getProperty(String name) {
        String result = this.getMimeRequestProperty(name, this.cacheControl);
        return result != null ? result : super.getProperty(name);
    }

    public String getCacheability() {
        return this.requestContext.getCacheability();
    }

    public String getETag() {
        return this.cacheControl.getETag();
    }

    public Map<String, String[]> getPrivateRenderParameterMap() {
        return ResourceRequestImpl.cloneParameterMap(this.requestContext.getPrivateRenderParameterMap());
    }

    public String getResourceID() {
        return this.requestContext.getResourceID();
    }

    @Override
    public String getResponseContentType() {
        return this.getServletRequest().getHeader("accept");
    }

    @Override
    public Enumeration<String> getResponseContentTypes() {
        return this.getServletRequest().getHeaders("accept");
    }
}

