/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.container.util.DummyPrintWriter;
import org.apache.pluto.container.util.DummyServletOutputStream;

public class HttpServletPortletResponseWrapper
extends HttpServletResponseWrapper {
    private final boolean forwarded;
    private final PortletResponse portletResponse;
    private final MimeResponse mimeResponse;
    private final String lifecyclePhase;
    private boolean included;
    private OutputStream outputStream;
    private ServletOutputStream servletOutputStream;

    public HttpServletPortletResponseWrapper(HttpServletResponse response, PortletRequest portletRequest, PortletResponse portletResponse, boolean included) {
        super(response);
        this.portletResponse = portletResponse;
        this.lifecyclePhase = (String)portletRequest.getAttribute("javax.portlet.lifecycle_phase");
        this.mimeResponse = "RENDER_PHASE".equals(this.lifecyclePhase) || "RESOURCE_PHASE".equals(this.lifecyclePhase) ? (MimeResponse)portletResponse : null;
        this.forwarded = !included;
        this.included = included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public void addCookie(Cookie cookie) {
        if (this.forwarded && !this.included) {
            this.portletResponse.addProperty(cookie);
        }
    }

    public void addDateHeader(String name, long date) {
        if (this.forwarded && !this.included && this.mimeResponse != null) {
            this.mimeResponse.addProperty(name, Long.toString(date));
        }
    }

    public void addHeader(String name, String value) {
        if (this.forwarded && !this.included && this.mimeResponse != null) {
            this.mimeResponse.addProperty(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (this.forwarded && !this.included && this.mimeResponse != null) {
            this.mimeResponse.addProperty(name, Integer.toString(value));
        }
    }

    public boolean containsHeader(String name) {
        return false;
    }

    public String encodeRedirectUrl(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        if (url != null && url.indexOf("://") == -1 && !url.startsWith("/")) {
            return url;
        }
        return this.portletResponse.encodeURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
    }

    public void sendError(int sc) throws IOException {
    }

    public void sendRedirect(String location) throws IOException {
        if (this.forwarded && !this.included && "ACTION_PHASE".equals(this.lifecyclePhase)) {
            ((ActionResponse)this.portletResponse).sendRedirect(location);
        }
    }

    public void setDateHeader(String name, long date) {
        if (this.forwarded && !this.included && this.mimeResponse != null) {
            this.mimeResponse.setProperty(name, Long.toString(date));
        }
    }

    public void setHeader(String name, String value) {
        if (this.forwarded && !this.included && this.mimeResponse != null) {
            this.mimeResponse.setProperty(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.forwarded && !this.included && this.mimeResponse != null) {
            this.mimeResponse.setProperty(name, Integer.toString(value));
        }
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
    }

    public void setStatus(int sc) {
        if (this.forwarded && !this.included && "RESOURCE_PHASE".equals(this.lifecyclePhase)) {
            this.mimeResponse.setProperty("portlet.http-status-code", Integer.toString(sc));
        }
    }

    public void flushBuffer() throws IOException {
        if (this.mimeResponse != null) {
            this.mimeResponse.flushBuffer();
        }
    }

    public int getBufferSize() {
        return this.mimeResponse != null ? this.mimeResponse.getBufferSize() : 0;
    }

    public String getCharacterEncoding() {
        return this.mimeResponse != null ? this.mimeResponse.getCharacterEncoding() : null;
    }

    public String getContentType() {
        return this.mimeResponse != null ? this.mimeResponse.getContentType() : null;
    }

    public Locale getLocale() {
        return this.mimeResponse != null ? this.mimeResponse.getLocale() : null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.servletOutputStream == null) {
            this.outputStream = this.mimeResponse != null ? this.mimeResponse.getPortletOutputStream() : DummyServletOutputStream.getInstance();
            this.servletOutputStream = this.outputStream instanceof ServletOutputStream ? (ServletOutputStream)this.outputStream : new ServletOutputStream(){

                public void write(int b) throws IOException {
                    HttpServletPortletResponseWrapper.this.outputStream.write(b);
                }
            };
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.mimeResponse != null ? this.mimeResponse.getWriter() : DummyPrintWriter.getInstance();
    }

    public boolean isCommitted() {
        return this.mimeResponse != null ? this.mimeResponse.isCommitted() : !this.forwarded;
    }

    public void reset() {
        if (this.mimeResponse != null) {
            this.mimeResponse.reset();
        }
    }

    public void resetBuffer() {
        if (this.mimeResponse != null) {
            this.mimeResponse.resetBuffer();
        }
    }

    public void setBufferSize(int size) {
        if (this.mimeResponse != null) {
            this.mimeResponse.setBufferSize(size);
        }
    }

    public void setCharacterEncoding(String charset) {
        if (this.forwarded && !this.included && "RESOURCE_PHASE".equals(this.lifecyclePhase)) {
            ((ResourceResponse)this.portletResponse).setCharacterEncoding(charset);
        }
    }

    public void setContentLength(int len) {
        if (this.forwarded && !this.included && "RESOURCE_PHASE".equals(this.lifecyclePhase)) {
            ((ResourceResponse)this.portletResponse).setContentLength(len);
        }
    }

    public void setContentType(String type) {
        if (this.forwarded && !this.included && this.mimeResponse != null) {
            this.mimeResponse.setContentType(type);
        }
    }

    public void setLocale(Locale loc) {
        if (this.forwarded && !this.included && "RESOURCE_PHASE".equals(this.lifecyclePhase)) {
            ((ResourceResponse)this.portletResponse).setLocale(loc);
        }
    }
}

