/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.pluto.container.PortletMimeResponseContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletURLListenerService;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.util.ArgumentUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLImpl
implements PortletURL,
ResourceURL {
    private PortletResponseContext responseContext;
    private PortalContext portalContext;
    private PortletURLProvider urlProvider;
    private String cacheLevel = "cacheLevelPage";
    private boolean filtering;
    private boolean renderURL;

    public PortletURLImpl(PortletResponseContext responseContext, PortletURLProvider urlProvider) {
        this.responseContext = responseContext;
        this.portalContext = responseContext.getContainer().getContainerServices().getPortalContext();
        this.urlProvider = urlProvider;
        this.renderURL = PortletURLProvider.TYPE.RENDER == urlProvider.getType();
    }

    public PortletURLImpl(PortletMimeResponseContext responseContext, PortletURLProvider.TYPE type) {
        this((PortletResponseContext)responseContext, responseContext.getPortletURLProvider(type));
    }

    public PortletURLImpl(PortletMimeResponseContext responseContext, String cacheLevel) {
        this(responseContext, PortletURLProvider.TYPE.RESOURCE);
        if (cacheLevel != null) {
            this.cacheLevel = cacheLevel;
        }
        this.urlProvider.setCacheability(this.cacheLevel);
    }

    private boolean isPortletModeAllowed(PortletMode mode) {
        if (PortletMode.VIEW.equals((Object)mode)) {
            return true;
        }
        String modeName = mode.toString();
        PortletDefinition dd = this.responseContext.getPortletWindow().getPortletDefinition();
        for (Supports sup : dd.getSupports()) {
            for (String m : sup.getPortletModes()) {
                if (!m.equalsIgnoreCase(modeName)) continue;
                CustomPortletMode cpm = dd.getApplication().getCustomPortletMode(modeName);
                if (cpm != null && !cpm.isPortalManaged()) {
                    return true;
                }
                Enumeration supportedModes = this.portalContext.getSupportedPortletModes();
                while (supportedModes.hasMoreElements()) {
                    if (!((PortletMode)supportedModes.nextElement()).equals((Object)mode)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isWindowStateAllowed(WindowState state) {
        Enumeration supportedStates = this.portalContext.getSupportedWindowStates();
        while (supportedStates.hasMoreElements()) {
            if (!((WindowState)supportedStates.nextElement()).equals((Object)state)) continue;
            return true;
        }
        return false;
    }

    private boolean isPublicRenderParameter(String name) {
        List publicRenderParameterNames = this.responseContext.getPortletWindow().getPortletDefinition().getSupportedPublicRenderParameters();
        return publicRenderParameterNames.isEmpty() ? false : publicRenderParameterNames.contains(name);
    }

    private static String[] cloneParameterValues(String[] values) {
        int count = 0;
        for (String s : values) {
            if (s == null) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (count < values.length) {
            String[] copy = new String[count];
            count = 0;
            for (String s : values) {
                if (s == null) continue;
                copy[count++] = s;
            }
            return copy;
        }
        return (String[])values.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterURL() {
        if (this.filtering) {
            throw new IllegalStateException("Calling PortletURL toString or write methods from a PortletURLGenerationListener not allowed");
        }
        this.filtering = true;
        try {
            PortletURLListenerService service = this.responseContext.getContainer().getContainerServices().getPortletURLListenerService();
            PortletApplicationDefinition portletApp = this.responseContext.getPortletWindow().getPortletDefinition().getApplication();
            for (PortletURLGenerationListener listener : service.getPortletURLGenerationListeners(portletApp)) {
                if (PortletURLProvider.TYPE.ACTION == this.urlProvider.getType()) {
                    listener.filterActionURL((PortletURL)this);
                    continue;
                }
                if (PortletURLProvider.TYPE.RESOURCE == this.urlProvider.getType()) {
                    listener.filterResourceURL((ResourceURL)this);
                    continue;
                }
                listener.filterRenderURL((PortletURL)this);
            }
        }
        finally {
            this.filtering = false;
        }
    }

    public void addProperty(String key, String value) {
        ArgumentUtility.validateNotEmpty("key", key);
        if (value != null) {
            Map properties = this.urlProvider.getProperties();
            ArrayList<String> values = (ArrayList<String>)properties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.urlProvider.getProperties().put(key, values);
            }
            values.add(value);
        }
    }

    public Map<String, String[]> getParameterMap() {
        Map<String, String[]> parameters = this.urlProvider.getRenderParameters();
        if (parameters.isEmpty()) {
            parameters = Collections.emptyMap();
        } else {
            parameters = new HashMap<String, String[]>(parameters);
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                entry.setValue((String[])entry.getValue().clone());
            }
        }
        return parameters;
    }

    public void setParameter(String name, String value) {
        ArgumentUtility.validateNotEmpty("name", name);
        ArgumentUtility.validateNotNull("value", value);
        String[] values = new String[]{value};
        this.urlProvider.getRenderParameters().put(name, values);
        if (this.renderURL && this.isPublicRenderParameter(name)) {
            this.urlProvider.getPublicRenderParameters().put(name, values);
        }
    }

    public void setParameter(String name, String[] values) {
        ArgumentUtility.validateNotEmpty("name", name);
        ArgumentUtility.validateNotNull("values", values);
        values = PortletURLImpl.cloneParameterValues(values);
        if (values == null) {
            throw new IllegalStateException("Illegal Argument: values array is empty or contains only null values");
        }
        this.urlProvider.getRenderParameters().put(name, values);
        if (this.renderURL && this.isPublicRenderParameter(name)) {
            this.urlProvider.getPublicRenderParameters().put(name, values);
        }
    }

    public void setParameters(Map<String, String[]> parameters) {
        ArgumentUtility.validateNotNull("parameters", parameters);
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("parameters map contains a null key or value entry");
            }
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("parameters map contains a key which is not of type String");
            }
            if (!(entry.getValue() instanceof String[])) {
                throw new IllegalArgumentException("parameters map contains a value which is not of type String[]");
            }
            boolean emptyValuesArray = true;
            for (String s : entry.getValue()) {
                if (s == null) continue;
                emptyValuesArray = false;
                break;
            }
            if (!emptyValuesArray) continue;
            throw new IllegalStateException("parameters map contains a values array which is empty or contains only null values");
        }
        this.urlProvider.getRenderParameters().clear();
        if (this.renderURL) {
            Iterator iter = this.urlProvider.getPublicRenderParameters().entrySet().iterator();
            while (iter.hasNext()) {
                if (iter.next().getValue() == null) continue;
                iter.remove();
            }
        }
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String[] values = PortletURLImpl.cloneParameterValues(entry.getValue());
            this.urlProvider.getRenderParameters().put(entry.getKey(), values);
            if (!this.renderURL || !this.isPublicRenderParameter(entry.getKey())) continue;
            this.urlProvider.getPublicRenderParameters().put(entry.getKey(), values);
        }
    }

    public void setProperty(String key, String value) {
        ArgumentUtility.validateNotEmpty("key", key);
        Map properties = this.urlProvider.getProperties();
        if (value == null) {
            properties.remove(key);
        } else {
            ArrayList<String> values = (ArrayList<String>)properties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                properties.put(key, values);
            } else {
                values.clear();
            }
            values.add(value);
        }
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this.urlProvider.setSecure(secure);
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        this.filterURL();
        this.urlProvider.write(out, escapeXML);
    }

    public void write(Writer out) throws IOException {
        this.write(out, true);
    }

    public String toString() {
        this.filterURL();
        return this.urlProvider.toURL();
    }

    public PortletMode getPortletMode() {
        return this.urlProvider.getPortletMode();
    }

    public WindowState getWindowState() {
        return this.urlProvider.getWindowState();
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        ArgumentUtility.validateNotNull("portletMode", portletMode);
        if (!this.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        this.urlProvider.setPortletMode(portletMode);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        ArgumentUtility.validateNotNull("windowState", windowState);
        if (!this.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        this.urlProvider.setWindowState(windowState);
    }

    public void removePublicRenderParameter(String name) {
        ArgumentUtility.validateNotEmpty("name", name);
        if (this.isPublicRenderParameter(name)) {
            this.urlProvider.getPublicRenderParameters().put(name, null);
            this.urlProvider.getRenderParameters().remove(name);
        }
    }

    public String getCacheability() {
        return this.urlProvider.getCacheability();
    }

    public void setCacheability(String cacheLevel) {
        ArgumentUtility.validateNotEmpty("cachelevel", cacheLevel);
        if (!"cacheLevelFull".equals(cacheLevel)) {
            if ("cacheLevelPortlet".equals(cacheLevel)) {
                if ("cacheLevelFull".equals(this.cacheLevel)) {
                    throw new IllegalStateException("Current request cacheablility is FULL: URLs with cacheability PORTLET not allowed");
                }
            } else if ("cacheLevelPage".equals(cacheLevel)) {
                if ("cacheLevelFull".equals(this.cacheLevel)) {
                    throw new IllegalStateException("Current request cacheablility is FULL: URLs with cacheability PORTLET not allowed");
                }
                if ("cacheLevelPortlet".equals(this.cacheLevel)) {
                    throw new IllegalStateException("Current request cacheablility is PORTLET: URLs with cacheability PAGE not allowed");
                }
            } else {
                throw new IllegalArgumentException("Unknown cacheLevel: " + cacheLevel);
            }
        }
        this.urlProvider.setCacheability(cacheLevel);
    }

    public void setResourceID(String resourceID) {
        this.urlProvider.setResourceID(resourceID);
    }
}

