/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.BaseURL;
import javax.portlet.PortletConfig;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.servlet.jsp.JspException;
import org.apache.pluto.tags.BaseURLTag;

public class ResourceURLTag286
extends BaseURLTag {
    private static final long serialVersionUID = 286L;
    private String id = null;
    private String cacheability = null;
    private static final Map<String, String> cacheabilityMap = new HashMap<String, String>();
    private ResourceURL resourceURL = null;

    public ResourceURLTag286() {
        this.setEscapeXml(Boolean.TRUE.toString());
    }

    @Override
    public int doStartTag() throws JspException {
        PortletResponse portletResponse;
        String[] result;
        PortletConfig portletConfig = (PortletConfig)this.pageContext.getRequest().getAttribute("javax.portlet.config");
        Map containerRuntimeOptions = portletConfig.getContainerRuntimeOptions();
        if (containerRuntimeOptions != null && (result = (String[])containerRuntimeOptions.get("javax.portlet.escapeXml")) != null && result.length > 0) {
            this.setEscapeXml(result[0]);
        }
        if ((portletResponse = (PortletResponse)this.pageContext.getRequest().getAttribute("javax.portlet.response")) != null) {
            ResourceURL resourceURL = this.createResourceURL(portletResponse);
            if (this.id != null) {
                resourceURL.setResourceID(this.id);
            }
            if (this.cacheability != null) {
                ArrayList<String> caAttribs = new ArrayList<String>(cacheabilityMap.keySet());
                if (!caAttribs.contains(this.cacheability.toUpperCase())) {
                    StringBuilder txt = new StringBuilder(128);
                    txt.append("Invalid cacheability option: ").append(this.cacheability);
                    txt.append(", valid options: ").append(((Object)caAttribs).toString());
                    throw new JspException(txt.toString());
                }
                try {
                    resourceURL.setCacheability(cacheabilityMap.get(this.cacheability));
                }
                catch (IllegalArgumentException e) {
                    throw new JspException((Throwable)e);
                }
                catch (IllegalStateException e) {
                    throw new JspException((Throwable)e);
                }
            }
            this.setUrl((BaseURL)resourceURL);
        }
        return super.doStartTag();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCacheability() {
        return this.cacheability;
    }

    public void setCacheability(String cacheability) throws JspException {
        this.cacheability = cacheability;
    }

    protected ResourceURL getUrl() {
        return this.resourceURL;
    }

    @Override
    protected void setUrl(BaseURL url) {
        this.resourceURL = (ResourceURL)url;
    }

    protected ResourceURL createResourceURL(PortletResponse portletResponse) throws JspException {
        ResourceURL result = null;
        if (portletResponse instanceof RenderResponse) {
            result = ((RenderResponse)portletResponse).createResourceURL();
        } else if (portletResponse instanceof ResourceResponse) {
            result = ((ResourceResponse)portletResponse).createResourceURL();
        } else {
            throw new JspException();
        }
        return result;
    }

    static {
        cacheabilityMap.put("FULL", "cacheLevelFull");
        cacheabilityMap.put("PORTLET", "cacheLevelPortlet");
        cacheabilityMap.put("PAGE", "cacheLevelPage");
    }
}

