/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;

public class SecurityRoleRefImpl
implements SecurityRoleRef {
    private String roleLink;
    private String roleName;
    private final List<Description> descs = new ArrayList<Description>();

    public SecurityRoleRefImpl(SecurityRoleRef srr) {
        this.roleName = srr.getRoleName();
        this.roleLink = srr.getRoleLink();
        for (Description desc : srr.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
    }

    public SecurityRoleRefImpl(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public String getRoleLink() {
        return this.roleLink;
    }

    @Override
    public void setRoleLink(String roleLink) {
        this.roleLink = roleLink;
    }

    @Override
    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    @Override
    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    @Override
    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.roleName == null ? 0 : this.roleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityRoleRefImpl other = (SecurityRoleRefImpl)obj;
        return !(this.roleName == null ? other.roleName != null : !this.roleName.equals(other.roleName));
    }
}

