/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pluto.container.om.portlet.LocaleText;
import org.apache.pluto.container.om.portlet.PortletInfo;
import org.apache.pluto.container.om.portlet.impl.LocaleTextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletInfoImpl
implements PortletInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PortletInfoImpl.class);
    private final List<LocaleText> titles = new ArrayList<LocaleText>();
    private final List<LocaleText> keywords = new ArrayList<LocaleText>();
    private final List<LocaleText> sTitles = new ArrayList<LocaleText>();

    public PortletInfoImpl() {
    }

    public PortletInfoImpl(PortletInfo pi) {
        for (LocaleText lt : pi.getTitles()) {
            this.titles.add(new LocaleTextImpl(lt));
        }
        for (LocaleText lt : pi.getShortTitles()) {
            this.sTitles.add(new LocaleTextImpl(lt));
        }
        for (LocaleText lt : pi.getKeywordsList()) {
            this.keywords.add(new LocaleTextImpl(lt));
        }
    }

    public PortletInfoImpl(String ti, String kw, String sti) {
        LocaleTextImpl lt = new LocaleTextImpl(Locale.ENGLISH, ti);
        this.titles.add(lt);
        lt = new LocaleTextImpl(Locale.ENGLISH, sti);
        this.sTitles.add(lt);
        lt = new LocaleTextImpl(Locale.ENGLISH, kw);
        this.keywords.add(lt);
    }

    @Override
    public String getTitle() {
        LocaleText lt = null;
        for (LocaleText title : this.titles) {
            if (!title.getLocale().equals(Locale.ENGLISH)) continue;
            lt = title;
            break;
        }
        return lt == null ? null : lt.getText();
    }

    @Override
    public void setTitle(String title) {
        LocaleTextImpl lt = new LocaleTextImpl(Locale.ENGLISH, title);
        this.titles.add(lt);
    }

    @Override
    public LocaleText getTitle(Locale locale) {
        LocaleTextImpl ret = null;
        for (LocaleText item : this.titles) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new LocaleTextImpl(item);
        }
        return ret;
    }

    @Override
    public List<LocaleText> getTitles() {
        return new ArrayList<LocaleText>(this.titles);
    }

    @Override
    public void addTitle(LocaleText title) {
        if (this.titles.remove(title)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Removed duplicate description for locale: ").append(title.getLocale().toString());
            txt.append(", description: ").append(title.getText());
            LOG.debug(txt.toString());
        }
        this.titles.add(title);
    }

    @Override
    public String getKeywords() {
        LocaleText lt = null;
        for (LocaleText kw : this.keywords) {
            if (!kw.getLocale().equals(Locale.ENGLISH)) continue;
            lt = kw;
            break;
        }
        return lt == null ? null : lt.getText();
    }

    @Override
    public void setKeywords(String keywords) {
        LocaleTextImpl lt = new LocaleTextImpl(Locale.ENGLISH, keywords);
        this.keywords.add(lt);
    }

    @Override
    public LocaleText getKeywords(Locale locale) {
        LocaleTextImpl ret = null;
        for (LocaleText item : this.keywords) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new LocaleTextImpl(item);
        }
        return ret;
    }

    @Override
    public List<LocaleText> getKeywordsList() {
        return new ArrayList<LocaleText>(this.keywords);
    }

    @Override
    public void addKeywords(LocaleText kw) {
        if (this.keywords.remove(kw)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Removed duplicate description for locale: ").append(kw.getLocale().toString());
            txt.append(", description: ").append(kw.getText());
            LOG.debug(txt.toString());
        }
        this.keywords.add(kw);
    }

    @Override
    public String getShortTitle() {
        LocaleText lt = null;
        for (LocaleText title : this.sTitles) {
            if (!title.getLocale().equals(Locale.ENGLISH)) continue;
            lt = title;
            break;
        }
        return lt == null ? null : lt.getText();
    }

    @Override
    public void setShortTitle(String shortTitle) {
        LocaleTextImpl lt = new LocaleTextImpl(Locale.ENGLISH, shortTitle);
        this.sTitles.add(lt);
    }

    @Override
    public LocaleText getShortTitle(Locale locale) {
        LocaleTextImpl ret = null;
        for (LocaleText item : this.sTitles) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new LocaleTextImpl(item);
        }
        return ret;
    }

    @Override
    public List<LocaleText> getShortTitles() {
        return new ArrayList<LocaleText>(this.sTitles);
    }

    @Override
    public void addShortTitle(LocaleText st) {
        if (this.sTitles.remove(st)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Removed duplicate description for locale: ").append(st.getLocale().toString());
            txt.append(", description: ").append(st.getText());
            LOG.debug(txt.toString());
        }
        this.sTitles.add(st);
    }
}

