/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.pluto.container.bean.mvc.BeanValidationMessageInterpolator;
import org.apache.pluto.container.bean.mvc.BeanValidationValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BeanValidationProducer {
    private static final Logger LOG = LoggerFactory.getLogger(BeanValidationProducer.class);
    private MessageInterpolator messageInterpolator;
    private Validator validator;
    @Inject
    private Instance<ValidatorFactory> validatorFactoryInstance;

    @BeanValidationMessageInterpolator
    @Dependent
    @Produces
    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    @BeanValidationValidator
    @Dependent
    @Produces
    public Validator getValidator() {
        return this.validator;
    }

    @PostConstruct
    public void postConstruct() {
        ValidatorFactory validatorFactory = null;
        Iterator iterator = this.validatorFactoryInstance.iterator();
        if (iterator.hasNext()) {
            validatorFactory = (ValidatorFactory)iterator.next();
        }
        if (validatorFactory == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("ValidatorFactory was not injected -- if using Hibernate Validator, please include the hibernate-validator-cdi dependency.");
            }
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (validatorFactory != null) {
            this.messageInterpolator = validatorFactory.getMessageInterpolator();
            if (this.messageInterpolator == null && LOG.isWarnEnabled()) {
                LOG.warn("Bean validation MessageInterpolator not available");
            }
            this.validator = validatorFactory.getValidator();
            if (this.validator == null && LOG.isWarnEnabled()) {
                LOG.warn("Bean validation validator not available");
            }
        }
    }
}

