/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.Portlet;
import javax.portlet.PreferencesValidator;
import javax.xml.bind.JAXBElement;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet.impl.ConfigurationProcessor;
import org.apache.pluto.container.om.portlet.impl.CustomPortletModeImpl;
import org.apache.pluto.container.om.portlet.impl.CustomWindowStateImpl;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;
import org.apache.pluto.container.om.portlet.impl.InitParamImpl;
import org.apache.pluto.container.om.portlet.impl.PortletDefinitionImpl;
import org.apache.pluto.container.om.portlet.impl.PortletInfoImpl;
import org.apache.pluto.container.om.portlet.impl.PreferenceImpl;
import org.apache.pluto.container.om.portlet.impl.PreferencesImpl;
import org.apache.pluto.container.om.portlet.impl.SecurityConstraintImpl;
import org.apache.pluto.container.om.portlet.impl.SecurityRoleRefImpl;
import org.apache.pluto.container.om.portlet.impl.SupportsImpl;
import org.apache.pluto.container.om.portlet.impl.UserAttributeImpl;
import org.apache.pluto.container.om.portlet.impl.UserDataConstraintImpl;
import org.apache.pluto.container.om.portlet10.impl.CustomPortletModeType;
import org.apache.pluto.container.om.portlet10.impl.CustomWindowStateType;
import org.apache.pluto.container.om.portlet10.impl.DescriptionType;
import org.apache.pluto.container.om.portlet10.impl.DisplayNameType;
import org.apache.pluto.container.om.portlet10.impl.InitParamType;
import org.apache.pluto.container.om.portlet10.impl.MimeTypeType;
import org.apache.pluto.container.om.portlet10.impl.PortletAppType;
import org.apache.pluto.container.om.portlet10.impl.PortletCollectionType;
import org.apache.pluto.container.om.portlet10.impl.PortletInfoType;
import org.apache.pluto.container.om.portlet10.impl.PortletModeType;
import org.apache.pluto.container.om.portlet10.impl.PortletNameType;
import org.apache.pluto.container.om.portlet10.impl.PortletPreferencesType;
import org.apache.pluto.container.om.portlet10.impl.PortletType;
import org.apache.pluto.container.om.portlet10.impl.PreferenceType;
import org.apache.pluto.container.om.portlet10.impl.RoleLinkType;
import org.apache.pluto.container.om.portlet10.impl.SecurityConstraintType;
import org.apache.pluto.container.om.portlet10.impl.SecurityRoleRefType;
import org.apache.pluto.container.om.portlet10.impl.SupportedLocaleType;
import org.apache.pluto.container.om.portlet10.impl.SupportsType;
import org.apache.pluto.container.om.portlet10.impl.UserAttributeType;
import org.apache.pluto.container.om.portlet10.impl.UserDataConstraintType;
import org.apache.pluto.container.om.portlet10.impl.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR168ConfigurationProcessor
extends ConfigurationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JSR168ConfigurationProcessor.class);
    private static final boolean isTrace = LOG.isTraceEnabled();

    public JSR168ConfigurationProcessor(PortletApplicationDefinition pad) {
        super(pad);
    }

    @Override
    public void process(JAXBElement<?> rootElement) throws IllegalArgumentException {
        assert (rootElement != null);
        assert (rootElement.getValue() instanceof PortletAppType);
        PortletAppType app = (PortletAppType)rootElement.getValue();
        this.pad.setId(app.getId());
        if (app.getVersion() == null || !app.getVersion().equals("1.0")) {
            String warning = "Bad version. Expected 1.0, was: " + app.getVersion();
            LOG.warn(warning);
            throw new IllegalArgumentException(warning);
        }
        this.pad.setVersion(app.getVersion());
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Reading portlet DD. ");
            txt.append("Version: ");
            txt.append(app.getVersion());
            txt.append(", ID: ");
            txt.append(app.getId());
            LOG.trace(txt.toString());
        }
        this.handleCPM(app.getCustomPortletMode());
        this.handleCWS(app.getCustomWindowState());
        this.handleSC(app.getSecurityConstraint());
        this.handleUA(app.getUserAttribute());
        this.handlePortlets(app.getPortlet());
    }

    private List<DisplayName> handleDisplayNames(List<DisplayNameType> dispNames) {
        ArrayList<DisplayName> list = new ArrayList<DisplayName>();
        for (DisplayNameType dispName : dispNames) {
            if (dispName.getValue() == null) {
                String warning = "Bad display name - no display name value; will be ignored. continuing ...";
                LOG.warn(warning);
                continue;
            }
            Locale loc = this.deriveLocale(dispName.getLang());
            DisplayNameImpl d = new DisplayNameImpl(loc, dispName.getValue());
            list.add(d);
        }
        return list;
    }

    private List<Description> handleDescriptions(List<DescriptionType> descs) {
        ArrayList<Description> list = new ArrayList<Description>();
        for (DescriptionType desc : descs) {
            if (desc.getValue() == null) {
                String warning = "Bad description - no description value; will be ignored. continuing ...";
                LOG.warn(warning);
                continue;
            }
            Locale loc = this.deriveLocale(desc.getLang());
            DescriptionImpl d = new DescriptionImpl(loc, desc.getValue());
            list.add(d);
        }
        return list;
    }

    private void handleUA(List<UserAttributeType> uats) {
        for (UserAttributeType uat : uats) {
            if (uat.getName() == null || uat.getName().getValue() == null) {
                String warning = "Bad user attribute will be ignored. Name was null. Continuing ...";
                LOG.warn(warning);
                continue;
            }
            UserAttributeImpl attr = new UserAttributeImpl(uat.getName().getValue());
            for (Description desc : this.handleDescriptions(uat.getDescription())) {
                attr.addDescription(desc);
            }
            this.pad.addUserAttribute(attr);
        }
    }

    private void handleCPM(List<CustomPortletModeType> cpms) {
        for (CustomPortletModeType cpm : cpms) {
            if (cpm.getPortletMode() == null || cpm.getPortletMode().getValue() == null) {
                String warning = "Bad custom portlet mode. Mode was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String val = cpm.getPortletMode().getValue();
            if (val.equalsIgnoreCase("view") || val.equalsIgnoreCase("edit") || val.equalsIgnoreCase("help")) {
                String warning = "Bad custom portlet mode. Mode was: " + val;
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            CustomPortletModeImpl pm = new CustomPortletModeImpl(cpm.getPortletMode().getValue());
            for (Description desc : this.handleDescriptions(cpm.getDescription())) {
                pm.addDescription(desc);
            }
            this.pad.addCustomPortletMode(pm);
        }
    }

    private void handleCWS(List<CustomWindowStateType> cwss) {
        for (CustomWindowStateType cws : cwss) {
            if (cws.getWindowState() == null || cws.getWindowState().getValue() == null) {
                String warning = "Bad custom portlet mode. Mode was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String val = cws.getWindowState().getValue();
            if (val.equalsIgnoreCase("view") || val.equalsIgnoreCase("edit") || val.equalsIgnoreCase("help")) {
                String warning = "Bad custom portlet mode. Mode was: " + val;
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            CustomWindowStateImpl ws = new CustomWindowStateImpl(cws.getWindowState().getValue());
            for (Description desc : this.handleDescriptions(cws.getDescription())) {
                ws.addDescription(desc);
            }
            this.pad.addCustomWindowState(ws);
        }
    }

    private void handleSC(List<SecurityConstraintType> scs) {
        for (SecurityConstraintType sc : scs) {
            PortletCollectionType pct = sc.getPortletCollection();
            if (pct == null || pct.getPortletName() == null || pct.getPortletName().size() == 0) {
                String warning = "Portlet collection is empty.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            for (PortletNameType pnt : pct.getPortletName()) {
                if (this.isValidIdentifier(pnt.getValue())) continue;
                String warning = "Bad portlet name: " + pnt.getValue();
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            UserDataConstraintType udc = sc.getUserDataConstraint();
            if (udc == null || udc.getTransportGuarantee() == null || udc.getTransportGuarantee().value() == null) {
                String warning = "User data constraint contains null value.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            UserDataConstraintImpl newudc = new UserDataConstraintImpl(udc.getTransportGuarantee().value());
            for (Description desc : this.handleDescriptions(udc.getDescription())) {
                newudc.addDescription(desc);
            }
            SecurityConstraintImpl newsc = new SecurityConstraintImpl(newudc);
            for (DisplayName dispName : this.handleDisplayNames(sc.getDisplayName())) {
                newsc.addDisplayName(dispName);
            }
            for (PortletNameType portletName : pct.getPortletName()) {
                newsc.addPortletName(portletName.getValue());
            }
            this.pad.addSecurityConstraint(newsc);
        }
    }

    private List<Supports> handleSupports(List<SupportsType> sts) {
        ArrayList<Supports> newSupps = new ArrayList<Supports>();
        for (SupportsType st : sts) {
            MimeTypeType mtt = st.getMimeType();
            if (mtt == null || mtt.getValue() == null) {
                String warning = "Null Mime type, ignoring Supports block.";
                LOG.warn(warning);
                continue;
            }
            List<PortletModeType> list = st.getPortletMode();
            if (list.size() == 0) {
                String warning = "No portlet modes found, ignoring Supports block.";
                LOG.warn(warning);
                continue;
            }
            String mimetype = mtt.getValue().replaceAll("([^;]*).*", "$1").replaceAll(" ", "");
            SupportsImpl sup = new SupportsImpl(mimetype);
            for (PortletModeType item : list) {
                sup.addPortletMode(item.getValue());
            }
            newSupps.add(sup);
        }
        return newSupps;
    }

    private List<InitParam> handleInitParam(List<InitParamType> parms) {
        ArrayList<InitParam> newParms = new ArrayList<InitParam>();
        for (InitParamType parm : parms) {
            if (parm.getName() == null || parm.getName().getValue() == null) {
                String warning = "Bad init parameter. Parameter name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = parm.getName().getValue();
            String value = parm.getValue().getValue();
            InitParamImpl newp = new InitParamImpl(name, value);
            for (Description desc : this.handleDescriptions(parm.getDescription())) {
                newp.addDescription(desc);
            }
            newParms.add(newp);
        }
        return newParms;
    }

    private List<Preference> handlePreferences(List<PreferenceType> args) {
        ArrayList<Preference> list = new ArrayList<Preference>();
        for (PreferenceType item : args) {
            if (item.getName() == null || item.getName().getValue() == null) {
                String warning = "Bad portlet preference. Ppreference name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName().getValue();
            List<ValueType> vals = item.getValue();
            ArrayList<String> lines = new ArrayList<String>(16);
            for (ValueType vt : vals) {
                lines.add(vt.getValue());
            }
            boolean isRO = item.getReadOnly().value().equalsIgnoreCase("true");
            PreferenceImpl pref = new PreferenceImpl(name, isRO, lines);
            list.add(pref);
        }
        return list;
    }

    private List<SecurityRoleRef> handleSecRoleRef(List<SecurityRoleRefType> args) {
        ArrayList<SecurityRoleRef> list = new ArrayList<SecurityRoleRef>();
        for (SecurityRoleRefType item : args) {
            String roleLinkValue;
            if (item.getRoleName() == null || item.getRoleName().length() == 0) {
                String warning = "Bad security role reference. Name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getRoleName();
            SecurityRoleRefImpl srr = new SecurityRoleRefImpl(name);
            RoleLinkType roleLink = item.getRoleLink();
            if (roleLink != null && (roleLinkValue = roleLink.getValue()) != null && roleLinkValue.length() > 0) {
                srr.setRoleLink(roleLinkValue);
            }
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                srr.addDescription(desc);
            }
            list.add(srr);
        }
        return list;
    }

    private void handlePortlets(List<PortletType> portlets) {
        for (PortletType portlet : portlets) {
            String warning;
            String pn = portlet.getPortletName().getValue();
            if (!this.isValidIdentifier(pn)) {
                warning = "Portlet name not valid Java identifier: " + pn;
                LOG.warn(warning);
            }
            String clsName = portlet.getPortletClass();
            warning = "Bad portlet class: " + clsName;
            if (!this.isValidIdentifier(clsName)) {
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            Class<?> valClass = null;
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                valClass = cl.loadClass(clsName);
                if (!Portlet.class.isAssignableFrom(valClass)) {
                    throw new Exception("specified class is not a Portlet.");
                }
            }
            catch (Exception e) {
                LOG.warn(warning);
                throw new IllegalArgumentException(warning, e);
            }
            PortletDefinitionImpl pd = new PortletDefinitionImpl(pn, this.pad);
            pd.setPortletClass(portlet.getPortletClass());
            if (portlet.getResourceBundle() != null) {
                pd.setResourceBundle(portlet.getResourceBundle().getValue());
            }
            if (portlet.getExpirationCache() != null) {
                pd.setExpirationCache(portlet.getExpirationCache().getValue());
            }
            for (DisplayName dispName : this.handleDisplayNames(portlet.getDisplayName())) {
                pd.addDisplayName(dispName);
            }
            for (Description desc : this.handleDescriptions(portlet.getDescription())) {
                pd.addDescription(desc);
            }
            for (Supports s : this.handleSupports(portlet.getSupports())) {
                pd.addSupports(s);
            }
            PortletInfoType pit = portlet.getPortletInfo();
            if (pit != null) {
                if (pit.getTitle().getValue() == null) {
                    warning = "Portlet info section does not contain title. Ingoring ...";
                    LOG.warn(warning);
                } else {
                    String st = null;
                    String kw = null;
                    String title = pit.getTitle().getValue();
                    if (pit.getShortTitle() != null) {
                        st = pit.getShortTitle().getValue();
                    }
                    if (pit.getKeywords() != null) {
                        kw = pit.getKeywords().getValue();
                    }
                    PortletInfoImpl info = new PortletInfoImpl(title, kw, st);
                    pd.setPortletInfo(info);
                }
            }
            for (SupportedLocaleType slt : portlet.getSupportedLocale()) {
                pd.addSupportedLocale(slt.getValue());
            }
            for (InitParam ip : this.handleInitParam(portlet.getInitParam())) {
                pd.addInitParam(ip);
            }
            PortletPreferencesType prefs = portlet.getPortletPreferences();
            if (prefs != null) {
                PreferencesImpl newprefs = new PreferencesImpl();
                clsName = prefs.getPreferencesValidator();
                warning = "Bad portlet preferences validator class: " + clsName;
                if (!this.isValidIdentifier(clsName)) {
                    LOG.warn(warning);
                    throw new IllegalArgumentException(warning);
                }
                valClass = null;
                try {
                    ClassLoader cl = this.getClass().getClassLoader();
                    valClass = cl.loadClass(clsName);
                    if (!PreferencesValidator.class.isAssignableFrom(valClass)) {
                        throw new Exception("specified class is not a PreferencesValidator.");
                    }
                }
                catch (Exception e) {
                    LOG.warn(warning);
                    throw new IllegalArgumentException(warning, e);
                }
                newprefs.setPreferencesValidator(clsName);
                for (Preference p : this.handlePreferences(prefs.getPreference())) {
                    newprefs.addPreference(p);
                }
                pd.setPortletPreferences(newprefs);
            }
            for (SecurityRoleRef srr : this.handleSecRoleRef(portlet.getSecurityRoleRef())) {
                pd.addSecurityRoleRef(srr);
            }
            this.pad.addPortlet(pd);
        }
    }

    @Override
    public void validate() throws IllegalArgumentException {
    }
}

