/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;

public class InitParamImpl
implements InitParam {
    private String name;
    private String value;
    private final List<Description> descs = new ArrayList<Description>();

    public InitParamImpl(InitParam ipi) {
        this.name = ipi.getParamName();
        this.value = ipi.getParamValue();
        for (Description desc : ipi.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
    }

    public InitParamImpl(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getParamName() {
        return this.name;
    }

    @Override
    public String getParamValue() {
        return this.value;
    }

    @Override
    public void setParamValue(String paramValue) {
        this.value = paramValue;
    }

    @Override
    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    @Override
    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    @Override
    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitParamImpl other = (InitParamImpl)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

