/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pluto.container.om.portlet.CustomWindowState;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;

public class CustomWindowStateImpl
implements CustomWindowState {
    private String ws;
    private final List<Description> descs = new ArrayList<Description>();

    public CustomWindowStateImpl(String cws) {
        this.ws = cws;
    }

    public CustomWindowStateImpl(CustomWindowState cws) {
        this.ws = cws.getWindowState();
        for (Description desc : cws.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
    }

    public CustomWindowStateImpl(String ws, List<Description> descs) {
        this.ws = ws;
        this.descs.addAll(descs);
    }

    @Override
    public String getWindowState() {
        return this.ws;
    }

    @Override
    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    @Override
    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    @Override
    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ws == null ? 0 : this.ws.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomWindowStateImpl other = (CustomWindowStateImpl)obj;
        return !(this.ws == null ? other.ws != null : !this.ws.equals(other.ws));
    }
}

