/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet.webcontent;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class WebContentHistoryPage
implements Serializable {
    private String url;
    private Map params;
    private boolean is_post;

    public WebContentHistoryPage(String url) {
        this(url, null, null);
    }

    public WebContentHistoryPage(String url, Map params, String method) {
        if (url == null) {
            throw new IllegalArgumentException("WebContentHistoryPage() - url required");
        }
        this.url = url;
        this.params = params != null ? params : new HashMap();
        this.is_post = method != null && method.equalsIgnoreCase("post");
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebContentHistoryPage)) {
            return false;
        }
        WebContentHistoryPage page = (WebContentHistoryPage)o;
        return page.url.equals(this.url) && ((Object)page.params).equals(this.params) && page.isPost() == this.isPost();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[").append(this.isPost() ? "POST: " : "GET: ").append(this.getUrl()).append(", ").append(this.getParams().size()).append(" params: {");
        Iterator iter = this.getParams().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            buff.append("(").append(entry.getKey()).append(" . ").append(ArrayUtils.toString(entry.getKey())).append(")");
        }
        buff.append("}]");
        return buff.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public Map getParams() {
        return this.params;
    }

    public boolean isPost() {
        return this.is_post;
    }
}

