/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet.webcontent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.portlet.webcontent.WebContentHistoryPage;

public class WebContentHistoryList
implements Serializable {
    int maxLength;
    List history;
    int currentIndex;

    public WebContentHistoryList() {
        this(-1);
    }

    public WebContentHistoryList(int maxLength) {
        this.maxLength = maxLength;
        this.history = new ArrayList();
        this.currentIndex = -1;
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public boolean hasCurrentPage() {
        return this.currentIndex >= 0;
    }

    public boolean hasPreviousPage() {
        return !this.isEmpty() && this.currentIndex - 1 >= 0;
    }

    public boolean hasNextPage() {
        return !this.isEmpty() && this.currentIndex + 1 < this.history.size();
    }

    public WebContentHistoryPage getCurrentPage() {
        if (!this.hasCurrentPage()) {
            return null;
        }
        return (WebContentHistoryPage)this.history.get(this.currentIndex);
    }

    public WebContentHistoryPage getPreviousPage() {
        if (!this.hasPreviousPage()) {
            return null;
        }
        --this.currentIndex;
        return this.getCurrentPage();
    }

    public WebContentHistoryPage getNextPage() {
        if (!this.hasNextPage()) {
            return null;
        }
        ++this.currentIndex;
        return this.getCurrentPage();
    }

    public void visitPage(WebContentHistoryPage page) {
        if (page == null) {
            throw new IllegalArgumentException("WebContentHistoryList.addPage() - non-null page required.");
        }
        int i = this.history.indexOf(page);
        if (i >= 0 && i == this.currentIndex) {
            return;
        }
        while (this.hasNextPage()) {
            this.history.remove(this.currentIndex + 1);
        }
        if (i >= 0 && i < this.history.size()) {
            this.history.remove(i);
        }
        this.history.add(page);
        this.currentIndex = this.history.size() - 1;
    }
}

