/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.portlet.webcontent.WebContentHistoryList;
import org.apache.jetspeed.portlet.webcontent.WebContentHistoryPage;
import org.apache.jetspeed.rewriter.JetspeedRewriterController;
import org.apache.jetspeed.rewriter.RewriterController;
import org.apache.jetspeed.rewriter.RewriterException;
import org.apache.jetspeed.rewriter.RulesetRewriter;
import org.apache.jetspeed.rewriter.WebContentRewriter;
import org.apache.jetspeed.rewriter.html.neko.NekoParserAdaptor;
import org.apache.jetspeed.rewriter.rules.Ruleset;
import org.apache.jetspeed.rewriter.xml.SaxParserAdaptor;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.portals.messaging.PortletMessaging;

public class WebContentPortlet
extends GenericVelocityPortlet {
    public static final String VIEW_SOURCE_PARAM = "viewSource";
    public static final String EDIT_SOURCE_PARAM = "editSource";
    public static final String BROWSER_ACTION_PARAM = "wcBrowserAction";
    public static final String BROWSER_ACTION_PREVIOUS_PAGE = "previousPage";
    public static final String BROWSER_ACTION_REFRESH_PAGE = "refreshPage";
    public static final String BROWSER_ACTION_NEXT_PAGE = "nextPage";
    public static final String HISTORY = "webcontent.history";
    public static final String HTTP_STATE = "webcontent.http.state";
    protected static final Log log = LogFactory.getLog((Class)WebContentPortlet.class);
    public static final String defaultEncoding = "UTF-8";
    private RulesetRewriter rewriter = null;
    private RewriterController rewriteController = null;
    public static final String FORM_POST_METHOD = "post";
    public static final String FORM_GET_METHOD = "get";
    public static final String FORM_MULTIPART_METHOD = "multipart";
    static final int BLOCK_SIZE = 4096;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String browserAction = actionRequest.getParameter(BROWSER_ACTION_PARAM);
        if (browserAction != null) {
            if (!browserAction.equalsIgnoreCase(BROWSER_ACTION_REFRESH_PAGE)) {
                WebContentHistoryList history = (WebContentHistoryList)PortletMessaging.receive((PortletRequest)actionRequest, (String)HISTORY);
                if (browserAction.equalsIgnoreCase(BROWSER_ACTION_PREVIOUS_PAGE)) {
                    if (history.hasPreviousPage()) {
                        history.getPreviousPage();
                    }
                } else if (browserAction.equalsIgnoreCase(BROWSER_ACTION_NEXT_PAGE) && history.hasNextPage()) {
                    history.getNextPage();
                }
            }
            return;
        }
        String webContentURL = actionRequest.getParameter("_AP_URL");
        String webContentMethod = actionRequest.getParameter("_AP_METHOD");
        HashMap webContentParams = new HashMap(actionRequest.getParameterMap());
        if (webContentMethod == null) {
            webContentMethod = "";
        }
        webContentParams.remove("_AP_URL");
        webContentParams.remove("_AP_METHOD");
        if (webContentURL == null || actionRequest.getPortletMode() == PortletMode.EDIT) {
            this.processPreferencesAction(actionRequest, actionResponse);
            webContentURL = actionRequest.getPreferences().getValue("SRC", "http://portals.apache.org");
            webContentParams.clear();
        }
        if (webContentURL != null && webContentURL.length() > 0) {
            WebContentHistoryList history = (WebContentHistoryList)PortletMessaging.receive((PortletRequest)actionRequest, (String)HISTORY);
            if (history == null) {
                history = new WebContentHistoryList();
            }
            history.visitPage(new WebContentHistoryPage(webContentURL, webContentParams, webContentMethod));
            PortletMessaging.publish((PortletRequest)actionRequest, (String)HISTORY, (Object)history);
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WebContentHistoryPage currentPage;
        String viewPage = (String)request.getAttribute("ViewPage");
        if (viewPage != null) {
            super.doView(request, response);
            return;
        }
        WebContentHistoryList history = (WebContentHistoryList)PortletMessaging.receive((PortletRequest)request, (String)HISTORY);
        if (history == null) {
            history = new WebContentHistoryList();
        }
        if ((currentPage = history.getCurrentPage()) == null) {
            String sourceURL = request.getPreferences().getValue("SRC", "");
            if (sourceURL == null) {
                throw new PortletException("WebContent source not specified. Go to edit mode and specify an URL.");
            }
            currentPage = new WebContentHistoryPage(sourceURL);
        }
        if (this.rewriteController == null) {
            PortletContext portletApplication = this.getPortletContext();
            String path = portletApplication.getRealPath("/WEB-INF");
            String contextPath = path + "/";
            try {
                this.rewriteController = this.getController(contextPath);
            }
            catch (Exception e) {
                String msg = "WebContentPortlet failed to create rewriter controller.";
                log.error((Object)msg, (Throwable)e);
                throw new PortletException(e.getMessage());
            }
        }
        response.setContentType("text/html");
        byte[] content = this.doWebContent(currentPage.getUrl(), currentPage.getParams(), currentPage.isPost(), request, response);
        PrintWriter writer = response.getWriter();
        writer.print("<block>");
        if (history.hasPreviousPage()) {
            PortletURL prevAction = response.createActionURL();
            prevAction.setParameter(BROWSER_ACTION_PARAM, BROWSER_ACTION_PREVIOUS_PAGE);
            writer.print(" [<a href=\"" + prevAction.toString() + "\">Previous Page</a>] ");
        }
        PortletURL refreshAction = response.createActionURL();
        refreshAction.setParameter(BROWSER_ACTION_PARAM, BROWSER_ACTION_REFRESH_PAGE);
        writer.print(" [<a href=\"" + refreshAction.toString() + "\">Refresh Page</a>] ");
        if (history.hasNextPage()) {
            PortletURL nextAction = response.createActionURL();
            nextAction.setParameter(BROWSER_ACTION_PARAM, BROWSER_ACTION_NEXT_PAGE);
            writer.print(" [<a href=\"" + nextAction.toString() + "\">Next Page</a>] ");
        }
        writer.print("</block><hr/>");
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        this.drain(new InputStreamReader((InputStream)bais, defaultEncoding), writer);
        bais.close();
        history.visitPage(currentPage);
        PortletMessaging.publish((PortletRequest)request, (String)HISTORY, (Object)history);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    protected byte[] doWebContent(String sourceAttr, Map sourceParams, boolean isPost, RenderRequest request, RenderResponse response) throws PortletException {
        HttpMethodBase httpMethod = null;
        try {
            PortletURL action = response.createActionURL();
            ((WebContentRewriter)this.rewriter).setActionURL(action);
            URL baseURL = new URL(sourceAttr);
            this.rewriter.setBaseUrl(baseURL.toString());
            if (baseURL.getProtocol().equals("file")) {
                InputStreamReader reader = new InputStreamReader((InputStream)baseURL.getContent());
                StringWriter writer = new StringWriter();
                this.rewriter.rewrite(this.rewriteController.createParserAdaptor("text/html"), (Reader)reader, (Writer)writer);
                writer.flush();
                byte[] byArray = writer.toString().getBytes();
                return byArray;
            }
            HttpClient httpClient = this.getHttpClient(request);
            String method = isPost ? FORM_POST_METHOD : FORM_GET_METHOD;
            httpMethod = this.getHttpMethod(httpClient, this.getURLSource(sourceAttr, sourceParams, request, response), sourceParams, method, request);
            byte[] result = this.doPreemptiveAuthentication(httpClient, (HttpMethod)httpMethod, request, response);
            if (result == null) {
                byte[] byArray = this.doHttpWebContent(httpClient, (HttpMethod)httpMethod, 0, request, response);
                return byArray;
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (PortletException pex) {
            throw pex;
        }
        catch (Exception ex) {
            String msg = "Exception while rewritting HTML content";
            log.error((Object)msg, (Throwable)ex);
            throw new PortletException(msg + ", Error: " + ex.getMessage());
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected byte[] doHttpWebContent(HttpClient httpClient, HttpMethod httpMethod, int retryCount, RenderRequest request, RenderResponse response) throws PortletException {
        try {
            httpClient.executeMethod(httpMethod);
            this.rewriter.setBaseUrl(this.rewriter.getBaseRelativeUrl(httpMethod.getPath()));
            Cookie[] cookies = httpClient.getState().getCookies();
            PortletMessaging.publish((PortletRequest)request, (String)HTTP_STATE, (Object)cookies);
            int responseCode = httpMethod.getStatusCode();
            if (responseCode >= 300 && responseCode <= 399) {
                String redirectLocation;
                Header locationHeader = httpMethod.getResponseHeader("location");
                String string = redirectLocation = locationHeader != null ? locationHeader.getValue() : null;
                if (redirectLocation != null) {
                    return this.doWebContent(redirectLocation, new HashMap(), false, request, response);
                }
                throw new PortletException("Redirection code: " + responseCode + ", but with no redirectionLocation set.");
            }
            if (responseCode >= 400) {
                if (responseCode == 401) {
                    if (httpMethod.getHostAuthState().isAuthRequested() && retryCount++ < 1 && this.doRequestedAuthentication(httpClient, httpMethod, request, response)) {
                        return this.doHttpWebContent(httpClient, httpMethod, retryCount, request, response);
                    }
                    throw new PortletException("Site requested authorization, but we are unable to provide credentials");
                }
                if (retryCount++ < 3) {
                    log.info((Object)("WebContentPortlet.doHttpWebContent() - retrying: " + httpMethod.getPath() + ", response code: " + responseCode));
                    return this.doHttpWebContent(httpClient, httpMethod, retryCount, request, response);
                }
                throw new PortletException("Failure reading: " + httpMethod.getPath() + ", response code: " + responseCode);
            }
            BufferedInputStream bis = new BufferedInputStream(httpMethod.getResponseBodyAsStream());
            String encoding = ((HttpMethodBase)httpMethod).getResponseCharSet();
            if (encoding == null) {
                encoding = this.getContentCharSet(bis);
            }
            InputStreamReader htmlReader = new InputStreamReader((InputStream)bis, encoding);
            if (encoding == null) {
                encoding = defaultEncoding;
            }
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)byteOutputStream, encoding);
            this.rewriter.rewrite(this.rewriteController.createParserAdaptor("text/html"), (Reader)htmlReader, (Writer)htmlWriter);
            ((Writer)htmlWriter).flush();
            return byteOutputStream.toByteArray();
        }
        catch (UnsupportedEncodingException ueex) {
            throw new PortletException("Encoding UTF-8 not supported. Error: " + ueex.getMessage());
        }
        catch (RewriterException rwe) {
            throw new PortletException("Failed to rewrite HTML page. Error: " + rwe.getMessage());
        }
        catch (Exception e) {
            throw new PortletException("Exception while rewritting HTML page. Error: " + e.getMessage());
        }
    }

    protected String getURLSource(String source, Map params, RenderRequest request, RenderResponse response) {
        return source;
    }

    protected byte[] doPreemptiveAuthentication(HttpClient clent, HttpMethod method, RenderRequest request, RenderResponse response) {
        return null;
    }

    protected boolean doRequestedAuthentication(HttpClient clent, HttpMethod method, RenderRequest request, RenderResponse response) {
        return false;
    }

    private RewriterController getController(String contextPath) throws Exception {
        Class[] rewriterClasses = new Class[]{WebContentRewriter.class, WebContentRewriter.class};
        Class[] adaptorClasses = new Class[]{NekoParserAdaptor.class, SaxParserAdaptor.class};
        JetspeedRewriterController rwc = new JetspeedRewriterController(contextPath + "conf/rewriter-rules-mapping.xml", Arrays.asList(rewriterClasses), Arrays.asList(adaptorClasses));
        FileReader reader = new FileReader(contextPath + "conf/default-rewriter-rules.xml");
        Ruleset ruleset = rwc.loadRuleset((Reader)reader);
        reader.close();
        this.rewriter = rwc.createRewriter(ruleset);
        return rwc;
    }

    protected HttpClient getHttpClient(RenderRequest request) throws IOException {
        HttpClient client = new HttpClient();
        Cookie[] cookies = (Cookie[])PortletMessaging.receive((PortletRequest)request, (String)HTTP_STATE);
        if (cookies != null) {
            client.getState().addCookies(cookies);
        }
        return client;
    }

    protected HttpMethodBase getHttpMethod(HttpClient client, String uri, Map params, String formMethod, RenderRequest request) throws IOException {
        formMethod = FORM_MULTIPART_METHOD;
        MultipartPostMethod httpMethod = null;
        String useragentProperty = request.getProperty("User-Agent");
        if (formMethod.equalsIgnoreCase(FORM_MULTIPART_METHOD)) {
            MultipartPostMethod mutlitPart = httpMethod = new MultipartPostMethod(uri);
            if (params != null && !params.isEmpty()) {
                Iterator iter = params.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String name = (String)entry.getKey();
                    String[] values = (String[])entry.getValue();
                    if (values == null) continue;
                    int limit = values.length;
                    for (int i = 0; i < limit; ++i) {
                        mutlitPart.addParameter(name, values[i]);
                    }
                }
            }
        } else if (formMethod.equalsIgnoreCase(FORM_GET_METHOD)) {
            httpMethod = new GetMethod(uri);
            if (params != null && !params.isEmpty()) {
                ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
                Iterator iter = params.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String name = (String)entry.getKey();
                    String[] values = (String[])entry.getValue();
                    if (values == null) continue;
                    int limit = values.length;
                    for (int i = 0; i < limit; ++i) {
                        pairs.add(new NameValuePair(name, values[i]));
                    }
                }
                httpMethod.setQueryString(pairs.toArray(new NameValuePair[pairs.size()]));
            }
            httpMethod.setFollowRedirects(true);
        } else if (formMethod.equalsIgnoreCase(FORM_POST_METHOD)) {
            httpMethod = new PostMethod(uri);
            PostMethod postMethod = httpMethod;
            if (params != null && !params.isEmpty()) {
                Iterator iter = params.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String name = (String)entry.getKey();
                    String[] values = (String[])entry.getValue();
                    if (values == null) continue;
                    int limit = values.length;
                    for (int i = 0; i < limit; ++i) {
                        postMethod.addParameter(name, values[i]);
                    }
                }
            }
        }
        httpMethod.addRequestHeader("User-Agent", useragentProperty);
        return httpMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain(Reader r, Writer w) throws IOException {
        char[] bytes = new char[4096];
        try {
            int length = r.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally {
            bytes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentCharSet(InputStream is) throws IOException {
        if (!is.markSupported()) {
            return null;
        }
        byte[] buf = new byte[4096];
        try {
            int endIndex;
            is.mark(4096);
            is.read(buf, 0, 4096);
            String content = new String(buf, "ISO-8859-1");
            String lowerCaseContent = content.toLowerCase();
            int startIndex = lowerCaseContent.indexOf("<head");
            if (startIndex == -1) {
                startIndex = 0;
            }
            if ((endIndex = lowerCaseContent.indexOf("</head")) == -1) {
                endIndex = content.length();
            }
            content = content.substring(startIndex, endIndex);
            StringTokenizer st = new StringTokenizer(content, "<>");
            while (st.hasMoreTokens()) {
                String element = st.nextToken();
                String lowerCaseElement = element.toLowerCase();
                if (!lowerCaseElement.startsWith("meta") || lowerCaseElement.indexOf("content-type") <= 0) continue;
                StringTokenizer est = new StringTokenizer(element, " =\"';");
                while (est.hasMoreTokens()) {
                    if (!est.nextToken().equalsIgnoreCase("charset") || !est.hasMoreTokens()) continue;
                    String string = est.nextToken();
                    return string;
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            is.reset();
        }
        return null;
    }
}

