/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.portlet.WebContentPortlet;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.sso.SSOContext;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOProvider;
import org.apache.portals.messaging.PortletMessaging;

public class SSOWebContentPortlet
extends WebContentPortlet {
    public static final String SSO_TYPE = "sso.type";
    public static final String SSO_TYPE_HTTP = "http";
    public static final String SSO_TYPE_BASIC = "basic";
    public static final String SSO_TYPE_BASIC_PREEMPTIVE = "basic.preemptive";
    public static final String SSO_TYPE_FORM = "form";
    public static final String SSO_TYPE_FORM_GET = "form.get";
    public static final String SSO_TYPE_FORM_POST = "form.post";
    public static final String SSO_TYPE_URL = "url";
    public static final String SSO_TYPE_URL_BASE64 = "url.base64";
    public static final String SSO_TYPE_CERTIFICATE = "certificate";
    public static final String SSO_TYPE_DEFAULT = "basic";
    public static final String BASIC_AUTH_SCHEME_NAME = new BasicScheme().getSchemeName();
    public static final String SSO_TYPE_URL_USERNAME_PARAM = "sso.url.Principal";
    public static final String SSO_TYPE_URL_PASSWORD_PARAM = "sso.url.Credential";
    public static final String SSO_TYPE_FORM_ACTION_URL = "sso.form.Action";
    public static final String SSO_TYPE_FORM_ACTION_ARGS = "sso.form.Args";
    public static final String SSO_TYPE_FORM_USERNAME_FIELD = "sso.form.Principal";
    public static final String SSO_TYPE_FORM_PASSWORD_FIELD = "sso.form.Credential";
    public static final String SSO_REQUEST_ATTRIBUTE_USERNAME = "sso.ra.username";
    public static final String SSO_REQUEST_ATTRIBUTE_PASSWORD = "sso.ra.password";
    public static final String SSO_EDIT_FIELD_PRINCIPAL = "ssoPrincipal";
    public static final String SSO_EDIT_FIELD_CREDENTIAL = "ssoCredential";
    public static final String FORM_AUTH_STATE = "ssowebcontent.form.authstate";
    protected static final Log log = LogFactory.getLog((Class)SSOWebContentPortlet.class);
    protected PortletContext context;
    protected SSOProvider sso;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.sso = (SSOProvider)this.context.getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find SSO Provider on portlet initialization");
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String webContentParameter = actionRequest.getParameter("_AP_URL");
        String ssoPrincipal = actionRequest.getParameter(SSO_EDIT_FIELD_PRINCIPAL);
        String ssoCredential = actionRequest.getParameter(SSO_EDIT_FIELD_CREDENTIAL);
        super.processAction(actionRequest, actionResponse);
        if (webContentParameter == null || actionRequest.getPortletMode() == PortletMode.EDIT) {
            String site = actionRequest.getPreferences().getValue("SRC", "");
            try {
                Subject subject = this.getSubject();
                if (this.sso.hasSSOCredentials(subject, site)) {
                    SSOContext context = this.sso.getCredentials(subject, site);
                    if (!context.getRemotePrincipalName().equals(ssoPrincipal)) {
                        this.sso.removeCredentialsForSite(subject, site);
                        this.sso.addCredentialsForSite(subject, ssoPrincipal, site, ssoCredential);
                    } else {
                        this.sso.updateCredentialsForSite(subject, ssoPrincipal, site, ssoCredential);
                    }
                } else {
                    this.sso.addCredentialsForSite(subject, ssoPrincipal, site, ssoCredential);
                }
            }
            catch (SSOException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String site = request.getPreferences().getValue("SRC", null);
        if (site == null) {
            request.setAttribute("ViewPage", (Object)this.getPortletConfig().getInitParameter("EditPage"));
            this.setupPreferencesEdit(request, response);
        } else {
            try {
                Subject subject = this.getSubject();
                SSOContext context = this.sso.getCredentials(subject, site);
                request.setAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME, (Object)context.getRemotePrincipalName());
                request.setAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD, (Object)context.getRemoteCredential());
            }
            catch (SSOException e) {
                if (e.getMessage().equals("The site has no Single Sign On credentails attached.")) {
                    request.setAttribute("ViewPage", (Object)this.getPortletConfig().getInitParameter("EditPage"));
                    this.setupPreferencesEdit(request, response);
                }
                throw new PortletException((Throwable)e);
            }
        }
        super.doView(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            Subject subject = this.getSubject();
            String site = request.getPreferences().getValue("SRC", "");
            SSOContext context = this.sso.getCredentials(subject, site);
            this.getContext(request).put(SSO_EDIT_FIELD_PRINCIPAL, (Object)context.getRemotePrincipalName());
            this.getContext(request).put(SSO_EDIT_FIELD_CREDENTIAL, (Object)context.getRemoteCredential());
        }
        catch (SSOException e) {
            if (e.getMessage().equals("The site has no Single Sign On credentails attached.")) {
                this.getContext(request).put(SSO_EDIT_FIELD_PRINCIPAL, (Object)"");
                this.getContext(request).put(SSO_EDIT_FIELD_CREDENTIAL, (Object)"");
            }
            throw new PortletException((Throwable)e);
        }
        super.doEdit(request, response);
    }

    private Subject getSubject() {
        AccessControlContext context = AccessController.getContext();
        return JSSubject.getSubject((AccessControlContext)context);
    }

    protected byte[] doPreemptiveAuthentication(HttpClient client, HttpMethod method, RenderRequest request, RenderResponse response) {
        byte[] result = super.doPreemptiveAuthentication(client, method, request, response);
        if (result != null) {
            return result;
        }
        PortletPreferences prefs = request.getPreferences();
        String type = this.getSingleSignOnAuthType(prefs);
        if (type.equalsIgnoreCase(SSO_TYPE_BASIC_PREEMPTIVE)) {
            String password;
            String userName = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME);
            if (userName == null) {
                userName = "";
            }
            if ((password = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)) == null) {
                password = "";
            }
            method.setDoAuthentication(true);
            method.getHostAuthState().setPreemptive();
            client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            return result;
        }
        if (type.startsWith(SSO_TYPE_FORM)) {
            try {
                int i;
                String password;
                Boolean formAuth = (Boolean)PortletMessaging.receive((PortletRequest)request, (String)FORM_AUTH_STATE);
                if (formAuth != null) {
                    return (byte[])(formAuth != false ? result : null);
                }
                PortletMessaging.publish((PortletRequest)request, (String)FORM_AUTH_STATE, (Object)Boolean.FALSE);
                String formAction = prefs.getValue(SSO_TYPE_FORM_ACTION_URL, "");
                if (formAction == null || formAction.length() == 0) {
                    log.warn((Object)"sso.type specified as 'form', but no: sso.form.Action, action was specified - unable to preemptively authenticate by form.");
                    return null;
                }
                String userNameField = prefs.getValue(SSO_TYPE_FORM_USERNAME_FIELD, "");
                if (userNameField == null || userNameField.length() == 0) {
                    log.warn((Object)"sso.type specified as 'form', but no: sso.form.Principal, username field was specified - unable to preemptively authenticate by form.");
                    return null;
                }
                String passwordField = prefs.getValue(SSO_TYPE_FORM_PASSWORD_FIELD, "password");
                if (passwordField == null || passwordField.length() == 0) {
                    log.warn((Object)"sso.type specified as 'form', but no: sso.form.Credential, password field was specified - unable to preemptively authenticate by form.");
                    return null;
                }
                String userName = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME);
                if (userName == null) {
                    userName = "";
                }
                if ((password = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)) == null) {
                    password = "";
                }
                boolean isPost = (i = type.indexOf(46)) > 0 ? type.substring(i + 1).equalsIgnoreCase("post") : true;
                HashMap<String, String[]> formParams = new HashMap<String, String[]>();
                formParams.put(userNameField, new String[]{userName});
                formParams.put(passwordField, new String[]{password});
                String formArgs = prefs.getValue(SSO_TYPE_FORM_ACTION_ARGS, "");
                if (formArgs != null && formArgs.length() > 0) {
                    StringTokenizer iter = new StringTokenizer(formArgs, ";");
                    while (iter.hasMoreTokens()) {
                        String pair = iter.nextToken();
                        i = pair.indexOf(61);
                        if (i <= 0) continue;
                        formParams.put(pair.substring(0, i), new String[]{pair.substring(i + 1)});
                    }
                }
                String formMethod = isPost ? "post" : "get";
                method = this.getHttpMethod(client, this.getURLSource(formAction, formParams, request, response), formParams, formMethod, request);
                result = this.doHttpWebContent(client, method, 0, request, response);
                PortletMessaging.publish((PortletRequest)request, (String)FORM_AUTH_STATE, (Object)(result != null ? 1 : 0));
                return result;
            }
            catch (Exception ex) {
                log.error((Object)"Form-based authentication failed", (Throwable)ex);
            }
        } else if (type.equalsIgnoreCase(SSO_TYPE_URL) || type.equalsIgnoreCase(SSO_TYPE_URL_BASE64)) {
            String password;
            String userNameParam = prefs.getValue(SSO_TYPE_URL_USERNAME_PARAM, "");
            if (userNameParam == null || userNameParam.length() == 0) {
                log.warn((Object)"sso.type specified as 'url', but no: sso.url.Principal, username parameter was specified - unable to preemptively authenticate by URL.");
                return null;
            }
            String passwordParam = prefs.getValue(SSO_TYPE_URL_PASSWORD_PARAM, "");
            if (passwordParam == null || passwordParam.length() == 0) {
                log.warn((Object)"sso.type specified as 'url', but no: sso.url.Credential, password parameter was specified - unable to preemptively authenticate by URL.");
                return null;
            }
            String userName = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME);
            if (userName == null) {
                userName = "";
            }
            if ((password = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)) == null) {
                password = "";
            }
            if (type.equalsIgnoreCase(SSO_TYPE_URL_BASE64)) {
                Base64 encoder = new Base64();
                userName = new String(encoder.encode(userName.getBytes()));
                password = new String(encoder.encode(password.getBytes()));
            }
            if (method instanceof PostMethod) {
                PostMethod postMethod = (PostMethod)method;
                postMethod.addParameter(userNameParam, userName);
                postMethod.addParameter(passwordParam, password);
            } else {
                NameValuePair[] authPairs = new NameValuePair[]{new NameValuePair(userNameParam, userName), new NameValuePair(passwordParam, password)};
                String existingQuery = method.getQueryString();
                method.setQueryString(authPairs);
                if (existingQuery != null && existingQuery.length() > 0) {
                    existingQuery = existingQuery + '&' + method.getQueryString();
                    method.setQueryString(existingQuery);
                }
            }
            return result;
        }
        return null;
    }

    protected boolean doRequestedAuthentication(HttpClient client, HttpMethod method, RenderRequest request, RenderResponse response) {
        if (super.doRequestedAuthentication(client, method, request, response)) {
            return true;
        }
        if (method.getHostAuthState().getAuthScheme().getSchemeName().equals(BASIC_AUTH_SCHEME_NAME)) {
            String password;
            String userName = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME);
            if (userName == null) {
                userName = "";
            }
            if ((password = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)) == null) {
                password = "";
            }
            method.setDoAuthentication(true);
            AuthState state = method.getHostAuthState();
            AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, state.getRealm(), state.getAuthScheme().getSchemeName());
            client.getState().setCredentials(scope, (Credentials)new UsernamePasswordCredentials(userName, password));
            return true;
        }
        log.warn((Object)("SSOWebContentPortlent.doAuthenticate() - unexpected authentication scheme: " + method.getHostAuthState().getAuthScheme().getSchemeName()));
        return false;
    }

    protected String getSingleSignOnAuthType(PortletPreferences prefs) {
        String type = prefs.getValue(SSO_TYPE, "basic");
        if (type != null && type.equalsIgnoreCase(SSO_TYPE_HTTP)) {
            log.warn((Object)"sso.type: http, has been deprecated - use: basic, or: basic.preemptive");
            type = "basic";
        }
        return type;
    }
}

