/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.jetspeed.portlet.SSOWebContentPortlet;
import org.apache.jetspeed.rewriter.ParserAdaptor;
import org.apache.jetspeed.rewriter.Rewriter;
import org.apache.jetspeed.rewriter.RewriterException;
import org.apache.jetspeed.rewriter.TicketParamRewriter;
import org.apache.jetspeed.rewriter.html.SwingParserAdaptor;

public class SSOTicketPortlet
extends SSOWebContentPortlet {
    public static final String SSO_PREF_TICKET_NAME = "ticket.name";
    protected Class adaptorHtmlClass = SwingParserAdaptor.class;
    public static final String FORM_POST_METHOD = "post";
    public static final String FORM_GET_METHOD = "get";
    public static final String FORM_MULTIPART_METHOD = "multipart";

    protected HttpMethodBase getHttpMethod(HttpClient client, String uri, Map params, String formMethod, RenderRequest request) throws IOException {
        String postURI = request.getPreferences().getValue("sso.form.Action", "");
        String ticketName = request.getPreferences().getValue(SSO_PREF_TICKET_NAME, "");
        if (uri.startsWith(postURI) && !params.containsKey(ticketName)) {
            params.put(ticketName, new String[]{this.requestTicket(uri, request, null)});
        }
        return super.getHttpMethod(client, uri, params, formMethod, request);
    }

    private String requestTicket(String url, RenderRequest request, RenderResponse response) {
        String ticket = "";
        HttpClient client = new HttpClient();
        PostMethod httpMethod = null;
        httpMethod = new PostMethod();
        httpMethod.addRequestHeader("User-Agent", "Firefox");
        httpMethod.setPath(url);
        try {
            client.executeMethod((HttpMethod)httpMethod);
            int responseCode = httpMethod.getStatusCode();
            if (responseCode >= 300 && responseCode <= 399) {
                String redirectLocation;
                Header locationHeader = httpMethod.getResponseHeader("location");
                String string = redirectLocation = locationHeader != null ? locationHeader.getValue() : null;
                if (redirectLocation != null) {
                    return this.requestTicket(redirectLocation, null, null);
                }
                throw new PortletException("Redirection code: " + responseCode + ", but with no redirectionLocation set.");
            }
            if (responseCode == 200) {
                TicketParamRewriter ticketWriter = new TicketParamRewriter();
                String ticketName = request.getPreferences().getValue(SSO_PREF_TICKET_NAME, null);
                if (ticketName != null) {
                    ticketWriter.setTicketName(ticketName);
                    InputStreamReader reader = new InputStreamReader(httpMethod.getResponseBodyAsStream());
                    this.createParserAdaptor().parse((Rewriter)ticketWriter, (Reader)reader);
                    ticket = ticketWriter.getTicket();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ticket;
    }

    public ParserAdaptor createParserAdaptor() throws RewriterException {
        try {
            return (ParserAdaptor)this.adaptorHtmlClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Error creating rewriter class", (Throwable)e);
            return null;
        }
    }
}

