/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.jetspeed.tools.migration.JetspeedMigration;
import org.apache.jetspeed.tools.migration.JetspeedMigrationListener;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResult;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResultImpl;

public class JetspeedStatisticsMigration
implements JetspeedMigration {
    public String getName() {
        return "Statistics";
    }

    public int detectSourceVersion(Connection sourceConnection, int sourceVersion) throws SQLException {
        return sourceVersion > 0 ? sourceVersion : 213;
    }

    public JetspeedMigrationResult migrate(Connection sourceConnection, int sourceVersion, Connection targetConnection, JetspeedMigrationListener migrationListener) throws SQLException {
        int rowsMigrated = 0;
        PreparedStatement portletStatisticsInsertStatement = targetConnection.prepareStatement("INSERT INTO PORTLET_STATISTICS (IPADDRESS, USER_NAME, TIME_STAMP, PAGE, PORTLET, STATUS, ELAPSED_TIME) VALUES (?, ?, ?, ?, ?, ?, ?)");
        Statement portletStatisticsQueryStatement = sourceConnection.createStatement();
        portletStatisticsQueryStatement.setFetchSize(10000);
        ResultSet portletStatisticsResultSet = portletStatisticsQueryStatement.executeQuery("SELECT IPADDRESS, USER_NAME, TIME_STAMP, PAGE, PORTLET, STATUS, ELAPSED_TIME FROM PORTLET_STATISTICS");
        while (portletStatisticsResultSet.next()) {
            portletStatisticsInsertStatement.setString(1, portletStatisticsResultSet.getString(1));
            portletStatisticsInsertStatement.setString(2, portletStatisticsResultSet.getString(2));
            portletStatisticsInsertStatement.setTimestamp(3, portletStatisticsResultSet.getTimestamp(3));
            portletStatisticsInsertStatement.setString(4, portletStatisticsResultSet.getString(4));
            String portlet = portletStatisticsResultSet.getString(5);
            switch (sourceVersion) {
                case 213: 
                case 214: {
                    String migratedPortlet = (String)PORTLET_NAME_2_1_X_TO_2_2_X_MIGRATION_MAP.get(portlet);
                    portlet = migratedPortlet != null ? migratedPortlet : portlet;
                }
            }
            portletStatisticsInsertStatement.setString(5, portlet);
            JetspeedMigration.Static.setNullableInt((ResultSet)portletStatisticsResultSet, (int)6, (PreparedStatement)portletStatisticsInsertStatement);
            JetspeedMigration.Static.setNullableLong((ResultSet)portletStatisticsResultSet, (int)7, (PreparedStatement)portletStatisticsInsertStatement);
            portletStatisticsInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        portletStatisticsResultSet.close();
        portletStatisticsQueryStatement.close();
        portletStatisticsInsertStatement.close();
        PreparedStatement pageStatisticsInsertStatement = targetConnection.prepareStatement("INSERT INTO PAGE_STATISTICS (IPADDRESS, USER_NAME, TIME_STAMP, PAGE, STATUS, ELAPSED_TIME) VALUES (?, ?, ?, ?, ?, ?)");
        Statement pageStatisticsQueryStatement = sourceConnection.createStatement();
        pageStatisticsQueryStatement.setFetchSize(10000);
        ResultSet pageStatisticsResultSet = pageStatisticsQueryStatement.executeQuery("SELECT IPADDRESS, USER_NAME, TIME_STAMP, PAGE, STATUS, ELAPSED_TIME FROM PAGE_STATISTICS");
        while (pageStatisticsResultSet.next()) {
            pageStatisticsInsertStatement.setString(1, pageStatisticsResultSet.getString(1));
            pageStatisticsInsertStatement.setString(2, pageStatisticsResultSet.getString(2));
            pageStatisticsInsertStatement.setTimestamp(3, pageStatisticsResultSet.getTimestamp(3));
            pageStatisticsInsertStatement.setString(4, pageStatisticsResultSet.getString(4));
            JetspeedMigration.Static.setNullableInt((ResultSet)pageStatisticsResultSet, (int)5, (PreparedStatement)pageStatisticsInsertStatement);
            JetspeedMigration.Static.setNullableLong((ResultSet)pageStatisticsResultSet, (int)6, (PreparedStatement)pageStatisticsInsertStatement);
            pageStatisticsInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        pageStatisticsResultSet.close();
        pageStatisticsQueryStatement.close();
        pageStatisticsInsertStatement.close();
        PreparedStatement userStatisticsInsertStatement = targetConnection.prepareStatement("INSERT INTO USER_STATISTICS (IPADDRESS, USER_NAME, TIME_STAMP, STATUS, ELAPSED_TIME) VALUES (?, ?, ?, ?, ?)");
        Statement userStatisticsQueryStatement = sourceConnection.createStatement();
        userStatisticsQueryStatement.setFetchSize(10000);
        ResultSet userStatisticsResultSet = userStatisticsQueryStatement.executeQuery("SELECT IPADDRESS, USER_NAME, TIME_STAMP, STATUS, ELAPSED_TIME FROM USER_STATISTICS");
        while (userStatisticsResultSet.next()) {
            userStatisticsInsertStatement.setString(1, userStatisticsResultSet.getString(1));
            userStatisticsInsertStatement.setString(2, userStatisticsResultSet.getString(2));
            userStatisticsInsertStatement.setTimestamp(3, userStatisticsResultSet.getTimestamp(3));
            JetspeedMigration.Static.setNullableInt((ResultSet)userStatisticsResultSet, (int)4, (PreparedStatement)userStatisticsInsertStatement);
            JetspeedMigration.Static.setNullableLong((ResultSet)userStatisticsResultSet, (int)5, (PreparedStatement)userStatisticsInsertStatement);
            userStatisticsInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        userStatisticsResultSet.close();
        userStatisticsQueryStatement.close();
        userStatisticsInsertStatement.close();
        PreparedStatement adminActivityInsertStatement = targetConnection.prepareStatement("INSERT INTO ADMIN_ACTIVITY (ACTIVITY, CATEGORY, ADMIN, USER_NAME, TIME_STAMP, IPADDRESS, ATTR_NAME, ATTR_VALUE_BEFORE, ATTR_VALUE_AFTER, DESCRIPTION) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Statement adminActivityQueryStatement = sourceConnection.createStatement();
        adminActivityQueryStatement.setFetchSize(10000);
        ResultSet adminActivityResultSet = adminActivityQueryStatement.executeQuery("SELECT ACTIVITY, CATEGORY, ADMIN, USER_NAME, TIME_STAMP, IPADDRESS, ATTR_NAME, ATTR_VALUE_BEFORE, ATTR_VALUE_AFTER, DESCRIPTION FROM ADMIN_ACTIVITY");
        while (adminActivityResultSet.next()) {
            adminActivityInsertStatement.setString(1, adminActivityResultSet.getString(1));
            adminActivityInsertStatement.setString(2, adminActivityResultSet.getString(2));
            adminActivityInsertStatement.setString(3, adminActivityResultSet.getString(3));
            adminActivityInsertStatement.setString(4, adminActivityResultSet.getString(4));
            adminActivityInsertStatement.setTimestamp(5, adminActivityResultSet.getTimestamp(5));
            adminActivityInsertStatement.setString(6, adminActivityResultSet.getString(6));
            adminActivityInsertStatement.setString(7, adminActivityResultSet.getString(7));
            adminActivityInsertStatement.setString(8, adminActivityResultSet.getString(8));
            adminActivityInsertStatement.setString(9, adminActivityResultSet.getString(9));
            adminActivityInsertStatement.setString(10, adminActivityResultSet.getString(10));
            adminActivityInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        adminActivityResultSet.close();
        adminActivityQueryStatement.close();
        adminActivityInsertStatement.close();
        PreparedStatement userActivityInsertStatement = targetConnection.prepareStatement("INSERT INTO USER_ACTIVITY (ACTIVITY, CATEGORY, USER_NAME, TIME_STAMP, IPADDRESS, ATTR_NAME, ATTR_VALUE_BEFORE, ATTR_VALUE_AFTER, DESCRIPTION) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Statement userActivityQueryStatement = sourceConnection.createStatement();
        userActivityQueryStatement.setFetchSize(10000);
        ResultSet userActivityResultSet = userActivityQueryStatement.executeQuery("SELECT ACTIVITY, CATEGORY, USER_NAME, TIME_STAMP, IPADDRESS, ATTR_NAME, ATTR_VALUE_BEFORE, ATTR_VALUE_AFTER, DESCRIPTION FROM USER_ACTIVITY");
        while (userActivityResultSet.next()) {
            userActivityInsertStatement.setString(1, userActivityResultSet.getString(1));
            userActivityInsertStatement.setString(2, userActivityResultSet.getString(2));
            userActivityInsertStatement.setString(3, userActivityResultSet.getString(3));
            userActivityInsertStatement.setTimestamp(4, userActivityResultSet.getTimestamp(4));
            userActivityInsertStatement.setString(5, userActivityResultSet.getString(5));
            userActivityInsertStatement.setString(6, userActivityResultSet.getString(6));
            userActivityInsertStatement.setString(7, userActivityResultSet.getString(7));
            userActivityInsertStatement.setString(8, userActivityResultSet.getString(8));
            userActivityInsertStatement.setString(9, userActivityResultSet.getString(9));
            userActivityInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        userActivityResultSet.close();
        userActivityQueryStatement.close();
        userActivityInsertStatement.close();
        return new JetspeedMigrationResultImpl(rowsMigrated);
    }
}

