/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.statistics.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jetspeed.statistics.impl.BatchedStatistics;
import org.apache.jetspeed.statistics.impl.LogRecord;
import org.apache.jetspeed.statistics.impl.PortletLogRecord;

public class BatchedPortletStatistics
extends BatchedStatistics {
    public BatchedPortletStatistics(DataSource ds, int batchSize, long msElapsedTimeThreshold, String name) {
        super(ds, batchSize, msElapsedTimeThreshold, name);
    }

    @Override
    public boolean canDoRecordType(LogRecord rec) {
        return rec instanceof PortletLogRecord;
    }

    @Override
    protected void loadOneRecordToStatement(PreparedStatement stm, LogRecord rec) throws SQLException {
        PortletLogRecord record = (PortletLogRecord)rec;
        stm.setString(1, record.getIpAddress());
        stm.setString(2, record.getUserName());
        stm.setTimestamp(3, record.getTimeStamp());
        stm.setString(4, record.getPagePath());
        stm.setString(5, record.getPortletName());
        stm.setInt(6, record.getStatus());
        stm.setLong(7, record.getMsElapsedTime());
    }

    @Override
    protected PreparedStatement getPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stm = con.prepareStatement("INSERT INTO PORTLET_STATISTICS VALUES(?,?,?,?,?,?,?)");
        return stm;
    }
}

