/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.statistics.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.jetspeed.statistics.impl.LogRecord;

public abstract class BatchedStatistics
implements Runnable {
    private boolean done = true;
    private boolean keepRunning = true;
    protected Thread thread;
    protected long msLastFlushTime = 0L;
    protected int batchSize = 10;
    protected long msElapsedTimeThreshold = 5000L;
    protected List logRecords = new LinkedList();
    protected DataSource ds = null;
    protected String name;

    public BatchedStatistics(DataSource ds, int batchSize, long msElapsedTimeThreshold, String name) {
        this.ds = ds;
        this.msElapsedTimeThreshold = msElapsedTimeThreshold;
        this.batchSize = batchSize;
        this.name = name;
        if (this.name == null) {
            this.name = this.getClass().getName();
        }
        this.msLastFlushTime = System.currentTimeMillis();
        this.thread = new Thread((Runnable)this, name);
    }

    public void startThread() {
        this.thread.start();
        while (this.done) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    private void checkAndDoFlush() {
        long msCurrentTime = System.currentTimeMillis();
        if (this.logRecords.size() >= this.batchSize || msCurrentTime - this.msLastFlushTime > this.msElapsedTimeThreshold) {
            this.flush();
            this.msLastFlushTime = msCurrentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatistic(LogRecord logRecord) {
        List list = this.logRecords;
        synchronized (list) {
            this.logRecords.add(logRecord);
            this.checkAndDoFlush();
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void tellThreadToStop() {
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        this.done = false;
        while (this.keepRunning) {
            try {
                object = this.thread;
                synchronized (object) {
                    this.thread.wait(this.msElapsedTimeThreshold / 4L);
                }
            }
            catch (InterruptedException ie) {
                this.keepRunning = false;
            }
            object = this.logRecords;
            synchronized (object) {
                this.checkAndDoFlush();
            }
        }
        object = this.logRecords;
        synchronized (object) {
            this.flush();
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.logRecords.isEmpty()) {
            return;
        }
        Connection con = null;
        Statement stm = null;
        try {
            con = this.getConnection();
            boolean autoCommit = con.getAutoCommit();
            con.setAutoCommit(false);
            stm = this.getPreparedStatement(con);
            Iterator recordIterator = this.logRecords.iterator();
            while (recordIterator.hasNext()) {
                LogRecord record = (LogRecord)recordIterator.next();
                this.loadOneRecordToStatement((PreparedStatement)stm, record);
                stm.addBatch();
            }
            stm.executeBatch();
            con.commit();
            this.logRecords.clear();
            con.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                con.rollback();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException sQLException) {}
            this.releaseConnection(con);
        }
    }

    protected abstract PreparedStatement getPreparedStatement(Connection var1) throws SQLException;

    protected abstract void loadOneRecordToStatement(PreparedStatement var1, LogRecord var2) throws SQLException;

    void releaseConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public abstract boolean canDoRecordType(LogRecord var1);
}

