/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.serializer.JetspeedSerializedData;
import org.apache.jetspeed.serializer.objects.JSApplications;
import org.apache.jetspeed.serializer.objects.JSCapabilities;
import org.apache.jetspeed.serializer.objects.JSClients;
import org.apache.jetspeed.serializer.objects.JSGroups;
import org.apache.jetspeed.serializer.objects.JSMediaTypes;
import org.apache.jetspeed.serializer.objects.JSMimeTypes;
import org.apache.jetspeed.serializer.objects.JSPermissions;
import org.apache.jetspeed.serializer.objects.JSPrincipalAssociation;
import org.apache.jetspeed.serializer.objects.JSPrincipalAssociations;
import org.apache.jetspeed.serializer.objects.JSPrincipals;
import org.apache.jetspeed.serializer.objects.JSProfilingRules;
import org.apache.jetspeed.serializer.objects.JSRoles;
import org.apache.jetspeed.serializer.objects.JSSecurityDomains;
import org.apache.jetspeed.serializer.objects.JSUsers;

public class JSSnapshot
implements JetspeedSerializedData {
    public static final int softwareVersion = 1;
    public static final int softwareSubVersion = 0;
    private String name;
    private int savedVersion;
    private int savedSubversion;
    private String dateCreated;
    private String dataSource;
    private String encryption;
    private JSMimeTypes mimeTypes = new JSMimeTypes();
    private JSMediaTypes mediaTypes = new JSMediaTypes();
    private JSClients clients = new JSClients();
    private JSCapabilities capabilities = new JSCapabilities();
    private JSRoles oldRoles = new JSRoles();
    private JSGroups oldGroups = new JSGroups();
    private JSUsers oldUsers = new JSUsers();
    private JSPrincipals principals = new JSPrincipals();
    private JSPrincipalAssociations principalAssociations = new JSPrincipalAssociations();
    private JSPermissions permissions = new JSPermissions();
    private JSProfilingRules rules = new JSProfilingRules();
    private String defaultRule;
    private JSApplications applications = new JSApplications();
    private JSSecurityDomains securityDomains = new JSSecurityDomains();
    protected static final XMLFormat XML = new XMLFormat(JSSnapshot.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSSnapshot g = (JSSnapshot)o;
                xml.setAttribute("name", g.getName());
                xml.add((Object)String.valueOf(g.getSoftwareVersion()), "softwareVersion");
                xml.add((Object)String.valueOf(g.getSoftwareSubVersion()), "softwareSubVersion");
                if (g.getDefaultRule() != null) {
                    xml.add((Object)g.getDefaultRule(), "default_rule", String.class);
                }
                if (g.getEncryption() != null) {
                    xml.add((Object)g.getEncryption(), "encryption", String.class);
                }
                if (!g.getMimeTypes().isEmpty()) {
                    xml.add((Object)g.getMimeTypes());
                }
                if (!g.getMediaTypes().isEmpty()) {
                    xml.add((Object)g.getMediaTypes());
                }
                if (!g.getCapabilities().isEmpty()) {
                    xml.add((Object)g.getCapabilities());
                }
                if (!g.getClients().isEmpty()) {
                    xml.add((Object)g.getClients());
                }
                if (!g.getOldRoles().isEmpty()) {
                    xml.add((Object)g.getOldRoles());
                }
                if (!g.getOldGroups().isEmpty()) {
                    xml.add((Object)g.getOldGroups());
                }
                if (!g.getOldUsers().isEmpty()) {
                    xml.add((Object)g.getOldUsers());
                }
                if (!g.getPrincipals().isEmpty()) {
                    xml.add((Object)g.getPrincipals());
                }
                if (!g.getPrincipalAssociations().isEmpty()) {
                    xml.add((Object)g.getPrincipalAssociations());
                }
                if (!g.getPermissions().isEmpty()) {
                    xml.add((Object)g.getPermissions());
                }
                if (!g.getRules().isEmpty()) {
                    xml.add((Object)g.getRules());
                }
                if (!g.getApplications().isEmpty()) {
                    xml.add((Object)g.getApplications());
                }
                if (!g.getSecurityDomains().isEmpty()) {
                    xml.add((Object)g.getSecurityDomains());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof XMLStreamException) {
                    throw (XMLStreamException)e;
                }
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) throws XMLStreamException {
            try {
                JSSnapshot g = (JSSnapshot)o;
                g.name = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", "unknown"));
                Object o1 = xml.get("softwareVersion", String.class);
                if (o1 != null && o1 instanceof String) {
                    g.savedVersion = Integer.parseInt((String)o1);
                }
                if ((o1 = xml.get("softwareSubVersion", String.class)) != null && o1 instanceof String) {
                    g.savedSubversion = Integer.parseInt((String)o1);
                }
                if ((o1 = xml.get("default_rule", String.class)) != null && o1 instanceof String) {
                    g.defaultRule = StringEscapeUtils.unescapeHtml((String)((String)o1));
                }
                if ((o1 = xml.get("encryption", String.class)) != null && o1 instanceof String) {
                    g.encryption = StringEscapeUtils.unescapeHtml((String)((String)o1));
                }
                while (xml.hasNext()) {
                    o1 = xml.getNext();
                    if (o1 instanceof JSMimeTypes) {
                        g.mimeTypes = (JSMimeTypes)o1;
                        continue;
                    }
                    if (o1 instanceof JSMediaTypes) {
                        g.mediaTypes = (JSMediaTypes)o1;
                        continue;
                    }
                    if (o1 instanceof JSClients) {
                        g.clients = (JSClients)o1;
                        continue;
                    }
                    if (o1 instanceof JSCapabilities) {
                        g.capabilities = (JSCapabilities)o1;
                        continue;
                    }
                    if (o1 instanceof JSRoles) {
                        g.oldRoles = (JSRoles)o1;
                        continue;
                    }
                    if (o1 instanceof JSGroups) {
                        g.oldGroups = (JSGroups)o1;
                        continue;
                    }
                    if (o1 instanceof JSUsers) {
                        g.oldUsers = (JSUsers)o1;
                        continue;
                    }
                    if (o1 instanceof JSPrincipals) {
                        g.principals = (JSPrincipals)o1;
                        continue;
                    }
                    if (o1 instanceof JSPrincipalAssociations) {
                        g.principalAssociations = (JSPrincipalAssociations)o1;
                        continue;
                    }
                    if (o1 instanceof JSPermissions) {
                        g.permissions = (JSPermissions)o1;
                        continue;
                    }
                    if (o1 instanceof JSProfilingRules) {
                        g.rules = (JSProfilingRules)o1;
                        continue;
                    }
                    if (o1 instanceof JSApplications) {
                        g.applications = (JSApplications)o1;
                        continue;
                    }
                    if (!(o1 instanceof JSSecurityDomains)) continue;
                    g.securityDomains = (JSSecurityDomains)o1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof XMLStreamException) {
                    throw (XMLStreamException)e;
                }
                throw new XMLStreamException((Throwable)e);
            }
        }
    };

    public boolean checkVersion() {
        return true;
    }

    public JSSnapshot() {
    }

    public JSSnapshot(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSoftwareSubVersion() {
        return 0;
    }

    public int getSoftwareVersion() {
        return 1;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public int getSavedSubversion() {
        return this.savedSubversion;
    }

    public void setSavedSubversion(int savedSubversion) {
        this.savedSubversion = savedSubversion;
    }

    public int getSavedVersion() {
        return this.savedVersion;
    }

    public void setSavedVersion(int savedVersion) {
        this.savedVersion = savedVersion;
    }

    public JSGroups getOldGroups() {
        return this.oldGroups;
    }

    public void setOldGroups(JSGroups oldGroups) {
        this.oldGroups = oldGroups;
    }

    public JSRoles getOldRoles() {
        return this.oldRoles;
    }

    public void setOldRoles(JSRoles oldRoles) {
        this.oldRoles = oldRoles;
    }

    public JSUsers getOldUsers() {
        return this.oldUsers;
    }

    public JSPrincipals getPrincipals() {
        return this.principals;
    }

    public void setPrincipalAssociations(JSPrincipalAssociations principalAssociations) {
        this.principalAssociations = principalAssociations;
    }

    public JSPrincipalAssociations getPrincipalAssociations() {
        return this.principalAssociations;
    }

    public void addPrincipalAssociation(JSPrincipalAssociation jsPrincipalAssociation) {
        this.principalAssociations.add(jsPrincipalAssociation);
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    public JSCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(JSCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public JSClients getClients() {
        return this.clients;
    }

    public void setClients(JSClients clients) {
        this.clients = clients;
    }

    public JSMediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(JSMediaTypes mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public JSMimeTypes getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(JSMimeTypes mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public JSPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(JSPermissions permissions) {
        this.permissions = permissions;
    }

    public JSProfilingRules getRules() {
        return this.rules;
    }

    public void setRules(JSProfilingRules rules) {
        this.rules = rules;
    }

    public String getDefaultRule() {
        return this.defaultRule;
    }

    public void setDefaultRule(String defaultRule) {
        this.defaultRule = defaultRule;
    }

    public JSApplications getApplications() {
        return this.applications;
    }

    public void setApplications(JSApplications applications) {
        this.applications = applications;
    }

    public JSSecurityDomains getSecurityDomains() {
        return this.securityDomains;
    }

    public void setSecurityDomains(JSSecurityDomains securityDomains) {
        this.securityDomains = securityDomains;
    }
}

