/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.security.Permission;
import java.security.Principal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.security.auth.Subject;
import javolution.xml.XMLBinding;
import org.apache.jetspeed.capabilities.Capabilities;
import org.apache.jetspeed.capabilities.Capability;
import org.apache.jetspeed.capabilities.Client;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.profiler.rules.PrincipalRule;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.security.BasePrincipal;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.PortalResourcePermission;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalPermission;
import org.apache.jetspeed.security.om.InternalPrincipal;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.spi.PasswordCredentialProvider;
import org.apache.jetspeed.serializer.JetspeedSerializer;
import org.apache.jetspeed.serializer.JetspeedSerializerBase;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSCapabilities;
import org.apache.jetspeed.serializer.objects.JSCapability;
import org.apache.jetspeed.serializer.objects.JSClient;
import org.apache.jetspeed.serializer.objects.JSClientCapabilities;
import org.apache.jetspeed.serializer.objects.JSClientMimeTypes;
import org.apache.jetspeed.serializer.objects.JSClients;
import org.apache.jetspeed.serializer.objects.JSGroup;
import org.apache.jetspeed.serializer.objects.JSGroups;
import org.apache.jetspeed.serializer.objects.JSMediaType;
import org.apache.jetspeed.serializer.objects.JSMediaTypes;
import org.apache.jetspeed.serializer.objects.JSMimeType;
import org.apache.jetspeed.serializer.objects.JSMimeTypes;
import org.apache.jetspeed.serializer.objects.JSNVPElements;
import org.apache.jetspeed.serializer.objects.JSPWAttributes;
import org.apache.jetspeed.serializer.objects.JSPermission;
import org.apache.jetspeed.serializer.objects.JSPermissions;
import org.apache.jetspeed.serializer.objects.JSPrincipalRule;
import org.apache.jetspeed.serializer.objects.JSPrincipalRules;
import org.apache.jetspeed.serializer.objects.JSProfilingRule;
import org.apache.jetspeed.serializer.objects.JSProfilingRules;
import org.apache.jetspeed.serializer.objects.JSRole;
import org.apache.jetspeed.serializer.objects.JSRoles;
import org.apache.jetspeed.serializer.objects.JSRuleCriterion;
import org.apache.jetspeed.serializer.objects.JSRuleCriterions;
import org.apache.jetspeed.serializer.objects.JSSSOSite;
import org.apache.jetspeed.serializer.objects.JSSSOSiteRemoteUser;
import org.apache.jetspeed.serializer.objects.JSSSOSiteRemoteUsers;
import org.apache.jetspeed.serializer.objects.JSSSOSites;
import org.apache.jetspeed.serializer.objects.JSSeedData;
import org.apache.jetspeed.serializer.objects.JSSnapshot;
import org.apache.jetspeed.serializer.objects.JSUser;
import org.apache.jetspeed.serializer.objects.JSUserAttributes;
import org.apache.jetspeed.serializer.objects.JSUserGroups;
import org.apache.jetspeed.serializer.objects.JSUserRoles;
import org.apache.jetspeed.serializer.objects.JSUserUsers;
import org.apache.jetspeed.serializer.objects.JSUsers;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOProvider;
import org.apache.jetspeed.sso.SSOSite;

public class JetspeedSerializerImpl
extends JetspeedSerializerBase
implements JetspeedSerializer {
    private HashMap roleMap = new HashMap();
    private HashMap groupMap = new HashMap();
    private HashMap userMap = new HashMap();
    private HashMap mimeMap = new HashMap();
    private HashMap mimeMapInt = new HashMap();
    private HashMap mediaMap = new HashMap();
    private HashMap capabilityMap = new HashMap();
    private HashMap capabilityMapInt = new HashMap();
    private HashMap clientMap = new HashMap();
    private HashMap permissionMap = new HashMap();
    private HashMap rulesMap = new HashMap();
    private HashMap ssoSitesMap = new HashMap();
    int refCouter = 0;
    private static String ENCODING_STRING = "JETSPEED-SERIALIZER-ENCODING";
    private static String JETSPEED = "JETSPEED";

    protected Class getSerializerDataClass() {
        return JSSeedData.class;
    }

    protected String getSerializerDataTag() {
        return "Snapshot";
    }

    public JetspeedSerializerImpl() {
    }

    public JetspeedSerializerImpl(ComponentManager cm) {
        super(cm);
    }

    public JetspeedSerializerImpl(String appRoot, String[] bootConfig, String[] appConfig) throws SerializerException {
        super(appRoot, bootConfig, appConfig);
    }

    protected void resetSettings() {
        this.setSetting(JetspeedSerializer.KEY_PROCESS_USERS, true);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_CAPABILITIES, true);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_PROFILER, true);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_PERMISSIONS, true);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_SSO, true);
        this.setSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING, true);
        this.setSetting(JetspeedSerializer.KEY_BACKUP_BEFORE_PROCESS, true);
    }

    protected void getSnapshotData() {
        this.logMe("date created : " + this.getSnapshot().getDateCreated());
        this.logMe("software Version : " + this.getSnapshot().getSavedVersion());
        this.logMe("software SUbVersion : " + this.getSnapshot().getSavedSubversion());
    }

    private void recreateCapabilities(Capabilities caps) throws SerializerException {
        this.logMe("recreateCapabilities - processing");
        JSCapabilities capabilities = ((JSSeedData)this.getSnapshot()).getCapabilities();
        if (capabilities != null && capabilities.size() > 0) {
            Iterator _it = capabilities.iterator();
            while (_it.hasNext()) {
                JSCapability _c = (JSCapability)_it.next();
                try {
                    Capability capability = caps.createCapability(_c.getName());
                    if (this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING) || capability.getCapabilityId() == 0) {
                        caps.storeCapability(capability);
                    }
                    this.capabilityMap.put(_c.getName(), capability);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.Capabilities", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            this.logMe("NO CAPABILITES?????");
        }
        this.logMe("recreateCapabilities - done");
    }

    private void recreateMimeTypes(Capabilities caps) throws SerializerException {
        this.logMe("recreateMimeTypes - processing");
        JSMimeTypes mimeTypes = ((JSSeedData)this.getSnapshot()).getMimeTypes();
        if (mimeTypes != null && mimeTypes.size() > 0) {
            Iterator _it = mimeTypes.iterator();
            while (_it.hasNext()) {
                JSMimeType _c = (JSMimeType)_it.next();
                try {
                    MimeType mimeType = caps.createMimeType(_c.getName());
                    if (this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING) || mimeType.getMimetypeId() == 0) {
                        caps.storeMimeType(mimeType);
                    }
                    this.mimeMap.put(_c.getName(), mimeType);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.MimeType", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            this.logMe("NO MIME TYPES?????");
        }
        this.logMe("recreateMimeTypes - done");
    }

    private void recreateMediaTypes(Capabilities caps) throws SerializerException {
        this.logMe("recreateMediaTypes - processing");
        JSMediaTypes mediaTypes = ((JSSeedData)this.getSnapshot()).getMediaTypes();
        if (mediaTypes != null && mediaTypes.size() > 0) {
            Iterator _it = mediaTypes.iterator();
            while (_it.hasNext()) {
                JSMediaType _c = (JSMediaType)_it.next();
                try {
                    MediaType mediaType = caps.createMediaType(_c.getName());
                    if (this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING) || mediaType.getMediatypeId() == 0) {
                        int added;
                        Iterator _it1;
                        ArrayList list;
                        String _line;
                        mediaType.setCharacterSet(_c.getCharacterSet());
                        mediaType.setTitle(_c.getTitle());
                        mediaType.setDescription(_c.getDescription());
                        try {
                            _line = _c.getMimeTypesString().toString();
                            list = this.getTokens(_line);
                            if (list != null && list.size() > 0) {
                                _it1 = list.iterator();
                                added = 0;
                                while (_it1.hasNext()) {
                                    MimeType _mt = caps.createMimeType((String)_it1.next());
                                    if (_mt != null) {
                                        mediaType.addMimetype(_mt);
                                    }
                                    ++added;
                                }
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        try {
                            _line = _c.getCapabilitiesString().toString();
                            list = this.getTokens(_line);
                            if (list != null && list.size() > 0) {
                                _it1 = list.iterator();
                                if (list != null && list.size() > 0) {
                                    added = 0;
                                    while (_it1.hasNext()) {
                                        Capability _ct = caps.createCapability((String)_it1.next());
                                        if (_ct != null) {
                                            mediaType.addCapability(_ct);
                                        }
                                        ++added;
                                    }
                                }
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        caps.storeMediaType(mediaType);
                    }
                    this.mediaMap.put(_c.getName(), mediaType);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.MediaType", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            this.logMe("NO MEDIA TYPES?????");
        }
        this.logMe("recreateMediaTypes - done");
    }

    private void recreateClients(Capabilities caps) throws SerializerException {
        this.logMe("recreateClients - processing");
        JSClients clients = ((JSSeedData)this.getSnapshot()).getClients();
        if (clients != null && clients.size() > 0) {
            Iterator _it = clients.iterator();
            while (_it.hasNext()) {
                JSClient _c = (JSClient)_it.next();
                try {
                    Client client = caps.createClient(_c.getName());
                    if (this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING) || client.getClientId() == 0) {
                        int added;
                        Iterator _it1;
                        ArrayList list;
                        String _line;
                        client.setUserAgentPattern(_c.getUserAgentPattern());
                        client.setManufacturer(_c.getManufacturer());
                        client.setModel(_c.getModel());
                        client.setEvalOrder(_c.getEvalOrder());
                        String myPrefMimeType = _c.getPreferredMimeTypeID();
                        client.setVersion(_c.getVersion());
                        try {
                            _line = _c.getMimeTypesString().toString();
                            list = this.getTokens(_line);
                            if (list != null && list.size() > 0) {
                                _it1 = list.iterator();
                                added = 0;
                                while (_it1.hasNext()) {
                                    MimeType _mt = caps.createMimeType((String)_it1.next());
                                    if (_mt != null) {
                                        client.getMimetypes().add(_mt);
                                        if (_mt.getMimetypeId() == 0) {
                                            caps.storeMimeType(_mt);
                                        }
                                        if (myPrefMimeType.equalsIgnoreCase(_mt.getName())) {
                                            client.setPreferredMimeTypeId(_mt.getMimetypeId());
                                        }
                                    }
                                    ++added;
                                }
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        try {
                            _line = _c.getCapabilitiesString().toString();
                            list = this.getTokens(_line);
                            if (list != null && list.size() > 0) {
                                _it1 = list.iterator();
                                if (list != null && list.size() > 0) {
                                    added = 0;
                                    while (_it1.hasNext()) {
                                        Capability _ct = caps.createCapability((String)_it1.next());
                                        if (_ct != null) {
                                            client.getCapabilities().add(_ct);
                                        }
                                        ++added;
                                    }
                                }
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        caps.storeClient(client);
                    }
                    this.clientMap.put(_c.getName(), client);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.Client", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            this.logMe("NO MEDIA TYPES?????");
        }
        this.logMe("recreateClients - done");
    }

    private void importCapabilitiesInfrastructure() throws SerializerException {
        this.logMe("importCapabilitiesInfrastructure - processing");
        Capabilities caps = (Capabilities)this.getCM().getComponent((Object)"org.apache.jetspeed.capabilities.Capabilities");
        if (caps == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.capabilities.Capabilities"));
        }
        this.recreateCapabilities(caps);
        this.recreateMimeTypes(caps);
        this.recreateMediaTypes(caps);
        this.recreateClients(caps);
        this.logMe("importCapabilitiesInfrastructure - processing done");
    }

    private void recreateRolesGroupsUsers() throws SerializerException {
        String name;
        this.logMe("recreateRolesGroupsUsers");
        GroupManager groupManager = (GroupManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.GroupManager");
        if (groupManager == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.GroupManager"));
        }
        RoleManager roleManager = (RoleManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.RoleManager");
        if (roleManager == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.RoleManager"));
        }
        UserManager userManager = (UserManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.UserManager");
        if (userManager == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.UserManager"));
        }
        JSGroups groups = null;
        JSRoles roles = null;
        Iterator _it = null;
        groups = ((JSSeedData)this.getSnapshot()).getGroups();
        if (groups != null) {
            _it = groups.iterator();
            while (_it.hasNext()) {
                name = ((JSGroup)_it.next()).getName();
                try {
                    if (!groupManager.groupExists(name)) {
                        groupManager.addGroup(name);
                    }
                    Group group = groupManager.getGroup(name);
                    this.groupMap.put(name, group.getPrincipal());
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"Group", e.getMessage()}));
                }
            }
        }
        this.logMe("recreateGroups - done");
        this.logMe("processing roles");
        roles = ((JSSeedData)this.getSnapshot()).getRoles();
        if (roles != null) {
            _it = roles.iterator();
            while (_it.hasNext()) {
                name = ((JSRole)_it.next()).getName();
                try {
                    if (!roleManager.roleExists(name)) {
                        roleManager.addRole(name);
                    }
                    Role role = roleManager.getRole(name);
                    this.roleMap.put(name, role.getPrincipal());
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"Role", e.getMessage()}));
                }
            }
        }
        this.logMe("recreateRoles - done");
        this.logMe("processing users");
        int passwordEncoding = this.compareCurrentSecurityProvider((JSSeedData)this.getSnapshot());
        JSUsers users = null;
        users = ((JSSeedData)this.getSnapshot()).getUsers();
        if (users != null) {
            _it = users.iterator();
            while (_it.hasNext()) {
                JSUser jsuser = (JSUser)_it.next();
                try {
                    JSNVPElements jsNVP;
                    Iterator _itTemp;
                    JSUserAttributes attributes;
                    JSUserRoles jsUserRoles;
                    JSUserGroups jsUserGroups;
                    Iterator _itTemp2;
                    User user = null;
                    if (userManager.userExists(jsuser.getName())) {
                        user = userManager.getUser(jsuser.getName());
                    }
                    if (!this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING) && user != null) continue;
                    if (user == null) {
                        String password = this.recreatePassword(jsuser.getPassword());
                        this.logMe("add User " + jsuser.getName() + " with password " + password);
                        userManager.importUser(jsuser.getName(), password, passwordEncoding == 1);
                        this.logMe("add User done ");
                        user = userManager.getUser(jsuser.getName());
                    }
                    try {
                        userManager.setPasswordEnabled(jsuser.getName(), jsuser.getPwEnabled());
                        userManager.setPasswordUpdateRequired(jsuser.getName(), jsuser.getPwRequiredUpdate());
                        Date d = jsuser.getPwExpirationDate();
                        if (d != null) {
                            userManager.setPasswordExpiration(jsuser.getName(), d);
                        }
                    }
                    catch (Exception e) {
                        this.logMe("setting userinfo for " + jsuser.getName() + " failed because of " + e.getLocalizedMessage());
                    }
                    Subject subject = user.getSubject();
                    ArrayList listTemp = jsuser.getPrivateCredentials();
                    if (listTemp != null && listTemp.size() > 0) {
                        _itTemp2 = listTemp.iterator();
                        while (_itTemp2.hasNext()) {
                            subject.getPrivateCredentials().add(_itTemp2.next());
                        }
                    }
                    if ((listTemp = jsuser.getPublicCredentials()) != null && listTemp.size() > 0) {
                        _itTemp2 = listTemp.iterator();
                        while (_itTemp2.hasNext()) {
                            subject.getPublicCredentials().add(_itTemp2.next());
                        }
                    }
                    if ((listTemp = (jsUserGroups = jsuser.getGroupString()) != null ? this.getTokens(jsUserGroups.toString()) : null) != null && listTemp.size() > 0) {
                        Iterator _itTemp3 = listTemp.iterator();
                        while (_itTemp3.hasNext()) {
                            groupManager.addUserToGroup(jsuser.getName(), (String)_itTemp3.next());
                        }
                    }
                    if ((listTemp = (jsUserRoles = jsuser.getRoleString()) != null ? this.getTokens(jsUserRoles.toString()) : null) != null && listTemp.size() > 0) {
                        Iterator _itTemp4 = listTemp.iterator();
                        while (_itTemp4.hasNext()) {
                            roleManager.addRoleToUser(jsuser.getName(), (String)_itTemp4.next());
                        }
                    }
                    if ((attributes = jsuser.getUserInfo()) != null) {
                        Preferences userAttributes = user.getUserAttributes();
                        HashMap map = attributes.getMyMap();
                        if (map != null) {
                            _itTemp = map.keySet().iterator();
                            while (_itTemp.hasNext()) {
                                String userAttrName = (String)_itTemp.next();
                                String userAttrValue = (String)map.get(userAttrName);
                                userAttributes.put(userAttrName, userAttrValue);
                            }
                        }
                    }
                    if ((jsNVP = jsuser.getPreferences()) != null && jsNVP.getMyMap() != null) {
                        Preferences preferences = user.getPreferences();
                        _itTemp = jsNVP.getMyMap().keySet().iterator();
                        while (_itTemp.hasNext()) {
                            String prefKey = (String)_itTemp.next();
                            String prefValue = (String)jsNVP.getMyMap().get(prefKey);
                            preferences.put(prefKey, prefValue);
                        }
                    }
                    this.userMap.put(jsuser.getName(), this.getUserPrincipal(user));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"User", e.getMessage()}));
                }
            }
        }
        this.logMe("recreateUsers - done");
    }

    private void recreateUserPrincipalRules() throws SerializerException {
        this.logMe("recreateUserPrincipalRules - started");
        Profiler pm = (Profiler)this.getCM().getComponent((Object)"org.apache.jetspeed.profiler.Profiler");
        if (pm == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.profiler.Profiler"));
        }
        UserManager userManager = (UserManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.UserManager");
        if (userManager == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.UserManager"));
        }
        Iterator _itUsers = ((JSSeedData)this.getSnapshot()).getUsers().iterator();
        while (_itUsers.hasNext()) {
            JSUser _user = (JSUser)_itUsers.next();
            JSPrincipalRules jsRules = _user.getRules();
            try {
                User user = userManager.getUser(_user.getName());
                Principal principal = this.getUserPrincipal(user);
                if (jsRules == null) continue;
                Iterator _itRoles = jsRules.iterator();
                while (_itRoles.hasNext()) {
                    JSPrincipalRule pr = (JSPrincipalRule)_itRoles.next();
                    ProfilingRule pRule = pm.getRule(pr.getRule());
                    try {
                        PrincipalRule p1 = pm.createPrincipalRule();
                        p1.setLocatorName(pr.getLocator());
                        p1.setProfilingRule(pRule);
                        p1.setPrincipalName(principal.getName());
                        pm.storePrincipalRule(p1);
                    }
                    catch (Exception eRole) {
                        eRole.printStackTrace();
                    }
                }
            }
            catch (Exception eUser) {
                eUser.printStackTrace();
            }
        }
        this.logMe("recreateUserPrincipalRules - done");
    }

    private void recreatePermissions() throws SerializerException {
        this.logMe("recreatePermissions - started");
        PermissionManager pm = (PermissionManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.PermissionManager");
        if (pm == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.PermissionManager"));
        }
        Iterator list = null;
        JSPermissions permissions = ((JSSeedData)this.getSnapshot()).getPermissions();
        if (permissions != null) {
            list = permissions.iterator();
            while (list.hasNext()) {
                JSPermission _js = (JSPermission)list.next();
                PortalResourcePermission perm = _js.getPermissionForType();
                if (perm == null || !(perm instanceof PortalResourcePermission)) continue;
                try {
                    JSUserUsers jsUserUsers;
                    JSUserRoles jsUserRoles;
                    pm.addPermission((Permission)perm);
                    ArrayList listTemp = null;
                    JSUserGroups jsUserGroups = _js.getGroupString();
                    listTemp = jsUserGroups != null ? this.getTokens(jsUserGroups.toString()) : null;
                    if (listTemp != null && listTemp.size() > 0) {
                        Iterator _itTemp = listTemp.iterator();
                        while (_itTemp.hasNext()) {
                            Principal p = (Principal)this.groupMap.get((String)_itTemp.next());
                            if (p == null) continue;
                            pm.grantPermission(p, (Permission)perm);
                        }
                    }
                    if ((listTemp = (jsUserRoles = _js.getRoleString()) != null ? this.getTokens(jsUserRoles.toString()) : null) != null && listTemp.size() > 0) {
                        Iterator _itTemp = listTemp.iterator();
                        while (_itTemp.hasNext()) {
                            Principal p = (Principal)this.roleMap.get((String)_itTemp.next());
                            if (p == null) continue;
                            pm.grantPermission(p, (Permission)perm);
                        }
                    }
                    if ((listTemp = (jsUserUsers = _js.getUserString()) != null ? this.getTokens(jsUserUsers.toString()) : null) == null || listTemp.size() <= 0) continue;
                    Iterator _itTemp = listTemp.iterator();
                    while (_itTemp.hasNext()) {
                        Principal p = (Principal)this.userMap.get((String)_itTemp.next());
                        if (p == null) continue;
                        pm.grantPermission(p, (Permission)perm);
                    }
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Permissions", e.getMessage()}));
                }
            }
        }
        this.logMe("recreatePermissions - done");
    }

    private Principal getUserPrincipal(User user) {
        Subject subject = user.getSubject();
        Set<Principal> principals = subject.getPrincipals();
        Iterator<Principal> list = principals.iterator();
        while (list.hasNext()) {
            BasePrincipal principal = (BasePrincipal)list.next();
            String path = principal.getFullPath();
            if (!path.startsWith("/user/")) continue;
            return principal;
        }
        return null;
    }

    private void importProfiler() {
        System.out.println("importProfiler - processing");
        try {
            this.recreateProfilingRules();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importUserGroupRoles() {
        System.out.println("importUserGroupRoles - processing");
        try {
            this.recreateRolesGroupsUsers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importUserPrincipals() {
        System.out.println("importUserPrincipals - processing");
        try {
            this.recreateUserPrincipalRules();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importSSO() {
        System.out.println("importSSO - processing");
        try {
            this.recreateSSOSites();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processImport() throws SerializerException {
        this.logMe("*********reinstalling data*********");
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_CAPABILITIES)) {
            this.logMe("creating clients, mediatypes and mimetypes");
            this.importCapabilitiesInfrastructure();
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_PROFILER)) {
            this.logMe("collecting permissions, profiling rules and users/proups etc. etc.");
            this.importProfiler();
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_USERS)) {
            this.logMe("creating users/roles/groups");
            this.importUserGroupRoles();
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_PROFILER) || this.getSetting(JetspeedSerializer.KEY_PROCESS_USERS)) {
            this.logMe("collecting user principals");
            this.importUserPrincipals();
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_PERMISSIONS)) {
            this.logMe("permissions, rules etc. skipped ");
            this.recreatePermissions();
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_SSO)) {
            this.logMe("importing sso");
            this.importSSO();
        }
    }

    protected void processExport(String name, XMLBinding binding) throws SerializerException {
        this.logMe("*********collecting data*********");
        this.setSnapshot(new JSSeedData(name));
        this.setSnapshotData();
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_CAPABILITIES)) {
            this.logMe("collecting clients, mediatypes and mimetypes");
            this.exportCapabilitiesInfrastructure();
        } else {
            this.logMe("capabilities skipped");
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_USERS)) {
            this.logMe("collecting users");
            this.exportUsers();
        } else {
            this.logMe("users skipped");
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_PROFILER)) {
            this.logMe("collecting profiling rules");
            this.getProfilingRules();
        } else {
            this.logMe(" profiling rules skipped");
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_PERMISSIONS)) {
            this.logMe("collecting permissions");
            this.getPermissions();
        } else {
            this.logMe(" permissions skipped");
        }
        if (this.getSetting(JetspeedSerializer.KEY_PROCESS_SSO)) {
            this.logMe("collecting sso sites");
            this.getSSOSites();
        } else {
            this.logMe(" sso skipped");
        }
    }

    protected void setupAliases(XMLBinding binding) {
        binding.setAlias(JSRole.class, "Role");
        binding.setAlias(JSRoles.class, "Roles");
        binding.setAlias(JSGroup.class, "Group");
        binding.setAlias(JSGroups.class, "Groups");
        binding.setAlias(JSUser.class, "User");
        binding.setAlias(JSUsers.class, "Users");
        binding.setAlias(JSNVPElements.class, "preferences");
        binding.setAlias(JSUserAttributes.class, "userinfo");
        binding.setAlias(JSSnapshot.class, "snapshot");
        binding.setAlias(JSUserRoles.class, "roles");
        binding.setAlias(JSUserGroups.class, "groups");
        binding.setAlias(JSClient.class, "Client");
        binding.setAlias(JSClients.class, "Clients");
        binding.setAlias(JSClientCapabilities.class, "capabilities");
        binding.setAlias(JSClientMimeTypes.class, "mimeTypes");
        binding.setAlias(JSMimeTypes.class, "MimeTypes");
        binding.setAlias(JSMimeType.class, "MimeType");
        binding.setAlias(JSCapabilities.class, "Capabilities");
        binding.setAlias(JSCapability.class, "Capability");
        binding.setAlias(JSMediaTypes.class, "MediaTypes");
        binding.setAlias(JSMediaType.class, "MediaType");
        binding.setAlias(JSUserUsers.class, "users");
        binding.setAlias(JSPermissions.class, "Permissions");
        binding.setAlias(JSPermission.class, "Permission");
        binding.setAlias(JSProfilingRules.class, "ProfilingRules");
        binding.setAlias(JSProfilingRule.class, "ProfilingRule");
        binding.setAlias(JSRuleCriterions.class, "Criteria");
        binding.setAlias(JSRuleCriterion.class, "Criterion");
        binding.setAlias(JSPrincipalRule.class, "Rule");
        binding.setAlias(JSPrincipalRules.class, "Rules");
        binding.setAlias(String.class, "String");
        binding.setAlias(Integer.class, "int");
        binding.setAlias(JSPWAttributes.class, "credentials");
        binding.setAlias(JSSSOSite.class, "Site");
        binding.setAlias(JSSSOSiteRemoteUser.class, "RemoteUser");
        binding.setAlias(JSSSOSiteRemoteUsers.class, "RemoteUsers");
        binding.setAlias(JSSSOSites.class, "SSOSites");
        binding.setClassAttribute(null);
    }

    private Object getObjectBehindPrinicpal(Map map, BasePrincipal _principal) {
        return this.getObjectBehindPath(map, _principal.getFullPath());
    }

    private JSRole createJSRole(Role role) {
        JSRole _role = new JSRole();
        _role.setName(role.getPrincipal().getName());
        return _role;
    }

    private void exportRoles() throws SerializerException {
        RoleManager roleManager = (RoleManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.RoleManager");
        if (roleManager == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.RoleManager"));
        }
        Iterator list = null;
        try {
            list = roleManager.getRoles("");
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"Role", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                Role role = (Role)list.next();
                JSRole _tempRole = (JSRole)this.getObjectBehindPrinicpal(this.roleMap, (BasePrincipal)role.getPrincipal());
                if (_tempRole != null) continue;
                _tempRole = this.createJSRole(role);
                this.roleMap.put(_tempRole.getName(), _tempRole);
                ((JSSeedData)this.getSnapshot()).getRoles().add(_tempRole);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Role", e.getMessage()}));
            }
        }
    }

    private JSGroup createJSGroup(Group group) {
        JSGroup _group = new JSGroup();
        _group.setName(group.getPrincipal().getName());
        return _group;
    }

    private void exportGroups() throws SerializerException {
        GroupManager groupManager = (GroupManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.GroupManager");
        if (groupManager == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.GroupManager"));
        }
        Iterator list = null;
        try {
            list = groupManager.getGroups("");
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"Group", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                Group group = (Group)list.next();
                JSGroup _tempGroup = (JSGroup)this.getObjectBehindPrinicpal(this.groupMap, (BasePrincipal)group.getPrincipal());
                if (_tempGroup != null) continue;
                _tempGroup = this.createJSGroup(group);
                this.groupMap.put(_tempGroup.getName(), _tempGroup);
                ((JSSeedData)this.getSnapshot()).getGroups().add(_tempGroup);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Group", e.getMessage()}));
            }
        }
    }

    private void addJSUserCredentials(boolean isPublic, JSUser newUser, Object credential) {
        if (credential == null) {
            return;
        }
        if (credential instanceof PasswordCredential) {
            PasswordCredential pw = (PasswordCredential)credential;
            newUser.setUserCredential(pw.getUserName(), pw.getPassword(), pw.getExpirationDate(), pw.isEnabled(), pw.isExpired(), pw.isUpdateRequired());
            return;
        }
        if (isPublic) {
            newUser.addPublicCredential(credential);
        } else {
            newUser.addPrivateCredential(credential);
        }
    }

    private JSUser createJSUser(User user) {
        Object credential;
        JSUser _newUser = new JSUser();
        Subject subject = user.getSubject();
        Set<Principal> principals = subject.getPrincipals();
        Iterator<Object> list = principals.iterator();
        while (list.hasNext()) {
            BasePrincipal principal = (BasePrincipal)list.next();
            String path = principal.getFullPath();
            if (path.startsWith("/role/")) {
                JSRole _tempRole = (JSRole)this.getObjectBehindPath(this.roleMap, principal.getName());
                if (_tempRole == null) continue;
                _newUser.addRole(_tempRole);
                continue;
            }
            if (path.startsWith("/group/")) {
                JSGroup _tempGroup = (JSGroup)this.getObjectBehindPath(this.groupMap, principal.getName());
                if (_tempGroup == null) continue;
                _newUser.addGroup(_tempGroup);
                continue;
            }
            if (!path.startsWith("/user/")) continue;
            _newUser.setPrincipal((Principal)principal);
        }
        Set<Object> credentials = subject.getPublicCredentials();
        list = credentials.iterator();
        while (list.hasNext()) {
            credential = list.next();
            this.addJSUserCredentials(true, _newUser, credential);
        }
        credentials = subject.getPrivateCredentials();
        list = credentials.iterator();
        while (list.hasNext()) {
            credential = list.next();
            this.addJSUserCredentials(false, _newUser, credential);
        }
        Preferences preferences = user.getPreferences();
        _newUser.setPreferences(preferences);
        preferences = user.getUserAttributes();
        _newUser.setUserInfo(preferences);
        return _newUser;
    }

    private void exportUsers() throws SerializerException {
        ((JSSeedData)this.getSnapshot()).setEncryption(this.getEncryptionString());
        this.exportRoles();
        this.exportGroups();
        UserManager userManager = (UserManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.UserManager");
        if (userManager == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.UserManager"));
        }
        Iterator list = null;
        try {
            list = userManager.getUsers("");
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"User", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                User _user = (User)list.next();
                JSUser _tempUser = this.createJSUser(_user);
                this.userMap.put(_tempUser.getName(), _tempUser);
                ((JSSeedData)this.getSnapshot()).getUsers().add(_tempUser);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"User", e.getMessage()}));
            }
        }
    }

    private void exportCapabilites(Capabilities caps) throws SerializerException {
        Iterator list = caps.getCapabilities();
        while (list.hasNext()) {
            try {
                Capability _cp = (Capability)list.next();
                JSCapability _jsC = new JSCapability();
                _jsC.setName(_cp.getName());
                this.capabilityMap.put(_jsC.getName(), _jsC);
                this.capabilityMapInt.put(new Integer(_cp.getCapabilityId()), _jsC);
                ((JSSeedData)this.getSnapshot()).getCapabilities().add(_jsC);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"C", e.getMessage()}));
            }
        }
    }

    private void exportMimeTypes(Capabilities caps) throws SerializerException {
        Iterator list = caps.getMimeTypes();
        while (list.hasNext()) {
            try {
                MimeType _mt = (MimeType)list.next();
                JSMimeType _jsM = new JSMimeType();
                _jsM.setName(_mt.getName());
                this.mimeMap.put(_jsM.getName(), _jsM);
                this.mimeMapInt.put(new Integer(_mt.getMimetypeId()), _jsM);
                ((JSSeedData)this.getSnapshot()).getMimeTypes().add(_jsM);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"MimeType", e.getMessage()}));
            }
        }
    }

    private JSClient createJSClient(Client c) throws SerializerException {
        try {
            JSMimeType _mt;
            JSClient jsC = new JSClient(c);
            Iterator _itM = c.getMimetypes().iterator();
            while (_itM.hasNext()) {
                MimeType _m = (MimeType)_itM.next();
                _mt = (JSMimeType)this.mimeMap.get(_m.getName());
                if (_mt == null) continue;
                jsC.getMimeTypes().add(_mt);
            }
            Integer id = new Integer(c.getPreferredMimeTypeId());
            _mt = (JSMimeType)this.mimeMapInt.get(id);
            if (_mt != null) {
                jsC.setPreferredMimeTypeID(_mt.getName());
            } else {
                jsC.setPreferredMimeTypeID("???");
            }
            Iterator _itC = c.getCapabilities().iterator();
            while (_itC.hasNext()) {
                Capability _c = (Capability)_itC.next();
                JSCapability _ct = (JSCapability)this.capabilityMap.get(_c.getName());
                if (_ct == null) continue;
                jsC.getCapabilities().add(_ct);
            }
            return jsC;
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Client", e.getMessage()}));
        }
    }

    private void exportClients(Capabilities caps) throws SerializerException {
        this.exportMimeTypes(caps);
        this.exportCapabilites(caps);
        Iterator _it = caps.getClients();
        while (_it.hasNext()) {
            Client c = (Client)_it.next();
            JSClient jsC = this.createJSClient(c);
            if (jsC == null) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Client", "createClient returned NULL"}));
            }
            this.clientMap.put(jsC.getName(), jsC);
            ((JSSeedData)this.getSnapshot()).getClients().add(jsC);
        }
    }

    private void exportMediaTypes(Capabilities caps) throws SerializerException {
        Iterator list = caps.getMediaTypes();
        while (list.hasNext()) {
            try {
                MediaType _mt = (MediaType)list.next();
                JSMediaType _jsM = new JSMediaType(_mt);
                Iterator _itM = _mt.getMimetypes().iterator();
                while (_itM.hasNext()) {
                    MimeType _m = (MimeType)_itM.next();
                    JSMimeType _mttype = (JSMimeType)this.mimeMap.get(_m.getName());
                    if (_mttype == null) continue;
                    _jsM.getMimeTypes().add(_mttype);
                }
                Iterator _itC = _mt.getCapabilities().iterator();
                while (_itC.hasNext()) {
                    Capability _c = (Capability)_itC.next();
                    JSCapability _ct = (JSCapability)this.capabilityMap.get(_c.getName());
                    if (_ct == null) continue;
                    _jsM.getCapabilities().add(_ct);
                }
                this.mediaMap.put(_jsM.getName(), _jsM);
                ((JSSeedData)this.getSnapshot()).getMediaTypes().add(_jsM);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"MediaType", e.getMessage()}));
            }
        }
    }

    private void exportCapabilitiesInfrastructure() throws SerializerException {
        Capabilities caps = (Capabilities)this.getCM().getComponent((Object)"org.apache.jetspeed.capabilities.Capabilities");
        if (caps == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.capabilities.Capabilities"));
        }
        this.exportClients(caps);
        this.exportMediaTypes(caps);
    }

    private void getPermissions() throws SerializerException {
        Object o = null;
        PermissionManager pm = (PermissionManager)this.getCM().getComponent((Object)"org.apache.jetspeed.security.PermissionManager");
        if (pm == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.security.PermissionManager"));
        }
        Iterator list = null;
        try {
            list = pm.getPermissions().iterator();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"Permissions", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                JSPermission _js = new JSPermission();
                InternalPermission p = (InternalPermission)list.next();
                _js.setResource(p.getName());
                _js.setActions(p.getActions());
                _js.setId(p.getPermissionId());
                _js.setType(_js.getTypeForClass(p.getClassname()));
                Iterator list2 = p.getPrincipals().iterator();
                while (list2.hasNext()) {
                    JSUser _tempUser;
                    o = list2.next();
                    InternalPrincipal principal = o;
                    String path = principal.getFullPath();
                    if (path.startsWith("/role/")) {
                        JSRole _tempRole = (JSRole)this.getObjectBehindPath(this.roleMap, this.removeFromString(path, "/role/"));
                        if (_tempRole == null) continue;
                        _js.addRole(_tempRole);
                        continue;
                    }
                    if (path.startsWith("/group/")) {
                        JSGroup _tempGroup = (JSGroup)this.getObjectBehindPath(this.groupMap, this.removeFromString(path, "/group/"));
                        if (_tempGroup == null) continue;
                        _js.addGroup(_tempGroup);
                        continue;
                    }
                    if (!path.startsWith("/user/") || (_tempUser = (JSUser)this.getObjectBehindPath(this.userMap, this.removeFromString(path, "/user/"))) == null) continue;
                    _js.addUser(_tempUser);
                }
                this.permissionMap.put(_js.getType(), _js);
                ((JSSeedData)this.getSnapshot()).getPermissions().add(_js);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Permissions", e.getMessage()}));
            }
        }
    }

    private JSProfilingRule createProfilingRule(ProfilingRule p, boolean standard) {
        JSProfilingRule rule = new JSProfilingRule();
        rule.setStandardRule(standard);
        rule.setDescription(p.getTitle());
        rule.setId(p.getId());
        Collection col = p.getRuleCriteria();
        Iterator keys = col.iterator();
        while (keys.hasNext()) {
            RuleCriterion rc = (RuleCriterion)keys.next();
            rule.getCriterions().add(new JSRuleCriterion(rc));
        }
        return rule;
    }

    private void getProfilingRules() throws SerializerException {
        Profiler pm = (Profiler)this.getCM().getComponent((Object)"org.apache.jetspeed.profiler.Profiler");
        if (pm == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.profiler.Profiler"));
        }
        Class<?> standardRuleClass = null;
        try {
            ProfilingRule tempStandardRule = pm.createProfilingRule(true);
            standardRuleClass = tempStandardRule.getClass();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"Standard Rule", e.getMessage()}));
        }
        Iterator list = null;
        try {
            list = pm.getRules().iterator();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"ProfilingRules", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                ProfilingRule p = (ProfilingRule)list.next();
                if (this.rulesMap.containsKey(p.getId())) continue;
                JSProfilingRule rule = this.createProfilingRule(p, standardRuleClass == p.getClass());
                this.rulesMap.put(rule.getId(), rule);
                ((JSSeedData)this.getSnapshot()).getRules().add(rule);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"ProfilingRules", e.getMessage()}));
            }
        }
        ProfilingRule defaultRule = pm.getDefaultRule();
        if (defaultRule != null) {
            ((JSSeedData)this.getSnapshot()).setDefaultRule(defaultRule.getId());
        }
        Iterator _itUsers = this.userMap.values().iterator();
        while (_itUsers.hasNext()) {
            JSUser _user = (JSUser)_itUsers.next();
            Principal principal = _user.getPrincipal();
            if (principal == null) continue;
            Collection col = pm.getRulesForPrincipal(principal);
            Iterator _itCol = col.iterator();
            while (_itCol.hasNext()) {
                PrincipalRule p1 = (PrincipalRule)_itCol.next();
                JSPrincipalRule pr = new JSPrincipalRule(p1.getLocatorName(), p1.getProfilingRule().getId());
                _user.getRules().add(pr);
            }
        }
    }

    protected int compareCurrentSecurityProvider(JSSeedData file) {
        String _fileEncryption = file.getEncryption();
        if (_fileEncryption == null || _fileEncryption.length() == 0) {
            return 0;
        }
        if (_fileEncryption.equals(this.getEncryptionString())) {
            return 1;
        }
        return 0;
    }

    private String getEncryptionString() {
        PasswordCredentialProvider provider = (PasswordCredentialProvider)this.getCM().getComponent((Object)"org.apache.jetspeed.security.spi.PasswordCredentialProvider");
        if (provider == null) {
            System.err.println("Error!!! PasswordCredentialProvider not available");
            return ENCODING_STRING;
        }
        try {
            PasswordCredential credential = provider.create(JETSPEED, ENCODING_STRING);
            if (credential != null && credential.getPassword() != null) {
                return new String(credential.getPassword());
            }
            return ENCODING_STRING;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ENCODING_STRING;
        }
    }

    private JSSSOSite createSSOSite(SSOSite s) {
        JSSSOSite site = new JSSSOSite();
        site.setName(s.getName());
        site.setSiteURL(s.getSiteURL());
        site.setAllowUserSet(s.isAllowUserSet());
        site.setCertificateRequired(s.isCertificateRequired());
        site.setChallengeResponseAuthentication(s.isChallengeResponseAuthentication());
        site.setRealm(s.getRealm());
        site.setFormAuthentication(s.isFormAuthentication());
        site.setFormUserField(s.getFormUserField());
        site.setFormPwdField(s.getFormPwdField());
        Iterator rupIter = s.getRemotePrincipals().iterator();
        while (rupIter.hasNext()) {
            InternalUserPrincipal rup = (InternalUserPrincipal)rupIter.next();
            InternalCredential rupCredential = null;
            Collection rupCredentials = rup.getCredentials();
            if (rupCredentials != null) {
                rupCredential = (InternalCredential)rupCredentials.iterator().next();
            }
            if (rupCredential == null) continue;
            String rupPath = rup.getFullPath();
            String rupPrincipalType = null;
            String rupPrincipalName = null;
            String rupName = null;
            String[] names = null;
            if (rupPath.startsWith("/sso/") && rupPath.indexOf("/user/") != -1) {
                rupPrincipalType = "user";
                names = rupPath.replaceAll("^/sso/[0-9]+/user/", "").split("/");
            } else if (rupPath.startsWith("/sso/") && rupPath.indexOf("/group/") != -1) {
                rupPrincipalType = "group";
                names = rupPath.replaceAll("^/sso/[0-9]+/group/", "").split("/");
            }
            if (names != null && names.length == 2) {
                rupPrincipalName = names[0];
                rupName = names[1];
            }
            if (rupPrincipalType == null || rupPrincipalName == null || rupPrincipalName.length() <= 0 || rupName == null || rupName.length() <= 0) continue;
            JSSSOSiteRemoteUser siteRemoteUser = new JSSSOSiteRemoteUser();
            siteRemoteUser.setPrincipalName(rupPrincipalName);
            siteRemoteUser.setPrincipalType(rupPrincipalType);
            siteRemoteUser.setUserCredential(rupName, rupCredential.getValue().toCharArray());
            site.addRemoteUser(siteRemoteUser);
        }
        return site;
    }

    private void getSSOSites() throws SerializerException {
        SSOProvider ssoProvider = (SSOProvider)this.getCM().getComponent((Object)"org.apache.jetspeed.sso.SSOProvider");
        if (ssoProvider == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.sso.SSOProvider"));
        }
        Iterator list = null;
        try {
            list = ssoProvider.getSites("");
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"SSOSites", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                SSOSite s = (SSOSite)list.next();
                if (this.ssoSitesMap.containsKey(s.getSiteURL())) continue;
                JSSSOSite site = this.createSSOSite(s);
                this.ssoSitesMap.put(site.getSiteURL(), site);
                ((JSSeedData)this.getSnapshot()).getSSOSites().add(site);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"SSOSites", e.getMessage()}));
            }
        }
    }

    protected RuleCriterion recreateRuleCriterion(Profiler profiler, JSRuleCriterion jsr, ProfilingRule rule) throws SerializerException, ClassNotFoundException {
        try {
            RuleCriterion c = profiler.createRuleCriterion();
            if (c == null) {
                throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.profiler.rules.RuleCriterion", (Object)"returned null"));
            }
            c.setFallbackOrder(jsr.getFallBackOrder());
            c.setFallbackType(jsr.getFallBackType());
            c.setName(jsr.getName());
            c.setType(jsr.getType());
            c.setValue(jsr.getValue());
            c.setRuleId(rule.getId());
            return c;
        }
        catch (Exception e) {
            SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.profiler.rules.RuleCriterion", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    protected ProfilingRule recreateRule(Profiler profiler, ProfilingRule existingRule, JSProfilingRule jsp) throws SerializerException, ClassNotFoundException, ProfilerException {
        ProfilingRule rule = null;
        boolean existing = false;
        if (existingRule == null) {
            rule = profiler.getRule(jsp.getId());
            rule = jsp.isStandardRule() ? profiler.createProfilingRule(true) : profiler.createProfilingRule(false);
            rule.setId(jsp.getId());
        } else {
            rule = existingRule;
            existing = true;
        }
        rule.setTitle(jsp.getDescription());
        JSRuleCriterions col = jsp.getCriterions();
        Iterator _it = col.iterator();
        while (_it.hasNext()) {
            RuleCriterion c = this.recreateRuleCriterion(profiler, (JSRuleCriterion)_it.next(), rule);
            if (c == null) continue;
            Collection cHelp = rule.getRuleCriteria();
            if (existing && cHelp.contains(c)) {
                cHelp.remove(c);
            }
            cHelp.add(c);
        }
        return rule;
    }

    private void recreateProfilingRules() throws SerializerException {
        this.logMe("recreateProfilingRules - processing");
        Profiler pm = (Profiler)this.getCM().getComponent((Object)"org.apache.jetspeed.profiler.Profiler");
        if (pm == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.profiler.Profiler"));
        }
        JSProfilingRules rules = ((JSSeedData)this.getSnapshot()).getRules();
        if (rules != null && rules.size() > 0) {
            ProfilingRule defaultRule;
            Iterator _it = rules.iterator();
            while (_it.hasNext()) {
                JSProfilingRule _c = (JSProfilingRule)_it.next();
                try {
                    ProfilingRule rule = null;
                    rule = pm.getRule(_c.getId());
                    if (rule != null && !this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING)) continue;
                    rule = this.recreateRule(pm, rule, _c);
                    pm.storeProfilingRule(rule);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.Capabilities", (Object)e.getLocalizedMessage()));
                }
            }
            String defaultRuleID = ((JSSeedData)this.getSnapshot()).getDefaultRule();
            if (defaultRuleID != null && (defaultRule = pm.getRule(defaultRuleID)) != null) {
                pm.setDefaultRule(defaultRuleID);
            }
        } else {
            this.logMe("NO PROFILING RULES?????");
        }
        this.logMe("recreateProfilingRules - done");
    }

    private SSOSite recreateSSOSite(SSOProvider ssoProvider, JSSSOSite site, SSOSite s) throws SerializerException, SSOException {
        if (s != null) {
            ssoProvider.removeSite(s);
        }
        ssoProvider.addSite(site.getName(), site.getSiteURL());
        s = ssoProvider.getSite(site.getSiteURL());
        s.setAllowUserSet(site.isAllowUserSet());
        s.setCertificateRequired(site.isCertificateRequired());
        s.setChallengeResponseAuthentication(site.isChallengeResponseAuthentication());
        s.setRealm(site.getRealm());
        s.setFormAuthentication(site.isFormAuthentication());
        s.setFormUserField(site.getFormUserField());
        s.setFormPwdField(site.getFormPwdField());
        if (site.getRemoteUsers() != null) {
            Iterator ruIter = site.getRemoteUsers().iterator();
            while (ruIter.hasNext()) {
                JSSSOSiteRemoteUser rUser = (JSSSOSiteRemoteUser)ruIter.next();
                if (rUser.getPassword() == null) continue;
                String pName = rUser.getPrincipalName();
                String pFullPath = "/" + rUser.getPrincipalType() + "/" + pName;
                String rName = rUser.getName();
                String rPassword = new String(rUser.getPassword());
                ssoProvider.addCredentialsForSite(s, pFullPath, pName, rName, rPassword);
            }
        }
        return s;
    }

    private void recreateSSOSites() throws SerializerException {
        this.logMe("recreateSSOSites - processing");
        SSOProvider ssoProvider = (SSOProvider)this.getCM().getComponent((Object)"org.apache.jetspeed.sso.SSOProvider");
        if (ssoProvider == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.sso.SSOProvider"));
        }
        JSSSOSites sites = ((JSSeedData)this.getSnapshot()).getSSOSites();
        if (sites != null && sites.size() > 0) {
            Iterator sitesIter = sites.iterator();
            while (sitesIter.hasNext()) {
                JSSSOSite site = (JSSSOSite)sitesIter.next();
                try {
                    SSOSite s = ssoProvider.getSite(site.getSiteURL());
                    if (s != null && !this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING)) continue;
                    s = this.recreateSSOSite(ssoProvider, site, s);
                    ssoProvider.updateSite(s);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"SSOSite", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            this.logMe("NO SSO SITES?????");
        }
        this.logMe("recreateSSOSites - done");
    }
}

