/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.components.SpringComponentManager;
import org.apache.jetspeed.serializer.JetspeedSerializer;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSSnapshot;

public abstract class JetspeedSerializerBase {
    protected static final Log log = LogFactory.getLog((Class)JetspeedSerializer.class);
    private ComponentManager cm = null;
    private Object sem = new Object();
    int refCouter = 0;
    private JSSnapshot snapshot;
    private HashMap processSettings = new HashMap();
    private boolean initialized = false;
    private String currentIndent = null;
    private static String ENCODING_STRING = "JETSPEED-SERIALIZER-ENCODING";
    private static String JETSPEED = "JETSPEED";

    protected final ComponentManager getCM() {
        if (this.cm == null) {
            this.cm = Jetspeed.getComponentManager();
        }
        return this.cm;
    }

    public JetspeedSerializerBase() {
    }

    public JetspeedSerializerBase(ComponentManager cm) {
        this.setComponentManager(cm);
        this.initialized = true;
    }

    public JetspeedSerializerBase(String appRoot, String[] bootConfig, String[] appConfig) throws SerializerException {
        this.initializeComponentManager(appRoot, bootConfig, appConfig);
        this.initialized = true;
    }

    public final void initializeComponentManager(String appRoot, String[] bootConfig, String[] appConfig) throws SerializerException {
        if (this.initialized) {
            throw new SerializerException(SerializerException.COMPONENT_MANAGER_EXISTS.create((Object)""));
        }
        SpringComponentManager cm = new SpringComponentManager(bootConfig, appConfig, appRoot);
        cm.start();
        PropertiesConfiguration properties = new PropertiesConfiguration();
        properties.setProperty("applicationRoot", (Object)appRoot);
        this.setComponentManager((ComponentManager)cm);
    }

    public final void setComponentManager(ComponentManager cm) {
        this.cm = cm;
    }

    public final void closeUp() {
        if (this.cm != null) {
            this.cm.stop();
        }
        this.cm = null;
    }

    public final void setDefaultIndent(String indent) {
        this.currentIndent = indent;
    }

    public final String getDefaultIndent() {
        return this.currentIndent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importData(String importFileName, Map settings) throws SerializerException {
        if (this.cm == null) {
            this.cm = Jetspeed.getComponentManager();
        }
        XMLBinding binding = new XMLBinding();
        this.setupAliases(binding);
        this.checkSettings(settings);
        this.setSnapshot(this.readFile(importFileName, binding));
        if (this.getSnapshot() == null) {
            throw new SerializerException(SerializerException.FILE_PROCESSING_ERROR.create((Object[])new String[]{importFileName, "Snapshot is NULL"}));
        }
        if (!this.getSnapshot().checkVersion()) {
            throw new SerializerException(SerializerException.INCOMPETIBLE_VERSION.create((Object[])new String[]{importFileName, String.valueOf(this.getSnapshot().getSoftwareVersion()), String.valueOf(this.getSnapshot().getSavedSubversion())}));
        }
        Object object = this.sem;
        synchronized (object) {
            this.logMe("*********Reading data*********");
            this.processImport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportData(String name, String exportFileName, Map settings) throws SerializerException {
        XMLBinding binding = new XMLBinding();
        this.setupAliases(binding);
        this.checkSettings(settings);
        if (this.cm == null) {
            this.cm = Jetspeed.getComponentManager();
        }
        Object object = this.sem;
        synchronized (object) {
            this.processExport(name, binding);
            XMLObjectWriter writer = this.openWriter(exportFileName);
            writer.setBinding(binding);
            if (this.getDefaultIndent() != null) {
                writer.setIndentation(this.getDefaultIndent());
            }
            try {
                this.logMe("*********Writing data*********");
                writer.write((Object)this.getSnapshot(), this.getSerializerDataTag(), this.getSerializerDataClass());
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.FILE_PROCESSING_ERROR.create((Object[])new String[]{exportFileName, e.getMessage()}));
            }
            finally {
                try {
                    this.logMe("*********closing up********");
                    writer.close();
                }
                catch (Exception e) {
                    this.logMe("Error in closing writer " + e.getMessage());
                }
            }
        }
    }

    protected final void doBackupOfCurrent(String importFileName, Map currentSettings) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JSSnapshot readFile(String importFileName, XMLBinding binding) throws SerializerException {
        XMLObjectReader reader = null;
        JSSnapshot snap = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(importFileName));
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.FILE_READER_ERROR.create((Object[])new String[]{importFileName, e.getMessage()}));
        }
        try {
            if (binding != null) {
                reader.setBinding(binding);
            }
            snap = (JSSnapshot)reader.read(this.getSerializerDataTag(), this.getSerializerDataClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            new SerializerException(SerializerException.FILE_PROCESSING_ERROR.create((Object[])new String[]{importFileName, e.getMessage()}));
        }
        finally {
            try {
                this.logMe("*********closing up reader ********");
                reader.close();
            }
            catch (Exception e1) {
                this.logMe("Error in closing reader " + e1.getMessage());
                return null;
            }
        }
        return snap;
    }

    protected final XMLObjectWriter openWriter(String filename) throws SerializerException {
        File f;
        try {
            f = new File(filename);
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.FILE_PROCESSING_ERROR.create((Object[])new String[]{filename, e.getMessage()}));
        }
        boolean exists = f.exists();
        if (exists) {
            if (!this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING)) {
                throw new SerializerException(SerializerException.FILE_ALREADY_EXISTS.create((Object)filename));
            }
            if (this.getSetting(JetspeedSerializer.KEY_BACKUP_BEFORE_PROCESS)) {
                String backName = this.createUniqueBackupFilename(f.getName());
                if (backName == null) {
                    throw new SerializerException(SerializerException.FILE_BACKUP_FAILED.create((Object)filename));
                }
                File ftemp = new File(backName);
                f.renameTo(ftemp);
            }
        }
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(filename));
            return writer;
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.FILE_WRITER_ERROR.create((Object[])new String[]{filename, e.getMessage()}));
        }
    }

    public final boolean getSetting(String key) {
        Object o = this.processSettings.get(key);
        if (o == null || !(o instanceof Boolean)) {
            return false;
        }
        return (Boolean)o;
    }

    protected final void setSetting(String key, boolean value) {
        this.processSettings.put(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected final void checkSettings(Map settings) {
        this.resetSettings();
        if (settings == null || settings.size() == 0) {
            return;
        }
        Iterator _it = settings.keySet().iterator();
        while (_it.hasNext()) {
            try {
                String key = (String)_it.next();
                Object o = settings.get(key);
                if (o == null || !(o instanceof Boolean)) continue;
                this.setSetting(key, (Boolean)o);
            }
            catch (Exception e) {
                log.error((Object)"checkSettings", (Throwable)e);
            }
        }
    }

    protected void getSnapshotData() {
        this.logMe("date created : " + this.getSnapshot().getDateCreated());
        this.logMe("software Version : " + this.getSnapshot().getSavedVersion());
        this.logMe("software SUbVersion : " + this.getSnapshot().getSavedSubversion());
    }

    protected void setSnapshotData() {
        java.util.Date d1 = new java.util.Date();
        Date d = new Date(d1.getTime());
        this.getSnapshot().setDateCreated(d.toString());
        this.getSnapshot().setSavedVersion(this.getSnapshot().getSoftwareVersion());
        this.getSnapshot().setSavedSubversion(this.getSnapshot().getSoftwareSubVersion());
    }

    protected final Object getObjectBehindPath(Map map, String _fullPath) {
        return map.get(_fullPath);
    }

    protected final String removeFromString(String base, String excess) {
        return base.replaceFirst(excess, "").trim();
    }

    protected final void logMe(String text) {
        if (log.isDebugEnabled()) {
            log.debug((Object)text);
        }
    }

    protected final String createUniqueBackupFilename(String name) {
        String newName = name + ".bak";
        File f = new File(newName);
        if (!f.exists()) {
            return newName;
        }
        for (int counter = 0; counter < 100; ++counter) {
            String newName1 = newName + counter;
            if (new File(newName1).exists()) continue;
            return newName1;
        }
        return null;
    }

    protected final ArrayList getTokens(String _line) {
        if (_line == null || _line.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(_line, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    protected final String recreatePassword(char[] savedPassword) {
        if (savedPassword == null) {
            return null;
        }
        return new String(savedPassword);
    }

    protected abstract void resetSettings();

    protected abstract void processExport(String var1, XMLBinding var2) throws SerializerException;

    protected abstract void processImport() throws SerializerException;

    protected abstract void setupAliases(XMLBinding var1);

    protected abstract Class getSerializerDataClass();

    protected abstract String getSerializerDataTag();

    public JSSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(JSSnapshot snapshot) {
        this.snapshot = snapshot;
    }
}

