/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityAttributeType;
import org.apache.jetspeed.security.SecurityAttributeTypes;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.SecurityAttributeImpl;
import org.apache.jetspeed.security.impl.SecurityAttributeTypeImpl;
import org.apache.jetspeed.security.impl.SecurityAttributeValue;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;

public class SecurityAttributesImpl
implements SecurityAttributes {
    JetspeedPrincipal jp;
    private Collection avColl;
    private boolean readOnly;
    private boolean extendable;
    private boolean persistent;
    private HashMap<String, SecurityAttributeImpl> saMap = new HashMap();

    public SecurityAttributesImpl(JetspeedPrincipal jp) {
        this.jp = jp;
        if (!jp.isTransient()) {
            throw new IllegalArgumentException("Provided JetspeedPrincipal is not transient");
        }
        this.avColl = new ArrayList();
        this.persistent = false;
        this.readOnly = false;
        this.extendable = false;
    }

    public SecurityAttributesImpl(JetspeedPrincipal jp, Collection avColl, boolean readOnly, boolean extendable) {
        this.jp = jp;
        this.avColl = avColl;
        this.persistent = true;
        this.readOnly = jp.getType().getAttributeTypes().isReadOnly() ? true : readOnly;
        this.extendable = jp.getType().getAttributeTypes().isExtendable() ? true : extendable;
        Map stMap = jp.getType().getAttributeTypes().getAttributeTypeMap();
        for (Object avObj : avColl) {
            SecurityAttributeValue av = (SecurityAttributeValue)avObj;
            SecurityAttributeType sat = (SecurityAttributeType)stMap.get(av.getName());
            this.saMap.put(av.getName(), new SecurityAttributeImpl((SecurityAttributeType)(sat != null ? sat : new SecurityAttributeTypeImpl(av.getName())), av, true));
        }
    }

    public JetspeedPrincipal getPrincipal() {
        return this.jp;
    }

    public int size() {
        return this.saMap.size();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isExtendable() {
        return this.extendable;
    }

    public SecurityAttributeTypes getSecurityAttributeTypes() {
        return this.jp.getType().getAttributeTypes();
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(new HashSet<String>(this.saMap.keySet()));
    }

    public Set<String> getAttributeNames(String category) {
        HashSet<String> set = new HashSet<String>(this.saMap.size());
        for (SecurityAttribute securityAttribute : this.saMap.values()) {
            if (!securityAttribute.getCategory().equals(category)) continue;
            set.add(securityAttribute.getName());
        }
        return Collections.unmodifiableSet(set);
    }

    public boolean isDefinedAttribute(String name) {
        return this.jp.getType().getAttributeTypes().getAttributeTypeMap().containsKey(name);
    }

    public Map<String, SecurityAttribute> getAttributeMap() {
        return Collections.unmodifiableMap(new HashMap<String, SecurityAttributeImpl>(this.saMap));
    }

    public Map<String, SecurityAttribute> getAttributeMap(String category) {
        HashMap<String, SecurityAttribute> map = new HashMap<String, SecurityAttribute>(this.saMap.size());
        for (SecurityAttribute securityAttribute : this.saMap.values()) {
            if (!securityAttribute.getCategory().equals(category)) continue;
            map.put(securityAttribute.getName(), securityAttribute);
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, SecurityAttribute> getInfoAttributeMap() {
        return this.getAttributeMap("info");
    }

    public Map<String, String> getInfoMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.saMap.size());
        for (SecurityAttribute securityAttribute : this.saMap.values()) {
            if (!securityAttribute.getCategory().equals("info")) continue;
            map.put(securityAttribute.getName(), securityAttribute.getStringValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public SecurityAttribute getAttribute(String name) {
        return this.saMap.get(name);
    }

    public SecurityAttribute getAttribute(String name, boolean create) throws SecurityException {
        SecurityAttributeImpl sa = this.saMap.get(name);
        if (sa != null) {
            return sa;
        }
        if (!create) {
            return null;
        }
        if (this.isReadOnly() && !this.isSynchronizing()) {
            throw new SecurityException(SecurityException.ATTRIBUTES_ARE_READ_ONLY.createScoped(this.getPrincipal().getType().getName()));
        }
        SecurityAttributeType sat = (SecurityAttributeType)this.getSecurityAttributeTypes().getAttributeTypeMap().get(name);
        if (sat == null) {
            if (!this.isExtendable() && !this.isSynchronizing()) {
                throw new SecurityException(SecurityException.ATTRIBUTES_NOT_EXTENDABLE.createScoped(this.getPrincipal().getType().getName()));
            }
            SecurityAttributeValue value = new SecurityAttributeValue(name);
            this.avColl.add(value);
            sa = new SecurityAttributeImpl(new SecurityAttributeTypeImpl(name), value, this.persistent);
        } else {
            SecurityAttributeValue value = new SecurityAttributeValue(name);
            this.avColl.add(value);
            sa = new SecurityAttributeImpl(sat, value, this.persistent);
        }
        this.saMap.put(name, sa);
        return sa;
    }

    public void removeAttribute(String name) throws SecurityException {
        if (this.isReadOnly() && !this.isSynchronizing()) {
            throw new SecurityException(SecurityException.ATTRIBUTES_ARE_READ_ONLY.createScoped(this.getPrincipal().getType().getName()));
        }
        SecurityAttributeImpl sa = this.saMap.get(name);
        if (sa != null) {
            if (sa.isReadOnly() && !this.isSynchronizing()) {
                throw new SecurityException(SecurityException.ATTRIBUTE_IS_READ_ONLY.createScoped(this.getPrincipal().getType().getName(), (Object)name));
            }
            if (sa.isRequired() && !this.isSynchronizing()) {
                throw new SecurityException(SecurityException.ATTRIBUTE_IS_REQUIRED.createScoped(this.getPrincipal().getType().getName(), (Object)name));
            }
            this.saMap.remove(name);
            this.avColl.remove(sa.getSecurityAttributeValue());
        }
    }

    protected boolean isSynchronizing() {
        return SynchronizationStateAccess.isSynchronizing();
    }
}

