/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationType;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAccessManager;
import org.apache.jetspeed.security.spi.UserSubjectPrincipalsProvider;
import org.apache.jetspeed.security.spi.UserSubjectPrincipalsResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSubjectPrincipalsResolverImpl
implements UserSubjectPrincipalsResolver {
    private UserSubjectPrincipalsProvider spp;
    private JetspeedPrincipalType principalType;
    private JetspeedPrincipalAssociationType uat;
    private List<JetspeedPrincipalAssociationType> iatList;
    private boolean fromUser;
    private boolean initialized;
    private JetspeedPrincipalAccessManager accessManager;

    private static List<Object> wrapInList(JetspeedPrincipalAssociationType type) {
        if (type != null) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(type);
            return list;
        }
        return Collections.emptyList();
    }

    public UserSubjectPrincipalsResolverImpl(UserSubjectPrincipalsProvider spp, JetspeedPrincipalType principalType, JetspeedPrincipalAssociationType userAssociationType) {
        this(spp, principalType, userAssociationType, (JetspeedPrincipalAssociationType)null);
    }

    public UserSubjectPrincipalsResolverImpl(UserSubjectPrincipalsProvider spp, JetspeedPrincipalType principalType, JetspeedPrincipalAssociationType userAssociationType, JetspeedPrincipalAssociationType indirectAssociationType) {
        this(spp, principalType, userAssociationType, UserSubjectPrincipalsResolverImpl.wrapInList(indirectAssociationType));
    }

    public UserSubjectPrincipalsResolverImpl(UserSubjectPrincipalsProvider spp, JetspeedPrincipalType principalType, JetspeedPrincipalAssociationType userAssociationType, List<Object> indirectAssociationTypes) {
        if (!spp.getPrincipalType().getName().equals("user")) {
            throw new IllegalArgumentException("The provided SubjectPrincipalsProvider should be for the user principalType");
        }
        this.spp = spp;
        if (principalType.getName().equals("user")) {
            throw new IllegalArgumentException("This resolver principalType cannot be that of the user principalType");
        }
        this.principalType = principalType;
        if (userAssociationType.getFromPrincipalType().getName().equals("user")) {
            if (userAssociationType.getToPrincipalType() != principalType) {
                throw new IllegalArgumentException("Provided userAssociationType doesn't target this resolver principalType");
            }
            this.fromUser = true;
        } else if (userAssociationType.getToPrincipalType().getName().equals("user")) {
            if (userAssociationType.getFromPrincipalType() != principalType) {
                throw new IllegalArgumentException("Provided userAssociationType doesn't target this resolver principalType");
            }
            this.fromUser = false;
        } else {
            throw new IllegalArgumentException("Provided userAssociationType is not for a user association");
        }
        this.uat = userAssociationType;
        if (indirectAssociationTypes != null && !indirectAssociationTypes.isEmpty()) {
            this.iatList = new ArrayList<JetspeedPrincipalAssociationType>(indirectAssociationTypes.size());
            for (Object o : indirectAssociationTypes) {
                JetspeedPrincipalAssociationType iat = (JetspeedPrincipalAssociationType)o;
                if (iat.getFromPrincipalType() != principalType && iat.getToPrincipalType() != principalType) {
                    throw new IllegalArgumentException("Provided indirectAssociationType " + iat.getAssociationName() + " should match this resolvers principalType");
                }
                this.iatList.add(iat);
            }
        }
        spp.addSubjectPrincipalsResolver(this);
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            this.accessManager = this.spp.getPrincipalAccessManager();
            this.initialized = true;
        }
    }

    @Override
    public JetspeedPrincipalType getPrincipalType() {
        return this.principalType;
    }

    protected void processFound(List<JetspeedPrincipal> found, User user, Set<Long> resolvedIds, Set<Principal> principals, Map<String, UserSubjectPrincipalsResolver> resolvers) {
        for (int i = found.size() - 1; i > -1; --i) {
            JetspeedPrincipal p = found.get(i);
            if (p.isEnabled() && resolvers.containsKey(p.getType().getName()) && resolvedIds.add(p.getId())) continue;
            found.remove(i);
        }
        for (JetspeedPrincipal p : found) {
            resolvers.get(p.getType().getName()).processPrincipal(p, user, resolvedIds, principals, resolvers);
        }
    }

    @Override
    public void resolve(User user, Set<Long> resolvedIds, Set<Principal> principals, Map<String, UserSubjectPrincipalsResolver> resolvers) {
        this.checkInitialized();
        if (user.getId() == null || !user.isEnabled()) {
            return;
        }
        List<JetspeedPrincipal> found = null;
        found = this.fromUser ? this.accessManager.getAssociatedFrom(user.getId(), this.uat.getFromPrincipalType(), this.uat.getToPrincipalType(), this.uat.getAssociationName()) : this.accessManager.getAssociatedTo(user.getId(), this.uat.getFromPrincipalType(), this.uat.getToPrincipalType(), this.uat.getAssociationName());
        this.processFound(found, user, resolvedIds, principals, resolvers);
    }

    @Override
    public void processPrincipal(JetspeedPrincipal principal, User user, Set<Long> resolvedIds, Set<Principal> principals, Map<String, UserSubjectPrincipalsResolver> resolvers) {
        this.checkInitialized();
        if (user.getId() == null || !user.isEnabled() || principal.getId() == null || !principal.isEnabled() || principal.getType() != this.principalType) {
            return;
        }
        principals.add((Principal)principal);
        if (this.iatList != null) {
            for (JetspeedPrincipalAssociationType iat : this.iatList) {
                List<JetspeedPrincipal> found = null;
                found = !iat.isMixedTypes() && !iat.isSingular() || !iat.getFromPrincipalType().getName().equals(this.getPrincipalType().getName()) ? this.accessManager.getAssociatedTo(principal.getId(), iat.getFromPrincipalType(), iat.getToPrincipalType(), iat.getAssociationName()) : this.accessManager.getAssociatedFrom(principal.getId(), iat.getFromPrincipalType(), iat.getToPrincipalType(), iat.getAssociationName());
                this.processFound(found, user, resolvedIds, principals, resolvers);
            }
        }
    }
}

