/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.spi.UserPasswordCredentialAccessManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialPolicyManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialStorageManager;

public class UserPasswordCredentialManagerImpl
implements UserPasswordCredentialManager {
    private UserPasswordCredentialStorageManager upcsm;
    private UserPasswordCredentialAccessManager upcam;
    private UserPasswordCredentialPolicyManager upcpm;

    public UserPasswordCredentialManagerImpl(UserPasswordCredentialStorageManager upcsm, UserPasswordCredentialAccessManager upcam) {
        this.upcsm = upcsm;
        this.upcam = upcam;
    }

    public UserPasswordCredentialManagerImpl(UserPasswordCredentialStorageManager upcsm, UserPasswordCredentialAccessManager upcam, UserPasswordCredentialPolicyManager upcpm) {
        this(upcsm, upcam);
        this.upcpm = upcpm;
    }

    public PasswordCredential getPasswordCredential(User user) throws SecurityException {
        PasswordCredential credential = this.upcsm.getPasswordCredential(user);
        if (!credential.isNew() && this.upcpm != null && this.upcpm.onLoad(credential, user.getName())) {
            this.upcsm.storePasswordCredential(credential);
        }
        return credential;
    }

    public void storePasswordCredential(PasswordCredential credential) throws SecurityException {
        if (this.upcpm != null) {
            this.upcpm.onStore(credential);
        }
        this.upcsm.storePasswordCredential(credential);
    }

    public PasswordCredential getAuthenticatedPasswordCredential(String userName, String password) throws SecurityException {
        PasswordCredential credential = this.upcam.getPasswordCredential(userName);
        if (credential == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
        }
        if (this.upcpm != null) {
            if (this.upcpm.onLoad(credential, userName)) {
                this.upcsm.storePasswordCredential(credential);
            }
            if (credential.isEnabled() && !credential.isExpired()) {
                if (this.upcpm.authenticate(credential, userName, password)) {
                    this.upcsm.storePasswordCredential(credential);
                }
                if (!credential.isEnabled() || credential.isExpired()) {
                    throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
                }
                if (credential.getAuthenticationFailures() != 0) {
                    throw new SecurityException(SecurityException.INVALID_PASSWORD);
                }
            }
        } else {
            if (password == null) {
                throw new SecurityException(SecurityException.PASSWORD_REQUIRED);
            }
            if (credential.getPassword() == null || !password.equals(new String(credential.getPassword()))) {
                throw new SecurityException(SecurityException.INVALID_PASSWORD);
            }
            if (!credential.isEnabled() || credential.isExpired()) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
            }
        }
        try {
            this.upcam.loadPasswordCredentialUser(credential);
        }
        catch (Exception e) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName), (Throwable)e);
        }
        if (credential.getUser() == null || !credential.getUser().isEnabled()) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
        }
        return credential;
    }
}

