/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.security.Principal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.Credential;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JetspeedPermission;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationType;
import org.apache.jetspeed.security.JetspeedPrincipalManager;
import org.apache.jetspeed.security.JetspeedPrincipalManagerProvider;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.SecurityDomain;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.SecurityDomainImpl;
import org.apache.jetspeed.security.spi.SecurityDomainAccessManager;
import org.apache.jetspeed.security.spi.SecurityDomainStorageManager;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;
import org.apache.jetspeed.serializer.AbstractJetspeedComponentSerializer;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSGroup;
import org.apache.jetspeed.serializer.objects.JSNVPElement;
import org.apache.jetspeed.serializer.objects.JSPermission;
import org.apache.jetspeed.serializer.objects.JSPermissions;
import org.apache.jetspeed.serializer.objects.JSPrincipal;
import org.apache.jetspeed.serializer.objects.JSPrincipalAssociation;
import org.apache.jetspeed.serializer.objects.JSRole;
import org.apache.jetspeed.serializer.objects.JSSecurityAttributes;
import org.apache.jetspeed.serializer.objects.JSSecurityDomain;
import org.apache.jetspeed.serializer.objects.JSSnapshot;
import org.apache.jetspeed.serializer.objects.JSUser;
import org.apache.jetspeed.serializer.objects.JSUserAttributes;
import org.apache.jetspeed.serializer.objects.JSUserGroups;
import org.apache.jetspeed.serializer.objects.JSUserRoles;
import org.apache.jetspeed.serializer.objects.JSUserUsers;
import org.slf4j.Logger;

public class JetspeedSecuritySerializer
extends AbstractJetspeedComponentSerializer {
    private static String ENCODING_STRING = "JETSPEED 2.2 - 2009";
    private static String JETSPEED = "JETSPEED";
    protected SecurityDomainStorageManager domainStorageManager;
    protected SecurityDomainAccessManager domainAccessManager;
    protected JetspeedPrincipalManagerProvider principalManagerProvider;
    protected GroupManager groupManager;
    protected RoleManager roleManager;
    protected UserManager userManager;
    protected CredentialPasswordEncoder cpe;
    protected PermissionManager pm;

    public JetspeedSecuritySerializer(JetspeedPrincipalManagerProvider principalManagerProvider, GroupManager groupManager, RoleManager roleManager, UserManager userManager, CredentialPasswordEncoder cpe, PermissionManager pm, SecurityDomainStorageManager sdsm, SecurityDomainAccessManager sdam) {
        this.principalManagerProvider = principalManagerProvider;
        this.groupManager = groupManager;
        this.roleManager = roleManager;
        this.userManager = userManager;
        this.cpe = cpe;
        this.pm = pm;
        this.domainAccessManager = sdam;
        this.domainStorageManager = sdsm;
    }

    protected void processExport(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        if (JetspeedSecuritySerializer.isSettingSet((Map)settings, (String)"process_users")) {
            try {
                log.info("collecting principals and principal associations");
                ExportRefs refs = new ExportRefs();
                this.exportJetspeedPrincipals(refs, snapshot, settings, log);
                this.exportJetspeedPrincipalAssociations(refs, snapshot, settings, log);
                if (JetspeedSecuritySerializer.isSettingSet((Map)settings, (String)"process_permissions")) {
                    log.info("collecting permissions");
                    this.exportPermissions(refs, snapshot, settings, log);
                }
            }
            catch (SecurityException se) {
                throw new SerializerException((Throwable)se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processImport(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        if (JetspeedSecuritySerializer.isSettingSet((Map)settings, (String)"process_users")) {
            log.info("creating principals and permissions");
            try {
                SynchronizationStateAccess.setSynchronizing(Boolean.TRUE);
                ImportRefs refs = new ImportRefs();
                this.recreateSecurityDomains(refs, snapshot, settings, log);
                this.recreateJetspeedPrincipals(refs, snapshot, settings, log);
                this.recreateJetspeedPrincipalAssociations(refs, snapshot, settings, log);
                if (JetspeedSecuritySerializer.isSettingSet((Map)settings, (String)"process_permissions")) {
                    log.info("creating permissions");
                    this.recreatePermissions(refs, snapshot, settings, log);
                }
            }
            finally {
                SynchronizationStateAccess.setSynchronizing(Boolean.FALSE);
            }
        }
    }

    protected void deleteData(Map settings, Logger log) throws SerializerException {
        if (JetspeedSecuritySerializer.isSettingSet((Map)settings, (String)"process_users")) {
            log.info("deleting users/roles/groups and permissions");
            try {
                SynchronizationStateAccess.setSynchronizing(Boolean.TRUE);
                for (JetspeedPermission permission : this.pm.getPermissions()) {
                    this.pm.removePermission(permission);
                }
                String anonymousUser = this.userManager.getAnonymousUser();
                for (JetspeedPrincipalType type : this.principalManagerProvider.getPrincipalTypeMap().values()) {
                    String typeName = type.getName();
                    boolean userType = "user".equals(typeName);
                    JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(type);
                    for (JetspeedPrincipal principal : principalManager.getPrincipals("")) {
                        if (userType && anonymousUser.equals(principal.getName())) continue;
                        principalManager.removePrincipal(principal);
                    }
                }
            }
            catch (Exception e) {
                throw new SerializerException((Throwable)e);
            }
            finally {
                SynchronizationStateAccess.setSynchronizing(Boolean.FALSE);
            }
        }
    }

    protected SecurityDomain checkDomainExistsOtherwiseCreate(String domainName) throws SecurityException {
        SecurityDomain domain = this.domainAccessManager.getDomainByName(domainName);
        if (domain == null) {
            SecurityDomainImpl newDomain = new SecurityDomainImpl();
            newDomain.setName(domainName);
            newDomain.setEnabled(true);
            newDomain.setRemote(false);
            this.domainStorageManager.addDomain(newDomain);
            domain = this.domainAccessManager.getDomainByName(domainName);
        }
        return domain;
    }

    private void recreateSecurityDomains(ImportRefs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        log.debug("recreateSecurityDomains");
        Long systemDomainId = null;
        Long defaultDomainId = null;
        try {
            defaultDomainId = this.checkDomainExistsOtherwiseCreate("[default]").getDomainId();
            systemDomainId = this.checkDomainExistsOtherwiseCreate("[system]").getDomainId();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"SecurityDomains", "Could not create default and / or system domains!\n" + e.getMessage()}), (Throwable)e);
        }
        if (snapshot.getSecurityDomains() != null && snapshot.getSecurityDomains().size() > 0) {
            JSSecurityDomain jsDomain;
            ArrayList sortedDomains = new ArrayList(snapshot.getSecurityDomains());
            Collections.sort(sortedDomains, new Comparator<JSSecurityDomain>(){

                @Override
                public int compare(JSSecurityDomain o1, JSSecurityDomain o2) {
                    boolean o2HasOwner;
                    boolean o1HasOwner = o1.getOwnerDomain() != null;
                    boolean bl = o2HasOwner = o2.getOwnerDomain() != null;
                    if (o1HasOwner == o2HasOwner) {
                        return 0;
                    }
                    if (o1HasOwner) {
                        return 1;
                    }
                    return -1;
                }
            });
            Iterator i$ = sortedDomains.iterator();
            while (i$.hasNext() && !(jsDomain = (JSSecurityDomain)i$.next()).getName().equals("[system]") && !jsDomain.getName().equals("[default]")) {
                if (jsDomain.getName().length() == 0) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"SecurityDomain", "Name of Security Domain must not be empty!"}));
                }
                Long ownerDomainId = null;
                if (jsDomain.getOwnerDomain() != null) {
                    if (jsDomain.getOwnerDomain().equals("[system]")) {
                        ownerDomainId = defaultDomainId;
                    } else if (jsDomain.getOwnerDomain().equals("[system]")) {
                        ownerDomainId = systemDomainId;
                    } else {
                        SecurityDomain ownerDomain = this.domainAccessManager.getDomainByName(jsDomain.getOwnerDomain());
                        if (ownerDomain == null) {
                            throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"SecurityDomain", "Could not find owner domain with name " + jsDomain.getOwnerDomain() + "for domain with name " + jsDomain.getName()}));
                        }
                        ownerDomainId = ownerDomain.getDomainId();
                    }
                } else if (jsDomain.isRemote()) {
                    ownerDomainId = defaultDomainId;
                }
                SecurityDomainImpl newDomain = new SecurityDomainImpl();
                newDomain.setName(jsDomain.getName());
                newDomain.setOwnerDomainId(ownerDomainId);
                newDomain.setRemote(jsDomain.isRemote());
                newDomain.setEnabled(jsDomain.isEnabled());
                try {
                    this.domainStorageManager.addDomain(newDomain);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"SecurityDomain", e.getMessage()}), (Throwable)e);
                }
            }
        }
    }

    private void recreateJetspeedPrincipals(ImportRefs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        String name;
        log.debug("recreateJetspeedPrincipals");
        log.debug("processing old groups");
        for (JSGroup jsGroup : snapshot.getOldGroups()) {
            name = jsGroup.getName();
            try {
                if (!this.groupManager.groupExists(name)) {
                    this.groupManager.addGroup(name);
                }
                Group group = this.groupManager.getGroup(name);
                refs.getPrincipalMap("group").put(name, (Principal)group);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"Group", e.getMessage()}), (Throwable)e);
            }
        }
        log.debug("recreateOldGroups - done");
        log.debug("processing old roles");
        for (JSRole jsRole : snapshot.getOldRoles()) {
            name = jsRole.getName();
            try {
                if (!this.roleManager.roleExists(name)) {
                    this.roleManager.addRole(name);
                }
                Role role = this.roleManager.getRole(name);
                refs.getPrincipalMap("role").put(name, (Principal)role);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"Role", e.getMessage()}));
            }
        }
        log.debug("recreateOldRoles - done");
        int passwordEncoding = this.compareCurrentSecurityProvider(snapshot);
        log.debug("processing old users");
        for (JSUser jsuser : snapshot.getOldUsers()) {
            try {
                JSSecurityAttributes jsNVP;
                JSUserAttributes attributes;
                Iterator _itTemp;
                User user = null;
                if (this.userManager.userExists(jsuser.getName())) {
                    user = this.userManager.getUser(jsuser.getName());
                }
                if (!JetspeedSecuritySerializer.isSettingSet((Map)settings, (String)"overwrite_existing") && user != null) continue;
                if (user == null) {
                    String pwdString = jsuser.getPwDataValue("password");
                    char[] pwdChars = pwdString != null ? pwdString.toCharArray() : null;
                    String password = this.recreatePassword(pwdChars);
                    log.debug("add User " + jsuser.getName() + " with password " + password);
                    user = this.userManager.addUser(jsuser.getName());
                    if (password != null && password.length() > 0) {
                        PasswordCredential pwc = this.userManager.getPasswordCredential(user);
                        pwc.setPassword(null, password);
                        pwc.setEncoded(passwordEncoding == 1);
                        this.userManager.storePasswordCredential(pwc);
                    }
                    log.debug("add User done ");
                }
                try {
                    PasswordCredential pwc = this.userManager.getPasswordCredential(user);
                    pwc.setEnabled(jsuser.getPwDataValueAsBoolean("enabled"));
                    pwc.setUpdateRequired(jsuser.getPwDataValueAsBoolean("requiresUpdate"));
                    Date d = jsuser.getPwExpirationDate();
                    if (d != null) {
                        pwc.setExpirationDate(d);
                    }
                    this.userManager.storePasswordCredential(pwc);
                }
                catch (Exception e) {
                    log.error("setting userinfo for " + jsuser.getName() + " failed because of " + e.getLocalizedMessage());
                }
                Subject subject = this.userManager.getSubject(user);
                List listTemp = jsuser.getPrivateCredentials();
                if (listTemp != null && listTemp.size() > 0) {
                    _itTemp = listTemp.iterator();
                    while (_itTemp.hasNext()) {
                        subject.getPrivateCredentials().add(_itTemp.next());
                    }
                }
                if ((listTemp = jsuser.getPublicCredentials()) != null && listTemp.size() > 0) {
                    _itTemp = listTemp.iterator();
                    while (_itTemp.hasNext()) {
                        subject.getPublicCredentials().add(_itTemp.next());
                    }
                }
                JSUserGroups jsUserGroups = jsuser.getGroupString();
                List listUserGroups = null;
                if (jsUserGroups != null) {
                    listUserGroups = JetspeedSecuritySerializer.getTokens((String)jsUserGroups.toString());
                }
                if (listUserGroups != null && listUserGroups.size() > 0) {
                    Iterator _itTemp2 = listUserGroups.iterator();
                    while (_itTemp2.hasNext()) {
                        this.groupManager.addUserToGroup(jsuser.getName(), (String)_itTemp2.next());
                    }
                }
                JSUserRoles jsUserRoles = jsuser.getRoleString();
                List listUserRoles = null;
                if (jsUserRoles != null) {
                    listUserRoles = JetspeedSecuritySerializer.getTokens((String)jsUserRoles.toString());
                }
                if (listUserRoles != null && listUserRoles.size() > 0) {
                    Iterator _itTemp3 = listUserRoles.iterator();
                    while (_itTemp3.hasNext()) {
                        this.roleManager.addRoleToUser(jsuser.getName(), (String)_itTemp3.next());
                    }
                }
                if ((attributes = jsuser.getUserInfo()) != null) {
                    SecurityAttributes userSecAttrs = user.getSecurityAttributes();
                    for (JSNVPElement element : attributes.getValues()) {
                        userSecAttrs.getAttribute(element.getKey(), true).setStringValue(element.getValue());
                    }
                }
                if ((jsNVP = jsuser.getSecurityAttributes()) != null && jsNVP.getValues() != null) {
                    SecurityAttributes userSecAttrs = user.getSecurityAttributes();
                    for (JSNVPElement element : jsNVP.getValues()) {
                        userSecAttrs.getAttribute(element.getKey(), true).setStringValue(element.getValue());
                    }
                }
                refs.getPrincipalMap("user").put(jsuser.getName(), (Principal)user);
                this.userManager.updateUser(user);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"User", e.getMessage()}));
            }
        }
        log.debug("recreateOldUsers - done");
        log.debug("processing jetspeed principals");
        JetspeedPrincipalManager principalManager = null;
        for (JSPrincipal jsPrincipal : snapshot.getPrincipals()) {
            String typeName = jsPrincipal.getType();
            if ("user".equals(typeName)) {
                this.recreateUserPrincipal(refs, snapshot, settings, log, jsPrincipal, passwordEncoding);
                continue;
            }
            String name2 = jsPrincipal.getName();
            try {
                JetspeedPrincipalType type = this.principalManagerProvider.getPrincipalType(typeName);
                principalManager = this.principalManagerProvider.getManager(type);
                JetspeedPrincipal principal = null;
                if (!principalManager.principalExists(name2)) {
                    principal = principalManager.newPrincipal(name2, jsPrincipal.isMapped());
                    JSSecurityAttributes jsSecAttrs = jsPrincipal.getSecurityAttributes();
                    if (jsSecAttrs != null) {
                        for (JSNVPElement elem : jsSecAttrs.getValues()) {
                            principal.getSecurityAttributes().getAttribute(elem.getKey(), true).setStringValue(elem.getValue());
                        }
                    }
                    principalManager.addPrincipal(principal, null);
                }
                principal = principalManager.getPrincipal(name2);
                refs.getPrincipalMap(typeName).put(name2, (Principal)principal);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{typeName, e.getMessage()}), (Throwable)e);
            }
        }
        log.debug("recreate jetspeed principals - done");
    }

    private void recreateUserPrincipal(ImportRefs refs, JSSnapshot snapshot, Map settings, Logger log, JSPrincipal jsuser, int passwordEncoding) throws SerializerException {
        block14: {
            try {
                JSSecurityAttributes jsSecAttrs;
                Iterator _itTemp;
                User user = null;
                if (this.userManager.userExists(jsuser.getName())) {
                    user = this.userManager.getUser(jsuser.getName());
                }
                if (!JetspeedSecuritySerializer.isSettingSet((Map)settings, (String)"overwrite_existing") && user != null) break block14;
                if (user == null) {
                    String pwdString = jsuser.getPwDataValue("password");
                    char[] pwdChars = pwdString != null ? pwdString.toCharArray() : null;
                    String password = this.recreatePassword(pwdChars);
                    log.debug("add User " + jsuser.getName() + " with password " + password);
                    user = this.userManager.addUser(jsuser.getName(), jsuser.isMapped());
                    if (password != null && password.length() > 0) {
                        PasswordCredential pwc = this.userManager.getPasswordCredential(user);
                        pwc.setPassword(null, password);
                        pwc.setEncoded(passwordEncoding == 1);
                        this.userManager.storePasswordCredential(pwc);
                    }
                    log.debug("add User done ");
                }
                try {
                    PasswordCredential pwc = this.userManager.getPasswordCredential(user);
                    pwc.setEnabled(jsuser.getPwDataValueAsBoolean("enabled"));
                    pwc.setUpdateRequired(jsuser.getPwDataValueAsBoolean("requiresUpdate"));
                    Date d = jsuser.getPwDataValueAsDate("expirationDate");
                    if (d != null) {
                        pwc.setExpirationDate(d);
                    }
                    this.userManager.storePasswordCredential(pwc);
                }
                catch (Exception e) {
                    log.error("setting userinfo for " + jsuser.getName() + " failed because of " + e.getLocalizedMessage());
                }
                Subject subject = this.userManager.getSubject(user);
                List listTemp = jsuser.getPrivateCredentials();
                if (listTemp != null && listTemp.size() > 0) {
                    _itTemp = listTemp.iterator();
                    while (_itTemp.hasNext()) {
                        subject.getPrivateCredentials().add(_itTemp.next());
                    }
                }
                if ((listTemp = jsuser.getPublicCredentials()) != null && listTemp.size() > 0) {
                    _itTemp = listTemp.iterator();
                    while (_itTemp.hasNext()) {
                        subject.getPublicCredentials().add(_itTemp.next());
                    }
                }
                if ((jsSecAttrs = jsuser.getSecurityAttributes()) != null) {
                    for (JSNVPElement elem : jsSecAttrs.getValues()) {
                        user.getSecurityAttributes().getAttribute(elem.getKey(), true).setStringValue(elem.getValue());
                    }
                }
                refs.getPrincipalMap("user").put(jsuser.getName(), (Principal)user);
                this.userManager.updateUser(user);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"User", e.getMessage()}));
            }
        }
    }

    private void recreateJetspeedPrincipalAssociations(ImportRefs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        log.debug("recreateJetspeedPrincipalAssociations");
        Map principalTypes = this.principalManagerProvider.getPrincipalTypeMap();
        JetspeedPrincipalManager principalManager = null;
        JetspeedPrincipalManager fromPrincipalManager = null;
        JetspeedPrincipal from = null;
        JetspeedPrincipal to = null;
        try {
            for (JSPrincipalAssociation jsAssoc : snapshot.getPrincipalAssociations()) {
                principalManager = this.principalManagerProvider.getManager((JetspeedPrincipalType)principalTypes.get(jsAssoc.getToType()));
                to = principalManager.getPrincipal(jsAssoc.getToName());
                fromPrincipalManager = this.principalManagerProvider.getManager((JetspeedPrincipalType)principalTypes.get(jsAssoc.getFromType()));
                from = fromPrincipalManager.getPrincipal(jsAssoc.getFromName());
                principalManager.addAssociation(from, to, jsAssoc.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"User", e.getMessage()}));
        }
        log.debug("recreateJetspeedPrincipalAssociations - done");
    }

    private void recreatePermissions(ImportRefs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        log.debug("recreatePermissions - started");
        JSPermissions permissionList = null;
        try {
            permissionList = snapshot.getPermissions();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"Permissions", e.getMessage()}));
        }
        for (JSPermission jsPermission : permissionList) {
            JetspeedPermission perm = null;
            perm = jsPermission.getType().equals(JSPermission.TYPE_PORTAL) ? this.pm.newPermission("portlet", jsPermission.getResource(), jsPermission.getActions()) : this.pm.newPermission(jsPermission.getType(), jsPermission.getResource(), jsPermission.getActions());
            if (perm == null || this.pm.permissionExists(perm)) continue;
            try {
                JSUserUsers jsUserUsers;
                JSUserRoles jsUserRoles;
                this.pm.addPermission(perm);
                List listTemp = null;
                JSUserGroups jsUserGroups = jsPermission.getGroupString();
                if (jsUserGroups != null) {
                    listTemp = JetspeedSecuritySerializer.getTokens((String)jsUserGroups.toString());
                }
                if (listTemp != null && listTemp.size() > 0) {
                    Iterator _itTemp = listTemp.iterator();
                    while (_itTemp.hasNext()) {
                        JetspeedPrincipal p = (JetspeedPrincipal)refs.getPrincipalMap("group").get(_itTemp.next());
                        if (p == null) continue;
                        this.pm.grantPermission(perm, p);
                    }
                }
                if ((listTemp = (jsUserRoles = jsPermission.getRoleString()) != null ? JetspeedSecuritySerializer.getTokens((String)jsUserRoles.toString()) : null) != null && listTemp.size() > 0) {
                    Iterator _itTemp = listTemp.iterator();
                    while (_itTemp.hasNext()) {
                        JetspeedPrincipal p = (JetspeedPrincipal)refs.getPrincipalMap("role").get(_itTemp.next());
                        if (p == null) continue;
                        this.pm.grantPermission(perm, p);
                    }
                }
                if ((listTemp = (jsUserUsers = jsPermission.getUserString()) != null ? JetspeedSecuritySerializer.getTokens((String)jsUserUsers.toString()) : null) == null || listTemp.size() <= 0) continue;
                Iterator _itTemp = listTemp.iterator();
                while (_itTemp.hasNext()) {
                    JetspeedPrincipal p = (JetspeedPrincipal)refs.getPrincipalMap("user").get(_itTemp.next());
                    if (p == null) continue;
                    this.pm.grantPermission(perm, p);
                }
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Permissions", e.getMessage()}));
            }
        }
        log.debug("recreatePermissions - done");
    }

    protected int compareCurrentSecurityProvider(JSSnapshot snapshot) {
        String _fileEncryption = snapshot.getEncryption();
        if (_fileEncryption == null || _fileEncryption.length() == 0) {
            return 0;
        }
        if (_fileEncryption.equals(this.getEncryptionString())) {
            return 1;
        }
        return 0;
    }

    private String getEncryptionString() {
        if (this.cpe == null) {
            System.err.println("Error!!! CredentialPasswordEncoder not available");
            return ENCODING_STRING;
        }
        try {
            return this.cpe.encode(JETSPEED, ENCODING_STRING);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return ENCODING_STRING;
        }
    }

    protected String recreatePassword(char[] savedPassword) {
        if (savedPassword == null) {
            return null;
        }
        return new String(savedPassword);
    }

    private void exportJetspeedPrincipals(ExportRefs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException, SecurityException {
        snapshot.setEncryption(this.getEncryptionString());
        for (Map.Entry entry : this.principalManagerProvider.getPrincipalTypeMap().entrySet()) {
            String typeName = (String)entry.getKey();
            JetspeedPrincipalType type = this.principalManagerProvider.getPrincipalType(typeName);
            JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(type);
            for (JetspeedPrincipal principal : principalManager.getPrincipals("")) {
                try {
                    JSPrincipal _tempPrincipal = this.createJSPrincipal(principal);
                    refs.getPrincipalMap(typeName).put(_tempPrincipal.getName(), _tempPrincipal);
                    snapshot.getPrincipals().add((Object)_tempPrincipal);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{typeName, e.getMessage()}));
                }
            }
        }
    }

    private void exportJetspeedPrincipalAssociations(ExportRefs refs, JSSnapshot snapshot, Map settings, Logger log) throws SecurityException, SerializerException {
        Map principalTypes = this.principalManagerProvider.getPrincipalTypeMap();
        HashMap copiedPrincipalTypes = new HashMap(principalTypes);
        JetspeedPrincipalManager principalManager = null;
        JetspeedPrincipalManager otherPrincipalManager = null;
        for (String principalTypeName : principalTypes.keySet()) {
            principalManager = this.principalManagerProvider.getManager(this.principalManagerProvider.getPrincipalType(principalTypeName));
            for (JetspeedPrincipal principal : principalManager.getPrincipals("")) {
                for (JetspeedPrincipalAssociationType assocType : principalManager.getAssociationTypes()) {
                    for (String otherPrincipalTypeName : copiedPrincipalTypes.keySet()) {
                        otherPrincipalManager = this.principalManagerProvider.getManager(this.principalManagerProvider.getPrincipalType(otherPrincipalTypeName));
                        for (JetspeedPrincipal toPrincipal : otherPrincipalManager.getAssociatedFrom(principal.getName(), principal.getType(), assocType.getAssociationName())) {
                            JSPrincipalAssociation jsAssoc = this.createJSPrincipalAssociation(assocType, principal, toPrincipal);
                            snapshot.addPrincipalAssociation(jsAssoc);
                        }
                    }
                }
            }
        }
    }

    private JSPrincipalAssociation createJSPrincipalAssociation(JetspeedPrincipalAssociationType assocType, JetspeedPrincipal from, JetspeedPrincipal to) {
        JSPrincipalAssociation jsAssoc = new JSPrincipalAssociation();
        jsAssoc.setName(assocType.getAssociationName());
        jsAssoc.setFromType(from.getType().getName());
        jsAssoc.setFromName(from.getName());
        jsAssoc.setToType(to.getType().getName());
        jsAssoc.setToName(to.getName());
        return jsAssoc;
    }

    private void exportPermissions(ExportRefs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException, SecurityException {
        for (JetspeedPermission perm : this.pm.getPermissions()) {
            try {
                JSPermission _js = new JSPermission();
                _js.setResource(perm.getName());
                _js.setActions(perm.getActions());
                _js.setType(perm.getType());
                for (JetspeedPrincipal principal : this.pm.getPrincipals(perm)) {
                    String principalTypeName = principal.getType().getName();
                    JSPrincipal jsPrincipal = refs.getPrincipalMap(principalTypeName).get(principal.getName());
                    if (jsPrincipal == null) continue;
                    if ("role".equals(principalTypeName)) {
                        _js.addRole(jsPrincipal);
                        continue;
                    }
                    if ("group".equals(principalTypeName)) {
                        _js.addGroup(jsPrincipal);
                        continue;
                    }
                    if (!"user".equals(principalTypeName)) continue;
                    _js.addUser(jsPrincipal);
                }
                snapshot.getPermissions().add((Object)_js);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Permissions", e.getMessage()}));
            }
        }
    }

    private void addJSPrincipalCredentials(boolean isPublic, JSPrincipal newPrincipal, Credential credential) {
        if (credential == null) {
            return;
        }
        if (credential instanceof PasswordCredential) {
            PasswordCredential pw = (PasswordCredential)credential;
            char[] pwdChars = pw.getPassword() != null ? pw.getPassword().toCharArray() : null;
            newPrincipal.setCredential(pw.getUserName(), pwdChars, pw.getExpirationDate(), pw.isEnabled(), pw.isExpired(), pw.isUpdateRequired());
            return;
        }
        if (isPublic) {
            newPrincipal.addPublicCredential(credential);
        } else {
            newPrincipal.addPrivateCredential(credential);
        }
    }

    private JSPrincipal createJSPrincipal(JetspeedPrincipal principal) throws SecurityException {
        JSPrincipal _jsPrincipal = new JSPrincipal();
        _jsPrincipal.setPrincipal((Principal)principal);
        _jsPrincipal.setType(principal.getType().getName());
        _jsPrincipal.setName(principal.getName());
        _jsPrincipal.setMapped(principal.isMapped());
        _jsPrincipal.setEnabled(principal.isEnabled());
        _jsPrincipal.setReadonly(principal.isReadOnly());
        _jsPrincipal.setRemovable(principal.isRemovable());
        _jsPrincipal.setExtendable(principal.isExtendable());
        if ("user".equals(principal.getType())) {
            PasswordCredential credential = this.userManager.getPasswordCredential((User)principal);
            Subject subject = this.userManager.getSubject((User)principal);
            if (credential != null) {
                this.addJSPrincipalCredentials(true, _jsPrincipal, (Credential)credential);
            }
            for (Object o : subject.getPublicCredentials()) {
                credential = (Credential)o;
                this.addJSPrincipalCredentials(true, _jsPrincipal, (Credential)credential);
            }
            for (Object o : subject.getPrivateCredentials()) {
                credential = (Credential)o;
                this.addJSPrincipalCredentials(false, _jsPrincipal, (Credential)credential);
            }
        }
        _jsPrincipal.setSecurityAttributes(principal.getSecurityAttributes().getAttributeMap());
        return _jsPrincipal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExportRefs {
        private HashMap<String, HashMap<String, JSPrincipal>> principalMapByType = new HashMap();

        private ExportRefs() {
        }

        public HashMap<String, JSPrincipal> getPrincipalMap(String principalTypeName) {
            HashMap<String, Object> jsPrincipalMap = this.principalMapByType.get(principalTypeName);
            if (jsPrincipalMap == null) {
                jsPrincipalMap = new HashMap();
                this.principalMapByType.put(principalTypeName, jsPrincipalMap);
            }
            return jsPrincipalMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportRefs {
        private HashMap<String, HashMap<String, Principal>> principalMapByType = new HashMap();

        private ImportRefs() {
        }

        public HashMap<String, Principal> getPrincipalMap(String principalTypeName) {
            HashMap<String, Principal> principalMap = this.principalMapByType.get(principalTypeName);
            if (principalMap == null) {
                principalMap = new HashMap();
                this.principalMapByType.put(principalTypeName, principalMap);
            }
            return principalMap;
        }
    }
}

