/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.List;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.CredentialPasswordValidator;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.PasswordCredentialInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordCredentialInterceptorsProxy
implements PasswordCredentialInterceptor {
    private PasswordCredentialInterceptor[] interceptors;

    public PasswordCredentialInterceptorsProxy(List<?> interceptors) {
        this.interceptors = interceptors.toArray(new PasswordCredentialInterceptor[interceptors.size()]);
    }

    @Override
    public boolean afterLoad(String userName, PasswordCredential credential, CredentialPasswordEncoder encoder, CredentialPasswordValidator validator) throws SecurityException {
        boolean updated = false;
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i] == null || !this.interceptors[i].afterLoad(userName, credential, encoder, validator)) continue;
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean afterAuthenticated(PasswordCredential credential, boolean authenticated) throws SecurityException {
        boolean updated = false;
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i] == null || !this.interceptors[i].afterAuthenticated(credential, authenticated)) continue;
            updated = true;
        }
        return updated;
    }

    @Override
    public void beforeCreate(PasswordCredential credential) throws SecurityException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i] == null) continue;
            this.interceptors[i].beforeCreate(credential);
        }
    }

    @Override
    public void beforeSetPassword(PasswordCredential credential, String password, boolean authenticated) throws SecurityException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i] == null) continue;
            this.interceptors[i].beforeSetPassword(credential, password, authenticated);
        }
    }
}

