/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserCredential;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;

public class PasswordCredentialImpl
implements PasswordCredential,
PersistenceBrokerAware {
    private static final long serialVersionUID = -4975305752376365096L;
    private boolean persistent;
    private Long principalId;
    private User user;
    private String userName;
    private String currentPassword;
    private String password;
    private String oldPassword;
    private String newPassword;
    private boolean newPasswordSet;
    private boolean encoded;
    private boolean updateAllowed = true;
    private boolean stateReadOnly = false;
    private boolean updateRequired;
    private boolean enabled = true;
    private boolean expired;
    private Timestamp creationDate;
    private Timestamp modifiedDate;
    private java.sql.Date expirationDate;
    private Timestamp previousAuthenticationDate;
    private Timestamp lastAuthenticationDate;
    private int authenticationFailures;
    private Short type = TYPE_CURRENT;

    public PasswordCredentialImpl() {
    }

    public PasswordCredentialImpl(User user, String password) {
        this.setUser(user);
        this.password = password;
    }

    public void synchronize(UserCredential pwc) {
        throw new UnsupportedOperationException();
    }

    public boolean isNew() {
        return !this.persistent;
    }

    private void checkUpdatePassword() {
        if (!this.updateAllowed) {
            throw new IllegalStateException();
        }
    }

    private void checkUpdateState() {
        if (this.stateReadOnly) {
            throw new IllegalStateException();
        }
    }

    public void setUser(User user) {
        this.user = user;
        if (user != null && user.getId() != null) {
            this.principalId = user.getId();
        }
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.user != null ? this.user.getName() : this.userName;
    }

    public User getUser() {
        return this.user;
    }

    public Short getType() {
        return this.type;
    }

    public String getPassword() {
        return this.currentPassword != null ? this.currentPassword : this.password;
    }

    public void setPassword(String password, boolean encoded) {
        this.checkUpdatePassword();
        if (!(password == null || this.password != null && encoded == this.encoded && password.equals(this.password))) {
            if (!this.newPasswordSet && this.currentPassword == null) {
                this.currentPassword = password;
            }
            this.password = password;
            this.encoded = encoded;
            this.oldPassword = null;
            this.newPassword = null;
            this.newPasswordSet = true;
        }
    }

    public void setPassword(String oldPassword, String newPassword) {
        this.checkUpdatePassword();
        if (!(newPassword == null || oldPassword != null && newPassword.equals(oldPassword))) {
            if (!this.newPasswordSet && this.currentPassword == null) {
                this.currentPassword = this.password;
            }
            this.newPassword = newPassword;
            this.oldPassword = oldPassword;
            this.newPasswordSet = true;
        }
    }

    public void clearNewPasswordSet() {
        this.currentPassword = null;
        this.oldPassword = null;
        this.newPassword = null;
        this.newPasswordSet = false;
    }

    public void revertNewPasswordSet() {
        if (this.newPasswordSet) {
            this.newPassword = this.currentPassword;
            this.currentPassword = null;
            this.oldPassword = null;
            this.newPassword = null;
            this.newPasswordSet = false;
        }
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public boolean isNewPasswordSet() {
        return this.newPasswordSet;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public void setEncoded(boolean encoded) {
        this.checkUpdatePassword();
        this.encoded = encoded;
    }

    public boolean isUpdateAllowed() {
        return this.updateAllowed;
    }

    public void setUpdateAllowed(boolean updateAllowed) {
        this.updateAllowed = true;
    }

    public boolean isStateReadOnly() {
        return this.stateReadOnly;
    }

    public void setStateReadOnly(boolean stateReadOnly) {
        this.stateReadOnly = stateReadOnly;
    }

    public boolean isUpdateRequired() {
        return this.updateRequired;
    }

    public void setUpdateRequired(boolean updateRequired) {
        this.checkUpdateState();
        this.updateRequired = updateRequired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.checkUpdateState();
        this.enabled = enabled;
        if (enabled) {
            this.setAuthenticationFailures(0);
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.checkUpdateState();
        this.expired = expired;
    }

    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public Timestamp getModifiedDate() {
        return this.modifiedDate;
    }

    public java.sql.Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(java.sql.Date expirationDate) {
        this.checkUpdateState();
        this.expirationDate = expirationDate;
        if (expirationDate != null && new java.sql.Date(new Date().getTime()).after(expirationDate)) {
            this.setExpired(true);
        } else {
            this.setExpired(false);
        }
    }

    public Timestamp getPreviousAuthenticationDate() {
        return this.previousAuthenticationDate;
    }

    public void setPreviousAuthenticationDate(Timestamp previousAuthenticationDate) {
        this.checkUpdateState();
        this.previousAuthenticationDate = previousAuthenticationDate;
    }

    public Timestamp getLastAuthenticationDate() {
        return this.lastAuthenticationDate;
    }

    public void setLastAuthenticationDate(Timestamp lastAuthenticationDate) {
        this.checkUpdateState();
        this.lastAuthenticationDate = lastAuthenticationDate;
    }

    public int getAuthenticationFailures() {
        return this.authenticationFailures;
    }

    public void setAuthenticationFailures(int authenticationFailures) {
        this.checkUpdateState();
        this.authenticationFailures = authenticationFailures;
    }

    public void afterDelete(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.persistent = false;
    }

    public void afterInsert(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.persistent = true;
    }

    public void afterLookup(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.persistent = true;
    }

    public void afterUpdate(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void beforeInsert(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.modifiedDate = this.creationDate = new Timestamp(System.currentTimeMillis());
    }

    public void beforeUpdate(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.modifiedDate = new Timestamp(System.currentTimeMillis());
    }
}

