/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.impl.AbstractPasswordCredentialInterceptorImpl;

public class MaxPasswordAuthenticationFailuresInterceptor
extends AbstractPasswordCredentialInterceptorImpl {
    private int maxNumberOfAuthenticationFailures;

    public MaxPasswordAuthenticationFailuresInterceptor(int maxNumberOfAuthenticationFailures) {
        this.maxNumberOfAuthenticationFailures = maxNumberOfAuthenticationFailures;
    }

    public boolean afterAuthenticated(PasswordCredential credential, boolean authenticated) throws SecurityException {
        boolean update = false;
        if (!credential.isExpired() && !authenticated && this.maxNumberOfAuthenticationFailures > 0) {
            int authenticationFailures = credential.getAuthenticationFailures() + 1;
            credential.setAuthenticationFailures(authenticationFailures);
            if (authenticationFailures >= this.maxNumberOfAuthenticationFailures) {
                credential.setEnabled(false);
            }
            update = true;
        }
        return update;
    }

    public void beforeCreate(PasswordCredential credential) throws SecurityException {
        credential.setAuthenticationFailures(0);
    }

    public void beforeSetPassword(PasswordCredential credential, String password) throws SecurityException {
        credential.setAuthenticationFailures(0);
    }
}

