/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.i18n.KeyedMessage;
import org.apache.jetspeed.security.JetspeedPermission;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationReference;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityDomain;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.impl.PersistentJetspeedPrincipal;
import org.apache.jetspeed.security.impl.SecurityDomainImpl;
import org.apache.jetspeed.security.impl.TransientJetspeedPrincipal;
import org.apache.jetspeed.security.spi.JetspeedDomainPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPermissionAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPermissionStorageManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAssociationStorageManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalStorageManager;
import org.apache.jetspeed.security.spi.PersistentJetspeedPermission;
import org.apache.jetspeed.security.spi.SecurityDomainAccessManager;
import org.apache.jetspeed.security.spi.SecurityDomainStorageManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialAccessManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialStorageManager;
import org.apache.jetspeed.security.spi.impl.JetspeedPrincipalAssociation;
import org.apache.jetspeed.security.spi.impl.JetspeedPrincipalPermission;
import org.apache.jetspeed.security.spi.impl.PasswordCredentialImpl;
import org.apache.jetspeed.security.spi.impl.PersistentJetspeedPermissionImpl;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.util.collections.ManageableArrayList;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.ojb.PersistenceBrokerCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedSecurityPersistenceManager
extends InitablePersistenceBrokerDaoSupport
implements Serializable,
JetspeedPrincipalAccessManager,
JetspeedPrincipalStorageManager,
JetspeedDomainPrincipalAccessManager,
UserPasswordCredentialStorageManager,
UserPasswordCredentialAccessManager,
JetspeedPrincipalAssociationStorageManager,
JetspeedPermissionAccessManager,
JetspeedPermissionStorageManager,
SecurityDomainStorageManager,
SecurityDomainAccessManager {
    private static final long serialVersionUID = -2689340557699526023L;
    private Long defaultSecurityDomainId;

    public JetspeedSecurityPersistenceManager(String repositoryPath) {
        super(repositoryPath);
    }

    protected Long getPrincipalId(String name, String type, Long domainId) throws SecurityException {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", (Object)name);
        criteria.addEqualTo("type", (Object)type);
        criteria.addEqualTo("domainId", (Object)domainId);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"id"});
        query.setJdbcTypes(new int[]{-5});
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        if (iter.hasNext()) {
            return (Long)((Object[])iter.next())[0];
        }
        throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(type, (Object)name));
    }

    public boolean principalExists(JetspeedPrincipal principal) {
        if (principal.getId() == null) {
            if (principal.getDomainId() != null) {
                return this.principalExists(principal.getName(), principal.getType(), principal.getDomainId());
            }
            return this.principalExists(principal.getName(), principal.getType());
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("id", (Object)principal.getId());
        criteria.addEqualTo("type", (Object)principal.getType().getName());
        criteria.addEqualTo("domainId", (Object)principal.getDomainId());
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)query) == 1;
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedFrom(String principalFromName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedFrom(principalFromName, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedFrom(String principalFromName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsTo.associationName", (Object)associationName);
        criteria.addEqualTo("associationsTo.from.name", (Object)principalFromName);
        criteria.addEqualTo("type", (Object)to.getName());
        criteria.addEqualTo("associationsTo.from.domainId", (Object)fromSecurityDomain);
        criteria.addEqualTo("domainId", (Object)toSecurityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedTo(String principalToName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedTo(principalToName, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedTo(String principalToName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsFrom.associationName", (Object)associationName);
        criteria.addEqualTo("associationsFrom.to.name", (Object)principalToName);
        criteria.addEqualTo("type", (Object)from.getName());
        criteria.addEqualTo("associationsFrom.to.domainId", (Object)toSecurityDomain);
        criteria.addEqualTo("domainId", (Object)fromSecurityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedFrom(Long principalFromId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedFrom(principalFromId, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedFrom(Long principalFromId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsTo.associationName", (Object)associationName);
        criteria.addEqualTo("associationsTo.from.id", (Object)principalFromId);
        criteria.addEqualTo("type", (Object)to.getName());
        criteria.addEqualTo("associationsTo.from.domainId", (Object)fromSecurityDomain);
        criteria.addEqualTo("domainId", (Object)toSecurityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedTo(Long principalToId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedTo(principalToId, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedTo(Long principalToId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsFrom.associationName", (Object)associationName);
        criteria.addEqualTo("associationsFrom.to.id", (Object)principalToId);
        criteria.addEqualTo("type", (Object)from.getName());
        criteria.addEqualTo("associationsFrom.to.domainId", (Object)toSecurityDomain);
        criteria.addEqualTo("domainId", (Object)fromSecurityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public List<String> getAssociatedNamesFrom(String principalFromName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedNamesFrom(principalFromName, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<String> getAssociatedNamesFrom(String principalFromName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsTo.associationName", (Object)associationName);
        criteria.addEqualTo("associationsTo.from.name", (Object)principalFromName);
        criteria.addEqualTo("type", (Object)to.getName());
        criteria.addEqualTo("associationsTo.from.domainId", (Object)fromSecurityDomain);
        criteria.addEqualTo("domainId", (Object)toSecurityDomain);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name"});
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            names.add((String)((Object[])iter.next())[0]);
        }
        return names;
    }

    @Override
    public List<String> getAssociatedNamesFrom(Long principalFromId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedNamesFrom(principalFromId, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<String> getAssociatedNamesFrom(Long principalFromId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsTo.associationName", (Object)associationName);
        criteria.addEqualTo("associationsTo.from.id", (Object)principalFromId);
        criteria.addEqualTo("type", (Object)to.getName());
        criteria.addEqualTo("associationsTo.from.domainId", (Object)fromSecurityDomain);
        criteria.addEqualTo("domainId", (Object)toSecurityDomain);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name"});
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            names.add((String)((Object[])iter.next())[0]);
        }
        return names;
    }

    @Override
    public List<String> getAssociatedNamesTo(String principalToName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedNamesTo(principalToName, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<String> getAssociatedNamesTo(String principalToName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsFrom.associationName", (Object)associationName);
        criteria.addEqualTo("associationsFrom.to.name", (Object)principalToName);
        criteria.addEqualTo("type", (Object)from.getName());
        criteria.addEqualTo("associationsFrom.to.domainId", (Object)toSecurityDomain);
        criteria.addEqualTo("domainId", (Object)fromSecurityDomain);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name"});
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            names.add((String)((Object[])iter.next())[0]);
        }
        return names;
    }

    @Override
    public List<String> getAssociatedNamesTo(Long principalToId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedNamesTo(principalToId, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<String> getAssociatedNamesTo(Long principalToId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsFrom.associationName", (Object)associationName);
        criteria.addEqualTo("associationsFrom.to.id", (Object)principalToId);
        criteria.addEqualTo("type", (Object)from.getName());
        criteria.addEqualTo("associationsFrom.to.domainId", (Object)toSecurityDomain);
        criteria.addEqualTo("domainId", (Object)fromSecurityDomain);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name"});
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            names.add((String)((Object[])iter.next())[0]);
        }
        return names;
    }

    @Override
    public JetspeedPrincipal getPrincipal(Long id) {
        return (JetspeedPrincipal)this.getPersistenceBrokerTemplate().getObjectById(PersistentJetspeedPrincipal.class, (Object)id);
    }

    @Override
    public JetspeedPrincipal getPrincipal(String principalName, JetspeedPrincipalType type) {
        return this.getPrincipal(principalName, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public JetspeedPrincipal getPrincipal(String principalName, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", (Object)principalName);
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return (JetspeedPrincipal)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
    }

    @Override
    public List<String> getPrincipalNames(String nameFilter, JetspeedPrincipalType type) {
        return this.getPrincipalNames(nameFilter, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public List<String> getPrincipalNames(String nameFilter, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        if (nameFilter != null && nameFilter.length() > 0) {
            criteria.addLike((Object)"name", (Object)(nameFilter + "%"));
        }
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name"});
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            names.add((String)((Object[])iter.next())[0]);
        }
        return names;
    }

    @Override
    public List<JetspeedPrincipal> getPrincipals(String nameFilter, JetspeedPrincipalType type) {
        return this.getPrincipals(nameFilter, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public List<JetspeedPrincipal> getPrincipals(String nameFilter, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        if (nameFilter != null && nameFilter.length() > 0) {
            criteria.addLike((Object)"name", (Object)(nameFilter + "%"));
        }
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public List<JetspeedPrincipal> getPrincipalsByAttribute(String attributeName, String attributeValue, JetspeedPrincipalType type) {
        return this.getPrincipalsByAttribute(attributeName, attributeValue, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public List<JetspeedPrincipal> getPrincipalsByAttribute(String attributeName, String attributeValue, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("attributes.name", (Object)attributeName);
        criteria.addEqualTo("attributes.value", (Object)attributeValue);
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public boolean principalExists(String principalName, JetspeedPrincipalType type) {
        return this.principalExists(principalName, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public boolean principalExists(String principalName, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", (Object)principalName);
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)query) == 1;
    }

    @Override
    public void addPrincipal(JetspeedPrincipal principal, Set<JetspeedPrincipalAssociationReference> associations) throws SecurityException {
        if (principal.getDomainId() == null && principal instanceof TransientJetspeedPrincipal) {
            ((TransientJetspeedPrincipal)principal).setDomainId(this.getDefaultSecurityDomainId());
        }
        if (this.principalExists(principal)) {
            throw new SecurityException(SecurityException.PRINCIPAL_ALREADY_EXISTS.createScoped(principal.getType().getName(), (Object)principal.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)principal);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"addPrincipal", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public boolean isMapped() {
        return false;
    }

    @Override
    public void removePrincipal(JetspeedPrincipal principal) throws SecurityException {
        if (!this.principalExists(principal)) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(principal.getType().getName(), (Object)principal.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().delete((Object)principal);
        }
        catch (Exception pbe) {
            if (pbe instanceof DataIntegrityViolationException) {
                this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                throw new SecurityException(SecurityException.PRINCIPAL_NOT_REMOVABLE.createScoped(principal.getType().getName(), (Object)principal.getName()));
            }
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removePrincipal", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void updatePrincipal(JetspeedPrincipal principal) throws SecurityException {
        if (!this.principalExists(principal)) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(principal.getType().getName(), (Object)principal.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)principal);
        }
        catch (Exception pbe) {
            if (pbe instanceof DataIntegrityViolationException) {
                this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                throw new SecurityException(SecurityException.PRINCIPAL_UPDATE_FAILURE.createScoped(principal.getType().getName(), (Object)principal.getName()));
            }
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removePrincipal", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public PasswordCredential getPasswordCredential(User user) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)user.getId());
        criteria.addEqualTo("type", (Object)PasswordCredential.TYPE_CURRENT);
        QueryByCriteria query = QueryFactory.newQuery(PasswordCredentialImpl.class, (Criteria)criteria);
        PasswordCredentialImpl pwc = (PasswordCredentialImpl)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (pwc == null) {
            pwc = new PasswordCredentialImpl();
        }
        pwc.setUser(user);
        return pwc;
    }

    @Override
    public void storePasswordCredential(PasswordCredential credential) throws SecurityException {
        if (credential.isNewPasswordSet() && credential.getNewPassword() != null) {
            credential.setPassword(credential.getNewPassword(), credential.isEncoded());
        }
        this.getPersistenceBrokerTemplate().store((Object)credential);
    }

    @Override
    public PasswordCredential getPasswordCredential(String userName) {
        return this.getPasswordCredential(userName, this.getDefaultSecurityDomainId());
    }

    @Override
    public PasswordCredential getPasswordCredential(String userName, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("user.name", (Object)userName);
        criteria.addEqualTo("user.enabled", (Object)true);
        criteria.addEqualTo("type", (Object)PasswordCredential.TYPE_CURRENT);
        criteria.addEqualTo("domainId", (Object)securityDomain);
        QueryByCriteria query = QueryFactory.newQuery(PasswordCredentialImpl.class, (Criteria)criteria);
        PasswordCredentialImpl pwc = (PasswordCredentialImpl)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (pwc != null) {
            pwc.setUserName(userName);
        }
        return pwc;
    }

    @Override
    public void loadPasswordCredentialUser(final PasswordCredential credential) {
        if (credential.getUser() == null) {
            this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

                public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                    pb.retrieveReference((Object)credential, "user");
                    return null;
                }
            });
        }
    }

    @Override
    public List<PasswordCredential> getHistoricPasswordCredentials(User user) {
        return this.getHistoricPasswordCredentials(user, this.getDefaultSecurityDomainId());
    }

    @Override
    public List<PasswordCredential> getHistoricPasswordCredentials(User user, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)user.getId());
        criteria.addEqualTo("type", (Object)PasswordCredential.TYPE_HISTORICAL);
        QueryByCriteria query = QueryFactory.newQuery(PasswordCredentialImpl.class, (Criteria)criteria);
        List list = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        for (PasswordCredential pwc : list) {
            ((PasswordCredentialImpl)pwc).setUser(user);
        }
        return list;
    }

    @Override
    public void addAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("fromPrincipalId", (Object)from.getId());
        criteria.addEqualTo("toPrincipalId", (Object)to.getId());
        criteria.addEqualTo("associationName", (Object)associationName);
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalAssociation.class, (Criteria)criteria);
        if (this.getPersistenceBrokerTemplate().getCount((Query)query) == 0) {
            try {
                this.getPersistenceBrokerTemplate().store((Object)new JetspeedPrincipalAssociation(from, to, associationName));
            }
            catch (Exception pbe) {
                if (pbe instanceof DataIntegrityViolationException) {
                    this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                    throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(from.getType().getName(), (Object)from.getName()));
                }
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"addAssociation", (Object)pbe.getMessage());
                this.logger.error((Object)msg, (Throwable)pbe);
                throw new SecurityException(msg, (Throwable)pbe);
            }
        }
    }

    @Override
    public void removeAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("fromPrincipalId", (Object)from.getId());
        criteria.addEqualTo("toPrincipalId", (Object)to.getId());
        criteria.addEqualTo("associationName", (Object)associationName);
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalAssociation.class, (Criteria)criteria);
        if (this.getPersistenceBrokerTemplate().getCount((Query)query) != 0) {
            try {
                this.getPersistenceBrokerTemplate().delete((Object)new JetspeedPrincipalAssociation(from, to, associationName));
            }
            catch (Exception pbe) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removeAssociation", (Object)pbe.getMessage());
                this.logger.error((Object)msg, (Throwable)pbe);
                throw new SecurityException(msg, (Throwable)pbe);
            }
        }
    }

    public List<PersistentJetspeedPermission> getPermissions() {
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)new Criteria());
        query.addOrderByAscending("type");
        query.addOrderByAscending("name");
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    public List<PersistentJetspeedPermission> getPermissions(String type) {
        return this.getPermissions(type, null);
    }

    public List<PersistentJetspeedPermission> getPermissions(String type, String nameFilter) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("type", (Object)type);
        if (nameFilter != null && nameFilter.length() > 0) {
            criteria.addLike((Object)"name", (Object)(nameFilter + "%"));
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        query.addOrderByAscending("name");
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public boolean permissionExists(JetspeedPermission permission) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("type", (Object)permission.getType());
        criteria.addEqualTo("name", (Object)permission.getName());
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)query) == 1;
    }

    public List<PersistentJetspeedPermission> getPermissions(PersistentJetspeedPrincipal principal) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principals.principalId", (Object)principal.getId());
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        query.addOrderByAscending("type");
        query.addOrderByAscending("name");
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public List<JetspeedPrincipal> getPrincipals(PersistentJetspeedPermission permission, String principalType) {
        Criteria criteria = new Criteria();
        if (permission.getId() != null) {
            criteria.addEqualTo("permissions.permissionId", (Object)permission.getId());
        } else {
            criteria.addEqualTo("permissions.permission.type", (Object)permission.getType());
            criteria.addEqualTo("permissions.permission.name", (Object)permission.getName());
        }
        if (principalType != null) {
            criteria.addEqualTo("type", (Object)principalType);
        }
        criteria.addEqualTo("domainId", (Object)this.getDefaultSecurityDomainId());
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.addOrderByAscending("type");
        query.addOrderByAscending("name");
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public void addPermission(PersistentJetspeedPermission permission) throws SecurityException {
        if (permission.getId() != null || this.permissionExists(permission)) {
            throw new SecurityException(SecurityException.PERMISSION_ALREADY_EXISTS.create((Object)permission.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)permission);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"addPermission", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void updatePermission(PersistentJetspeedPermission permission) throws SecurityException {
        Criteria criteria = new Criteria();
        if (permission.getId() == null) {
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
        } else {
            criteria.addEqualTo("id", (Object)permission.getId());
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        PersistentJetspeedPermission current = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (current == null) {
            throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
        }
        if (!current.getActions().equals(permission.getActions())) {
            current.setActions(permission.getActions());
            try {
                this.getPersistenceBrokerTemplate().store((Object)current);
            }
            catch (Exception pbe) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"updatePermission", (Object)pbe.getMessage());
                this.logger.error((Object)msg, (Throwable)pbe);
                throw new SecurityException(msg, (Throwable)pbe);
            }
        }
    }

    @Override
    public void removePermission(PersistentJetspeedPermission permission) throws SecurityException {
        Criteria criteria = new Criteria();
        if (permission.getId() == null) {
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
        } else {
            criteria.addEqualTo("id", (Object)permission.getId());
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        PersistentJetspeedPermission current = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (current == null) {
            throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().delete((Object)current);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removePermission", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void grantPermission(PersistentJetspeedPermission permission, JetspeedPrincipal principal) throws SecurityException {
        if (permission.getId() == null) {
            Criteria criteria = new Criteria();
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
            QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
            PersistentJetspeedPermission p = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (p == null) {
                throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
            }
            permission = p;
        }
        this.grantPermission(permission, principal, true);
    }

    protected void grantPermission(PersistentJetspeedPermission permission, JetspeedPrincipal principal, boolean checkExists) throws SecurityException {
        if (principal.isTransient() || principal.getId() == null) {
            JetspeedPrincipal p = this.getPrincipal(principal.getName(), principal.getType());
            if (p == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(principal.getType().getName(), (Object)principal.getName()));
            }
            principal = p;
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)principal.getId());
        criteria.addEqualTo("permissionId", (Object)permission.getId());
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalPermission.class, (Criteria)criteria);
        if (!checkExists || this.getPersistenceBrokerTemplate().getCount((Query)query) == 0) {
            try {
                this.getPersistenceBrokerTemplate().store((Object)new JetspeedPrincipalPermission(principal, permission));
            }
            catch (Exception pbe) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"grantPermission", (Object)pbe.getMessage());
                this.logger.error((Object)msg, (Throwable)pbe);
                throw new SecurityException(msg, (Throwable)pbe);
            }
        }
    }

    @Override
    public void grantPermissionOnlyTo(PersistentJetspeedPermission permission, String principalType, List<JetspeedPrincipal> principals) throws SecurityException {
        QueryByCriteria query;
        Criteria criteria;
        if (permission.getId() == null) {
            criteria = new Criteria();
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
            query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
            PersistentJetspeedPermission p = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (p == null) {
                throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
            }
            permission = p;
        }
        criteria = new Criteria();
        criteria.addEqualTo("permissions.permissionId", (Object)permission.getId());
        if (principalType != null) {
            criteria.addEqualTo("type", (Object)principalType);
        }
        criteria.addEqualTo("domainId", (Object)this.getDefaultSecurityDomainId());
        query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        List currentList = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        ArrayList<JetspeedPrincipal> targetList = new ArrayList<JetspeedPrincipal>(principals);
        Iterator i = currentList.iterator();
        while (i.hasNext()) {
            JetspeedPrincipal current = (JetspeedPrincipal)i.next();
            Iterator j = targetList.iterator();
            while (j.hasNext()) {
                JetspeedPrincipal target = (JetspeedPrincipal)j.next();
                if (principalType != null && !target.getType().getName().equals(principalType)) {
                    throw new SecurityException(SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"grantPermissionOnlyTo", (Object)("Specified " + target.getType().getName() + " principal: " + target.getName() + " is not of type: " + principalType)));
                }
                if (!current.getType().getName().equals(target.getType().getName()) || !current.getName().equals(target.getName())) continue;
                j.remove();
                current = null;
                break;
            }
            if (current != null) continue;
            i.remove();
        }
        i = currentList.iterator();
        while (i.hasNext()) {
            this.revokePermission(permission, (JetspeedPrincipal)i.next());
        }
        i = targetList.iterator();
        while (i.hasNext()) {
            this.grantPermission(permission, (JetspeedPrincipal)i.next(), false);
        }
    }

    @Override
    public void revokePermission(PersistentJetspeedPermission permission, JetspeedPrincipal principal) throws SecurityException {
        Long principalId = null;
        Criteria criteria = new Criteria();
        principalId = principal.isTransient() || principal.getId() == null ? this.getPrincipalId(principal.getName(), principal.getType().getName(), this.getDefaultSecurityDomainId()) : principal.getId();
        criteria.addEqualTo("principalId", (Object)principalId);
        if (permission.getId() == null) {
            criteria.addEqualTo("permission.type", (Object)permission.getType());
            criteria.addEqualTo("permission.name", (Object)permission.getName());
        } else {
            criteria.addEqualTo("permissionId", (Object)permission.getId());
        }
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalPermission.class, (Criteria)criteria);
        try {
            this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"revokePermission", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void revokeAllPermissions(JetspeedPrincipal principal) throws SecurityException {
        Long principalId = null;
        Criteria criteria = new Criteria();
        principalId = principal.isTransient() || principal.getId() == null ? this.getPrincipalId(principal.getName(), principal.getType().getName(), this.getDefaultSecurityDomainId()) : principal.getId();
        criteria.addEqualTo("principalId", (Object)principalId);
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalPermission.class, (Criteria)criteria);
        try {
            this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"revokeAllPermissions", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    protected boolean domainExists(SecurityDomain domain) {
        if (domain.getDomainId() != null) {
            return this.getDomain(domain.getDomainId()) != null;
        }
        return this.getDomainByName(domain.getName()) != null;
    }

    @Override
    public void addDomain(SecurityDomain domain) throws SecurityException {
        if (this.domainExists(domain)) {
            throw new SecurityException(SecurityException.SECURITY_DOMAIN_EXISTS.create((Object)domain.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)domain);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"addDomain", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public SecurityDomain getDomain(Long domainId) {
        try {
            return (SecurityDomain)this.getPersistenceBrokerTemplate().getObjectById(SecurityDomainImpl.class, (Object)domainId);
        }
        catch (ObjectRetrievalFailureException ore) {
            return null;
        }
    }

    protected Long getDefaultSecurityDomainId() {
        if (this.defaultSecurityDomainId == null) {
            SecurityDomain d = this.getDomainByName("[default]");
            if (d != null) {
                this.defaultSecurityDomainId = d.getDomainId();
            } else {
                throw new IllegalStateException("The default security domain could not be found.");
            }
        }
        return this.defaultSecurityDomainId;
    }

    @Override
    public SecurityDomain getDomainByName(String domainName) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", (Object)domainName);
        QueryByCriteria query = QueryFactory.newQuery(SecurityDomainImpl.class, (Criteria)criteria);
        return (SecurityDomain)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
    }

    @Override
    public Collection<SecurityDomain> getAllDomains() {
        QueryByCriteria query = QueryFactory.newQuery(SecurityDomainImpl.class, (Criteria)new Criteria());
        query.addOrderByAscending("name");
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    @Override
    public void removeDomain(SecurityDomain domain) throws SecurityException {
        if (!this.domainExists(domain)) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.create((Object)domain.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().delete((Object)domain);
        }
        catch (Exception pbe) {
            if (pbe instanceof DataIntegrityViolationException) {
                this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                throw new SecurityException(SecurityException.SECURITY_DOMAIN_NOT_REMOVABLE.create((Object)domain.getName()));
            }
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removeDomain", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void updateDomain(SecurityDomain domain) throws SecurityException {
        if (!this.domainExists(domain)) {
            throw new SecurityException(SecurityException.SECURITY_DOMAIN_DOES_NOT_EXIST.create((Object)domain.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)domain);
        }
        catch (Exception pbe) {
            if (pbe instanceof DataIntegrityViolationException) {
                this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                throw new SecurityException(SecurityException.SECURITY_DOMAIN_UPDATE_FAILURE.create((Object)domain.getDomainId()));
            }
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"updateDomain", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public Collection<SecurityDomain> getDomainsOwnedBy(Long ownerDomainId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("ownerDomainId", (Object)ownerDomainId);
        QueryByCriteria query = QueryFactory.newQuery(SecurityDomainImpl.class, (Criteria)criteria);
        query.addOrderByAscending("name");
        return (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
    }

    private static class ManagedListByQueryCallback
    implements PersistenceBrokerCallback {
        private Query query;

        public ManagedListByQueryCallback(Query query) {
            this.query = query;
        }

        public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException, LookupException, SQLException {
            return pb.getCollectionByQuery(ManageableArrayList.class, this.query);
        }
    }
}

