/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.SecurityEntityManager;
import org.apache.jetspeed.security.mapping.impl.SecurityEntityRelationTypeImpl;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAssociationStorageManager;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;

public class JetspeedPrincipalLdapAssociationStorageManager
implements JetspeedPrincipalAssociationStorageManager {
    private SecurityEntityManager ldapEntityManager;
    private JetspeedPrincipalAssociationStorageManager databaseStorageManager;

    public JetspeedPrincipalLdapAssociationStorageManager(JetspeedPrincipalAssociationStorageManager databaseStorageMngr, SecurityEntityManager ldapEntityManager) {
        this.ldapEntityManager = ldapEntityManager;
        this.databaseStorageManager = databaseStorageMngr;
    }

    public void addAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        if (!SynchronizationStateAccess.isSynchronizing()) {
            EntityFactory entityFactory = this.ldapEntityManager.getEntityFactory(from.getType().getName());
            EntityFactory relatedFactory = this.ldapEntityManager.getEntityFactory(to.getType().getName());
            Entity fromEntity = entityFactory.createEntity(from);
            Entity toEntity = relatedFactory.createEntity(to);
            SecurityEntityRelationTypeImpl relationType = new SecurityEntityRelationTypeImpl(associationName, fromEntity.getType(), toEntity.getType());
            this.ldapEntityManager.addRelation(fromEntity, toEntity, relationType);
        }
        this.databaseStorageManager.addAssociation(from, to, associationName);
    }

    public void removeAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        if (!SynchronizationStateAccess.isSynchronizing()) {
            EntityFactory entityFactory = this.ldapEntityManager.getEntityFactory(from.getType().getName());
            EntityFactory relatedFactory = this.ldapEntityManager.getEntityFactory(to.getType().getName());
            Entity fromEntity = entityFactory.createEntity(from);
            Entity toEntity = relatedFactory.createEntity(to);
            SecurityEntityRelationTypeImpl relationType = new SecurityEntityRelationTypeImpl(associationName, fromEntity.getType(), toEntity.getType());
            this.ldapEntityManager.removeRelation(fromEntity, toEntity, relationType);
            this.databaseStorageManager.removeAssociation(from, to, associationName);
        }
    }
}

