/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jetspeed.security.CredentialPasswordValidator;
import org.apache.jetspeed.security.SecurityException;

public class DefaultCredentialPasswordValidator
implements CredentialPasswordValidator {
    private String passwordPattern;
    private boolean strictPassword = false;
    private static final String defaultPasswordPattern = "[^.*(?=.{6,})(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%^&+=]).*$]";

    public DefaultCredentialPasswordValidator(String passwordPattern) {
        this.passwordPattern = passwordPattern;
        this.strictPassword = true;
    }

    public DefaultCredentialPasswordValidator() {
        this.strictPassword = false;
    }

    public void validate(String clearTextPassword) throws SecurityException {
        Pattern p;
        Matcher m;
        if (this.strictPassword ? !(m = (p = Pattern.compile(this.passwordPattern)).matcher(clearTextPassword)).matches() : clearTextPassword == null || clearTextPassword.length() == 0) {
            throw new SecurityException(SecurityException.INVALID_PASSWORD);
        }
    }
}

