/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.security.mapping.ldap.util.DnUtils;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.mapping.model.impl.AttributeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImpl
implements Entity {
    private Map<String, Attribute> nameToAttributeMap = new HashMap<String, Attribute>();
    private final Set<AttributeDef> allowedAttributes;
    private String id;
    private String internalId;
    private String type;

    public EntityImpl(String type, String id, Set<AttributeDef> allowedAttributes) {
        this.type = type;
        this.id = id;
        this.allowedAttributes = Collections.unmodifiableSet(allowedAttributes);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.nameToAttributeMap.get(name);
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return Collections.unmodifiableMap(this.nameToAttributeMap);
    }

    @Override
    public Map<String, Attribute> getMappedAttributes() {
        HashMap<String, Attribute> mappedAttrs = new HashMap<String, Attribute>();
        for (Map.Entry<String, Attribute> mappedAttrEntry : this.nameToAttributeMap.entrySet()) {
            if (!mappedAttrEntry.getValue().getDefinition().isMapped()) continue;
            mappedAttrs.put(mappedAttrEntry.getValue().getMappedName(), mappedAttrEntry.getValue());
        }
        return Collections.unmodifiableMap(mappedAttrs);
    }

    @Override
    public Set<AttributeDef> getAllowedAttributes() {
        return this.allowedAttributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected AttributeDef getAttributeDefinition(String name) {
        for (AttributeDef def : this.allowedAttributes) {
            if (!def.getName().equals(name)) continue;
            return def;
        }
        return null;
    }

    @Override
    public void setAttribute(String name, String value) {
        Attribute attr = this.nameToAttributeMap.get(name);
        if (attr == null) {
            AttributeDef def = this.getAttributeDefinition(name);
            if (def == null) {
                return;
            }
            if (def.isMultiValue()) {
                return;
            }
            attr = new AttributeImpl(def);
            this.nameToAttributeMap.put(name, attr);
        }
        attr.setValue(value);
    }

    @Override
    public void setAttribute(String name, Collection<String> values) {
        Attribute attr = this.nameToAttributeMap.get(name);
        if (attr == null) {
            AttributeDef def = this.getAttributeDefinition(name);
            if (def == null) {
                return;
            }
            if (!def.isMultiValue()) {
                return;
            }
            attr = new AttributeImpl(def);
            this.nameToAttributeMap.put(name, attr);
        }
        attr.setValues(values);
    }

    @Override
    public void setAttributes(Set<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.nameToAttributeMap.put(attribute.getName(), attribute);
        }
    }

    @Override
    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        if (internalId != null) {
            internalId = DnUtils.encodeDn(internalId);
        }
        this.internalId = internalId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.internalId == null ? 0 : this.internalId.hashCode());
        result = 31 * result + (this.nameToAttributeMap == null ? 0 : ((Object)this.nameToAttributeMap).hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityImpl other = (EntityImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.internalId == null ? other.internalId != null : !this.internalId.equals(other.internalId)) {
            return false;
        }
        if (this.nameToAttributeMap == null ? other.nameToAttributeMap != null : !((Object)this.nameToAttributeMap).equals(other.nameToAttributeMap)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Entity of type '");
        sb.append(this.getType());
        sb.append("'\nid=");
        sb.append(this.getId());
        sb.append("\ninternalId=");
        sb.append(this.getInternalId());
        sb.append("\nAmount of attributes: ");
        sb.append(this.nameToAttributeMap.values().size());
        sb.append("\n");
        for (Attribute attr : this.nameToAttributeMap.values()) {
            sb.append("attribute: ");
            sb.append(attr.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

