/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.model.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.mapping.model.EntityDAO;
import org.apache.jetspeed.security.mapping.model.EntityRelationDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntityRelationSearch
implements EntityRelationDAO {
    private EntityDAO toEntitySearch;
    private String relationAttribute;

    @Override
    public Collection<Entity> getRelatedEntities(Entity entity) {
        Set<String> relatedEntityIds = this.getRelatedEntityIds(entity);
        if (relatedEntityIds.size() > 0) {
            return this.toEntitySearch.getEntities(relatedEntityIds);
        }
        return CollectionUtils.EMPTY_COLLECTION;
    }

    @Override
    public Entity getRelatedEntity(Entity entity) {
        Collection<Entity> entities = this.getRelatedEntities(entity);
        if (entities != null && entities.size() == 1) {
            return entities.iterator().next();
        }
        return null;
    }

    protected Set<String> getRelatedEntityIds(Entity entity) {
        Attribute relatedAttr = entity.getAttribute(this.relationAttribute);
        HashSet<String> foundIds = new HashSet<String>();
        if (relatedAttr != null && relatedAttr.getDefinition().isMultiValue()) {
            foundIds.addAll(relatedAttr.getValues());
        }
        return foundIds;
    }

    public EntityDAO getToEntitySearch() {
        return this.toEntitySearch;
    }

    public void setToEntitySearch(EntityDAO toEntitySearch) {
        this.toEntitySearch = toEntitySearch;
    }

    public String getRelationAttribute() {
        return this.relationAttribute;
    }

    public void setRelationAttribute(String relationAttribute) {
        this.relationAttribute = relationAttribute;
    }
}

