/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.ldap.dao.EntityDAO;
import org.apache.jetspeed.security.mapping.ldap.dao.impl.AbstractRelationDAO;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeBasedRelationDAO
extends AbstractRelationDAO {
    private String relationAttribute;
    private boolean useFromEntityAttribute;
    private boolean attributeContainsInternalId;

    @Override
    public Collection<Entity> getRelatedEntitiesFrom(EntityDAO fromDAO, EntityDAO toDAO, Entity fromEntity) {
        return this.internalGetRelatedEntities(fromDAO, toDAO, this.useFromEntityAttribute, fromEntity);
    }

    @Override
    public Collection<Entity> getRelatedEntitiesTo(EntityDAO fromDAO, EntityDAO toDAO, Entity toEntity) {
        return this.internalGetRelatedEntities(toDAO, fromDAO, !this.useFromEntityAttribute, toEntity);
    }

    private Collection<Entity> internalGetRelatedEntities(EntityDAO fromDAO, EntityDAO toDAO, boolean useFromEntityAttribute, Entity entity) {
        if (useFromEntityAttribute) {
            Attribute relationAttrValue = entity.getAttribute(this.relationAttribute);
            if (relationAttrValue != null) {
                Collection<String> values = relationAttrValue.getValues();
                if (this.attributeContainsInternalId) {
                    return toDAO.getEntitiesByInternalId(values);
                }
                return toDAO.getEntitiesById(values);
            }
        } else {
            String fromEntityUsedIdValue;
            String string = fromEntityUsedIdValue = this.attributeContainsInternalId ? this.getInternalId(entity, fromDAO) : entity.getId();
            if (!StringUtils.isEmpty((String)fromEntityUsedIdValue)) {
                EqualsFilter roleMemberAttrFilter = new EqualsFilter(this.relationAttribute, fromEntityUsedIdValue);
                return toDAO.getEntities((Filter)roleMemberAttrFilter);
            }
        }
        return null;
    }

    private String getInternalId(Entity entity, EntityDAO entityDao) {
        if (StringUtils.isEmpty((String)entity.getInternalId())) {
            entity = entityDao.getEntity(entity.getId());
            return entity.getInternalId();
        }
        return entity.getInternalId();
    }

    public void setRelationAttribute(String relationAttribute) {
        this.relationAttribute = relationAttribute;
    }

    public void setUseFromEntityAttribute(boolean useFromEntityAttribute) {
        this.useFromEntityAttribute = useFromEntityAttribute;
    }

    public void setAttributeContainsInternalId(boolean attributeContainsInternalId) {
        this.attributeContainsInternalId = attributeContainsInternalId;
    }

    private Entity getLiveEntity(EntityDAO dao, Entity transientEntity) throws SecurityException {
        Entity liveEntity = dao.getEntity(transientEntity.getId());
        if (liveEntity == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(transientEntity.getType(), (Object)transientEntity.getId()));
        }
        if (liveEntity.getInternalId() == null) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"getLiveEntity", (Object)"Internal ID not found"));
        }
        return liveEntity;
    }

    private void internalAddRelation(EntityDAO fromEntityDAO, EntityDAO toEntityDAO, Entity fromEntity, Entity toEntity) throws SecurityException {
        fromEntity = this.getLiveEntity(fromEntityDAO, fromEntity);
        toEntity = this.getLiveEntity(toEntityDAO, toEntity);
        String attrValue = null;
        attrValue = this.attributeContainsInternalId ? toEntity.getInternalId() : toEntity.getId();
        Attribute relationAttribute = fromEntity.getAttribute(this.relationAttribute);
        if (relationAttribute == null) {
            fromEntity.setAttribute(this.relationAttribute, new ArrayList<String>());
        } else if (relationAttribute.getValues().contains(attrValue)) {
            throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_ALREADY_EXISTS.createScoped(fromEntity.getType(), (Object)fromEntity.getId(), (Object)relationAttribute, (Object)toEntity.getId()));
        }
        if (relationAttribute.getDefinition().isMultiValue()) {
            relationAttribute.getValues().add(attrValue);
        } else {
            relationAttribute.setValue(attrValue);
        }
        fromEntityDAO.updateInternalAttributes(fromEntity);
    }

    private void internalRemoveRelation(EntityDAO fromEntityDAO, EntityDAO toEntityDAO, Entity fromEntity, Entity toEntity) throws SecurityException {
        fromEntity = fromEntityDAO.getEntity(fromEntity.getId());
        toEntity = toEntityDAO.getEntity(toEntity.getId());
        String attrValue = null;
        if (this.attributeContainsInternalId) {
            if (toEntity.getInternalId() == null) {
                toEntity = toEntityDAO.getEntity(toEntity.getId());
            }
            attrValue = toEntity.getInternalId();
        } else {
            attrValue = toEntity.getId();
        }
        Attribute relationAttribute = fromEntity.getAttribute(this.relationAttribute);
        if (relationAttribute.getDefinition().isMultiValue()) {
            DistinguishedName attrib = new DistinguishedName(attrValue);
            if (this.attributeContainsInternalId) {
                boolean found = false;
                String attribValue = null;
                Iterator<String> iterator = relationAttribute.getValues().iterator();
                while (iterator.hasNext() && !found) {
                    attribValue = iterator.next();
                    DistinguishedName ldapAttr = new DistinguishedName(attribValue);
                    if (!ldapAttr.equals((Object)attrib)) continue;
                    relationAttribute.getValues().remove(attribValue);
                    found = true;
                }
            } else {
                relationAttribute.getValues().remove(attrValue);
            }
        } else {
            relationAttribute.setValue(null);
        }
        fromEntityDAO.updateInternalAttributes(fromEntity);
    }

    @Override
    public void addRelation(EntityDAO sourceDao, EntityDAO targetDao, Entity sourceEntity, Entity targetEntity) throws SecurityException {
        if (this.useFromEntityAttribute) {
            this.internalAddRelation(sourceDao, targetDao, sourceEntity, targetEntity);
        } else {
            this.internalAddRelation(targetDao, sourceDao, targetEntity, sourceEntity);
        }
    }

    @Override
    public void removeRelation(EntityDAO sourceDao, EntityDAO targetDao, Entity sourceEntity, Entity targetEntity) throws SecurityException {
        if (this.useFromEntityAttribute) {
            this.internalRemoveRelation(sourceDao, targetDao, sourceEntity, targetEntity);
        } else {
            this.internalRemoveRelation(targetDao, sourceDao, targetEntity, sourceEntity);
        }
    }
}

