/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.security.JetspeedPrincipalManager;
import org.apache.jetspeed.security.JetspeedPrincipalManagerProvider;
import org.apache.jetspeed.security.JetspeedPrincipalType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedPrincipalManagerProviderImpl
implements JetspeedPrincipalManagerProvider {
    private Map<String, JetspeedPrincipalType> nameMap = new HashMap<String, JetspeedPrincipalType>();
    private Map<String, JetspeedPrincipalType> classNameMap = new HashMap<String, JetspeedPrincipalType>();
    private Map<String, JetspeedPrincipalManager> managersMap = new HashMap<String, JetspeedPrincipalManager>();

    public JetspeedPrincipalManagerProviderImpl(Set<JetspeedPrincipalManager> managers) {
        for (JetspeedPrincipalManager m : managers) {
            JetspeedPrincipalType type = m.getPrincipalType();
            if (this.nameMap.containsKey(type.getName())) {
                throw new IllegalArgumentException("Duplicate JetspeedPrincipalType.name " + type.getName());
            }
            if (this.classNameMap.containsKey(type.getClassName())) {
                throw new IllegalArgumentException("Duplicate JetspeedPrincipalType.className " + type.getClassName());
            }
            this.nameMap.put(type.getName(), type);
            this.classNameMap.put(type.getClassName(), type);
            this.managersMap.put(type.getName(), m);
        }
        this.nameMap = Collections.unmodifiableMap(this.nameMap);
    }

    public JetspeedPrincipalManager getManager(JetspeedPrincipalType type) {
        return this.managersMap.get(type.getName());
    }

    public JetspeedPrincipalType getPrincipalType(String name) {
        return this.nameMap.get(name);
    }

    public JetspeedPrincipalType getPrincipalTypeByClassName(String className) {
        return this.classNameMap.get(className);
    }

    public Map<String, JetspeedPrincipalType> getPrincipalTypeMap() {
        return this.nameMap;
    }

    public void destroy() {
        this.nameMap = null;
        this.classNameMap = null;
        this.managersMap = null;
    }
}

